/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.PhantomModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.PhantomEyesLayer;
import net.minecraft.client.renderer.entity.state.PhantomRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Phantom;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class PhantomRenderer
extends MobRenderer<Phantom, PhantomRenderState, PhantomModel> {
    private static final ResourceLocation PHANTOM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/phantom.png");

    public PhantomRenderer(EntityRendererProvider.Context p_174338_) {
        super(p_174338_, new PhantomModel(p_174338_.bakeLayer(ModelLayers.PHANTOM)), 0.75f);
        this.addLayer(new PhantomEyesLayer(this));
    }

    @Override
    public ResourceLocation getTextureLocation(PhantomRenderState p_363735_) {
        return PHANTOM_LOCATION;
    }

    @Override
    public PhantomRenderState createRenderState() {
        return new PhantomRenderState();
    }

    @Override
    public void extractRenderState(Phantom p_362124_, PhantomRenderState p_363079_, float p_363625_) {
        super.extractRenderState(p_362124_, p_363079_, p_363625_);
        p_363079_.flapTime = (float)p_362124_.getUniqueFlapTickOffset() + p_363079_.ageInTicks;
        p_363079_.size = p_362124_.getPhantomSize();
    }

    @Override
    protected void scale(PhantomRenderState p_364542_, PoseStack p_115682_) {
        float f = 1.0f + 0.15f * (float)p_364542_.size;
        p_115682_.scale(f, f, f);
        p_115682_.translate(0.0f, 1.3125f, 0.1875f);
    }

    @Override
    protected void setupRotations(PhantomRenderState p_363004_, PoseStack p_115686_, float p_115687_, float p_115688_) {
        super.setupRotations(p_363004_, p_115686_, p_115687_, p_115688_);
        p_115686_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(p_363004_.xRot));
    }
}

