/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.PandaModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.PandaHoldsItemLayer;
import net.minecraft.client.renderer.entity.state.HoldingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PandaRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Panda;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class PandaRenderer
extends AgeableMobRenderer<Panda, PandaRenderState, PandaModel> {
    private static final Map<Panda.Gene, ResourceLocation> TEXTURES = Maps.newEnumMap(Map.of(Panda.Gene.NORMAL, ResourceLocation.withDefaultNamespace("textures/entity/panda/panda.png"), Panda.Gene.LAZY, ResourceLocation.withDefaultNamespace("textures/entity/panda/lazy_panda.png"), Panda.Gene.WORRIED, ResourceLocation.withDefaultNamespace("textures/entity/panda/worried_panda.png"), Panda.Gene.PLAYFUL, ResourceLocation.withDefaultNamespace("textures/entity/panda/playful_panda.png"), Panda.Gene.BROWN, ResourceLocation.withDefaultNamespace("textures/entity/panda/brown_panda.png"), Panda.Gene.WEAK, ResourceLocation.withDefaultNamespace("textures/entity/panda/weak_panda.png"), Panda.Gene.AGGRESSIVE, ResourceLocation.withDefaultNamespace("textures/entity/panda/aggressive_panda.png")));

    public PandaRenderer(EntityRendererProvider.Context p_174334_) {
        super(p_174334_, new PandaModel(p_174334_.bakeLayer(ModelLayers.PANDA)), new PandaModel(p_174334_.bakeLayer(ModelLayers.PANDA_BABY)), 0.9f);
        this.addLayer(new PandaHoldsItemLayer(this));
    }

    @Override
    public ResourceLocation getTextureLocation(PandaRenderState p_364827_) {
        return TEXTURES.getOrDefault(p_364827_.variant, TEXTURES.get(Panda.Gene.NORMAL));
    }

    @Override
    public PandaRenderState createRenderState() {
        return new PandaRenderState();
    }

    @Override
    public void extractRenderState(Panda p_363780_, PandaRenderState p_363283_, float p_360846_) {
        super.extractRenderState(p_363780_, p_363283_, p_360846_);
        HoldingEntityRenderState.extractHoldingEntityRenderState(p_363780_, p_363283_, this.itemModelResolver);
        p_363283_.variant = p_363780_.getVariant();
        p_363283_.isUnhappy = p_363780_.getUnhappyCounter() > 0;
        p_363283_.isSneezing = p_363780_.isSneezing();
        p_363283_.sneezeTime = p_363780_.getSneezeCounter();
        p_363283_.isEating = p_363780_.isEating();
        p_363283_.isScared = p_363780_.isScared();
        p_363283_.isSitting = p_363780_.isSitting();
        p_363283_.sitAmount = p_363780_.getSitAmount(p_360846_);
        p_363283_.lieOnBackAmount = p_363780_.getLieOnBackAmount(p_360846_);
        p_363283_.rollAmount = p_363780_.isBaby() ? 0.0f : p_363780_.getRollAmount(p_360846_);
        p_363283_.rollTime = p_363780_.rollCounter > 0 ? (float)p_363780_.rollCounter + p_360846_ : 0.0f;
    }

    @Override
    protected void setupRotations(PandaRenderState p_362586_, PoseStack p_115634_, float p_115635_, float p_115636_) {
        float f9;
        float f7;
        super.setupRotations(p_362586_, p_115634_, p_115635_, p_115636_);
        if (p_362586_.rollTime > 0.0f) {
            float f2;
            float f = Mth.frac(p_362586_.rollTime);
            int i = Mth.floor(p_362586_.rollTime);
            int j = i + 1;
            float f1 = 7.0f;
            float f3 = f2 = p_362586_.isBaby ? 0.3f : 0.8f;
            if ((float)i < 8.0f) {
                float f4 = 90.0f * (float)i / 7.0f;
                float f5 = 90.0f * (float)j / 7.0f;
                float f32 = this.getAngle(f4, f5, j, f, 8.0f);
                p_115634_.translate(0.0f, (f2 + 0.2f) * (f32 / 90.0f), 0.0f);
                p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-f32));
            } else if ((float)i < 16.0f) {
                float f14 = ((float)i - 8.0f) / 7.0f;
                float f17 = 90.0f + 90.0f * f14;
                float f6 = 90.0f + 90.0f * ((float)j - 8.0f) / 7.0f;
                float f11 = this.getAngle(f17, f6, j, f, 16.0f);
                p_115634_.translate(0.0f, f2 + 0.2f + (f2 - 0.2f) * (f11 - 90.0f) / 90.0f, 0.0f);
                p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-f11));
            } else if ((float)i < 24.0f) {
                float f15 = ((float)i - 16.0f) / 7.0f;
                float f18 = 180.0f + 90.0f * f15;
                float f20 = 180.0f + 90.0f * ((float)j - 16.0f) / 7.0f;
                float f12 = this.getAngle(f18, f20, j, f, 24.0f);
                p_115634_.translate(0.0f, f2 + f2 * (270.0f - f12) / 90.0f, 0.0f);
                p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-f12));
            } else if (i < 32) {
                float f16 = ((float)i - 24.0f) / 7.0f;
                float f19 = 270.0f + 90.0f * f16;
                float f21 = 270.0f + 90.0f * ((float)j - 24.0f) / 7.0f;
                float f13 = this.getAngle(f19, f21, j, f, 32.0f);
                p_115634_.translate(0.0f, f2 * ((360.0f - f13) / 90.0f), 0.0f);
                p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-f13));
            }
        }
        if ((f7 = p_362586_.sitAmount) > 0.0f) {
            p_115634_.translate(0.0f, 0.8f * f7, 0.0f);
            p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp(f7, p_362586_.xRot, p_362586_.xRot + 90.0f)));
            p_115634_.translate(0.0f, -1.0f * f7, 0.0f);
            if (p_362586_.isScared) {
                float f8 = (float)(Math.cos(p_362586_.ageInTicks * 1.25f) * Math.PI * (double)0.05f);
                p_115634_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f8));
                if (p_362586_.isBaby) {
                    p_115634_.translate(0.0f, 0.8f, 0.55f);
                }
            }
        }
        if ((f9 = p_362586_.lieOnBackAmount) > 0.0f) {
            float f10 = p_362586_.isBaby ? 0.5f : 1.3f;
            p_115634_.translate(0.0f, f10 * f9, 0.0f);
            p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp(f9, p_362586_.xRot, p_362586_.xRot + 180.0f)));
        }
    }

    private float getAngle(float p_115625_, float p_115626_, int p_115627_, float p_115628_, float p_115629_) {
        return (float)p_115627_ < p_115629_ ? Mth.lerp(p_115628_, p_115625_, p_115626_) : p_115625_;
    }
}

