/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class LivingEntityRenderer<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends EntityRenderer<T, S>
implements RenderLayerParent<S, M> {
    private static final float EYE_BED_OFFSET = 0.1f;
    protected M model;
    protected final ItemModelResolver itemModelResolver;
    protected final List<RenderLayer<S, M>> layers = Lists.newArrayList();

    public LivingEntityRenderer(EntityRendererProvider.Context p_174289_, M p_174290_, float p_174291_) {
        super(p_174289_);
        this.itemModelResolver = p_174289_.getItemModelResolver();
        this.model = p_174290_;
        this.shadowRadius = p_174291_;
    }

    public final boolean addLayer(RenderLayer<S, M> p_115327_) {
        return this.layers.add(p_115327_);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    protected AABB getBoundingBoxForCulling(T p_360864_) {
        AABB aabb = super.getBoundingBoxForCulling(p_360864_);
        if (((LivingEntity)p_360864_).getItemBySlot(EquipmentSlot.HEAD).is(Items.DRAGON_HEAD)) {
            float f = 0.5f;
            return aabb.inflate(0.5, 0.5, 0.5);
        }
        return aabb;
    }

    @Override
    public void render(S p_361886_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        Direction direction;
        if (((RenderLivingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(p_361886_, this, ((LivingEntityRenderState)((Object)p_361886_)).partialTick, p_115311_, p_115312_, p_115313_))).isCanceled()) {
            return;
        }
        p_115311_.pushPose();
        if (((LivingEntityRenderState)((Object)p_361886_)).hasPose(Pose.SLEEPING) && (direction = ((LivingEntityRenderState)((Object)p_361886_)).bedOrientation) != null) {
            float f = ((LivingEntityRenderState)((Object)p_361886_)).eyeHeight - 0.1f;
            p_115311_.translate((float)(-direction.getStepX()) * f, 0.0f, (float)(-direction.getStepZ()) * f);
        }
        float f1 = ((LivingEntityRenderState)((Object)p_361886_)).scale;
        p_115311_.scale(f1, f1, f1);
        this.setupRotations(p_361886_, p_115311_, ((LivingEntityRenderState)((Object)p_361886_)).bodyRot, f1);
        p_115311_.scale(-1.0f, -1.0f, 1.0f);
        this.scale(p_361886_, p_115311_);
        p_115311_.translate(0.0f, -1.501f, 0.0f);
        ((EntityModel)this.model).setupAnim(p_361886_);
        boolean flag1 = this.isBodyVisible(p_361886_);
        boolean flag = !flag1 && !((LivingEntityRenderState)((Object)p_361886_)).isInvisibleToPlayer;
        RenderType rendertype = this.getRenderType(p_361886_, flag1, flag, ((LivingEntityRenderState)((Object)p_361886_)).appearsGlowing);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = p_115312_.getBuffer(rendertype);
            int i = LivingEntityRenderer.getOverlayCoords(p_361886_, this.getWhiteOverlayProgress(p_361886_));
            int j = flag ? 0x26FFFFFF : -1;
            int k = ARGB.multiply(j, this.getModelTint(p_361886_));
            ((Model)this.model).renderToBuffer(p_115311_, vertexconsumer, p_115313_, i, k);
        }
        if (this.shouldRenderLayers(p_361886_)) {
            for (RenderLayer<S, M> renderlayer : this.layers) {
                renderlayer.render(p_115311_, p_115312_, p_115313_, p_361886_, ((LivingEntityRenderState)((Object)p_361886_)).yRot, ((LivingEntityRenderState)((Object)p_361886_)).xRot);
            }
        }
        p_115311_.popPose();
        super.render(p_361886_, p_115311_, p_115312_, p_115313_);
        NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(p_361886_, this, ((LivingEntityRenderState)((Object)p_361886_)).partialTick, p_115311_, p_115312_, p_115313_));
    }

    protected boolean shouldRenderLayers(S p_364697_) {
        return true;
    }

    protected int getModelTint(S p_360502_) {
        return -1;
    }

    public abstract ResourceLocation getTextureLocation(S var1);

    @Nullable
    protected RenderType getRenderType(S p_360858_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation(p_360858_);
        if (p_115324_) {
            return RenderType.itemEntityTranslucentCull(resourcelocation);
        }
        if (p_115323_) {
            return ((Model)this.model).renderType(resourcelocation);
        }
        return p_115325_ ? RenderType.outline(resourcelocation) : null;
    }

    public static int getOverlayCoords(LivingEntityRenderState p_362833_, float p_115340_) {
        return OverlayTexture.pack(OverlayTexture.u(p_115340_), OverlayTexture.v(p_362833_.hasRedOverlay));
    }

    protected boolean isBodyVisible(S p_361327_) {
        return !((LivingEntityRenderState)((Object)p_361327_)).isInvisible;
    }

    private static float sleepDirectionToRotation(Direction p_115329_) {
        switch (p_115329_) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean isShaking(S p_361234_) {
        return ((LivingEntityRenderState)((Object)p_361234_)).isFullyFrozen;
    }

    protected void setupRotations(S p_364714_, PoseStack p_115318_, float p_115319_, float p_115320_) {
        if (this.isShaking(p_364714_)) {
            p_115319_ += (float)(Math.cos((float)Mth.floor(((LivingEntityRenderState)((Object)p_364714_)).ageInTicks) * 3.25f) * Math.PI * (double)0.4f);
        }
        if (!((LivingEntityRenderState)((Object)p_364714_)).hasPose(Pose.SLEEPING)) {
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - p_115319_));
        }
        if (((LivingEntityRenderState)((Object)p_364714_)).deathTime > 0.0f) {
            float f = (((LivingEntityRenderState)((Object)p_364714_)).deathTime - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt(f)) > 1.0f) {
                f = 1.0f;
            }
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * this.getFlipDegrees()));
        } else if (((LivingEntityRenderState)((Object)p_364714_)).isAutoSpinAttack) {
            p_115318_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f - ((LivingEntityRenderState)((Object)p_364714_)).xRot));
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(((LivingEntityRenderState)((Object)p_364714_)).ageInTicks * -75.0f));
        } else if (((LivingEntityRenderState)((Object)p_364714_)).hasPose(Pose.SLEEPING)) {
            Direction direction = ((LivingEntityRenderState)((Object)p_364714_)).bedOrientation;
            float f1 = direction != null ? LivingEntityRenderer.sleepDirectionToRotation(direction) : p_115319_;
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f1));
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(this.getFlipDegrees()));
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
        } else if (((LivingEntityRenderState)((Object)p_364714_)).isUpsideDown) {
            p_115318_.translate(0.0f, (((LivingEntityRenderState)((Object)p_364714_)).boundingBoxHeight + 0.1f) / p_115320_, 0.0f);
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected float getFlipDegrees() {
        return 90.0f;
    }

    protected float getWhiteOverlayProgress(S p_362441_) {
        return 0.0f;
    }

    protected void scale(S p_362272_, PoseStack p_115315_) {
    }

    @Override
    protected boolean shouldShowName(T p_363517_, double p_365448_) {
        boolean flag;
        if (((Entity)p_363517_).isDiscrete()) {
            float f = 32.0f;
            if (!ClientHooks.isNameplateInRenderDistance(p_363517_, (double)p_365448_)) {
                return false;
            }
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        boolean bl = flag = !((Entity)p_363517_).isInvisibleTo(localplayer);
        if (p_363517_ != localplayer) {
            PlayerTeam team = ((Entity)p_363517_).getTeam();
            PlayerTeam team1 = localplayer.getTeam();
            if (team != null) {
                Team.Visibility team$visibility = ((Team)team).getNameTagVisibility();
                switch (team$visibility) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.isAlliedTo(team1) && (((Team)team).canSeeFriendlyInvisibles() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.isAlliedTo(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.renderNames() && p_363517_ != minecraft.getCameraEntity() && flag && !((Entity)p_363517_).isVehicle();
    }

    public static boolean isEntityUpsideDown(LivingEntity p_194454_) {
        String s;
        if ((p_194454_ instanceof Player || p_194454_.hasCustomName()) && ("Dinnerbone".equals(s = ChatFormatting.stripFormatting(p_194454_.getName().getString())) || "Grumm".equals(s))) {
            Player player;
            return !(p_194454_ instanceof Player && !(player = (Player)p_194454_).isModelPartShown(PlayerModelPart.CAPE));
        }
        return false;
    }

    @Override
    protected float getShadowRadius(S p_361012_) {
        return super.getShadowRadius(p_361012_) * ((LivingEntityRenderState)((Object)p_361012_)).scale;
    }

    @Override
    public void extractRenderState(T p_362733_, S p_360515_, float p_361157_) {
        BlockItem blockitem;
        super.extractRenderState(p_362733_, p_360515_, p_361157_);
        float f = Mth.rotLerp(p_361157_, ((LivingEntity)p_362733_).yHeadRotO, ((LivingEntity)p_362733_).yHeadRot);
        ((LivingEntityRenderState)((Object)p_360515_)).bodyRot = LivingEntityRenderer.solveBodyRot(p_362733_, f, p_361157_);
        ((LivingEntityRenderState)((Object)p_360515_)).yRot = Mth.wrapDegrees(f - ((LivingEntityRenderState)((Object)p_360515_)).bodyRot);
        ((LivingEntityRenderState)((Object)p_360515_)).xRot = ((Entity)p_362733_).getXRot(p_361157_);
        ((LivingEntityRenderState)((Object)p_360515_)).customName = ((Entity)p_362733_).getCustomName();
        ((LivingEntityRenderState)((Object)p_360515_)).isUpsideDown = LivingEntityRenderer.isEntityUpsideDown(p_362733_);
        if (((LivingEntityRenderState)((Object)p_360515_)).isUpsideDown) {
            ((LivingEntityRenderState)((Object)p_360515_)).xRot *= -1.0f;
            ((LivingEntityRenderState)((Object)p_360515_)).yRot *= -1.0f;
        }
        if (!((Entity)p_362733_).isPassenger() && ((LivingEntity)p_362733_).isAlive()) {
            ((LivingEntityRenderState)((Object)p_360515_)).walkAnimationPos = ((LivingEntity)p_362733_).walkAnimation.position(p_361157_);
            ((LivingEntityRenderState)((Object)p_360515_)).walkAnimationSpeed = ((LivingEntity)p_362733_).walkAnimation.speed(p_361157_);
        } else {
            ((LivingEntityRenderState)((Object)p_360515_)).walkAnimationPos = 0.0f;
            ((LivingEntityRenderState)((Object)p_360515_)).walkAnimationSpeed = 0.0f;
        }
        Entity entity = ((Entity)p_362733_).getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            ((LivingEntityRenderState)((Object)p_360515_)).wornHeadAnimationPos = livingentity.walkAnimation.position(p_361157_);
        } else {
            ((LivingEntityRenderState)((Object)p_360515_)).wornHeadAnimationPos = ((LivingEntityRenderState)((Object)p_360515_)).walkAnimationPos;
        }
        ((LivingEntityRenderState)((Object)p_360515_)).scale = ((LivingEntity)p_362733_).getScale();
        ((LivingEntityRenderState)((Object)p_360515_)).ageScale = ((LivingEntity)p_362733_).getAgeScale();
        ((LivingEntityRenderState)((Object)p_360515_)).pose = ((Entity)p_362733_).getPose();
        ((LivingEntityRenderState)((Object)p_360515_)).bedOrientation = ((LivingEntity)p_362733_).getBedOrientation();
        if (((LivingEntityRenderState)((Object)p_360515_)).bedOrientation != null) {
            ((LivingEntityRenderState)((Object)p_360515_)).eyeHeight = ((Entity)p_362733_).getEyeHeight(Pose.STANDING);
        }
        ((LivingEntityRenderState)((Object)p_360515_)).isFullyFrozen = ((Entity)p_362733_).isFullyFrozen();
        ((LivingEntityRenderState)((Object)p_360515_)).isBaby = ((LivingEntity)p_362733_).isBaby();
        ((LivingEntityRenderState)((Object)p_360515_)).isInWater = ((Entity)p_362733_).isInWater() || p_362733_.isInFluidType((fluidType, height) -> p_362733_.canSwimInFluidType(fluidType));
        ((LivingEntityRenderState)((Object)p_360515_)).isAutoSpinAttack = ((LivingEntity)p_362733_).isAutoSpinAttack();
        ((LivingEntityRenderState)((Object)p_360515_)).hasRedOverlay = ((LivingEntity)p_362733_).hurtTime > 0 || ((LivingEntity)p_362733_).deathTime > 0;
        ItemStack itemstack = ((LivingEntity)p_362733_).getItemBySlot(EquipmentSlot.HEAD);
        FeatureElement featureElement = itemstack.getItem();
        if (featureElement instanceof BlockItem && (featureElement = (blockitem = (BlockItem)featureElement).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock abstractskullblock = (AbstractSkullBlock)featureElement;
            ((LivingEntityRenderState)((Object)p_360515_)).wornHeadType = abstractskullblock.getType();
            ((LivingEntityRenderState)((Object)p_360515_)).wornHeadProfile = itemstack.get(DataComponents.PROFILE);
            ((LivingEntityRenderState)((Object)p_360515_)).headItem.clear();
        } else {
            ((LivingEntityRenderState)((Object)p_360515_)).wornHeadType = null;
            ((LivingEntityRenderState)((Object)p_360515_)).wornHeadProfile = null;
            if (!HumanoidArmorLayer.shouldRender(itemstack, EquipmentSlot.HEAD)) {
                this.itemModelResolver.updateForLiving(((LivingEntityRenderState)((Object)p_360515_)).headItem, itemstack, ItemDisplayContext.HEAD, (LivingEntity)p_362733_);
            } else {
                ((LivingEntityRenderState)((Object)p_360515_)).headItem.clear();
            }
        }
        ((LivingEntityRenderState)((Object)p_360515_)).deathTime = ((LivingEntity)p_362733_).deathTime > 0 ? (float)((LivingEntity)p_362733_).deathTime + p_361157_ : 0.0f;
        Minecraft minecraft = Minecraft.getInstance();
        ((LivingEntityRenderState)((Object)p_360515_)).isInvisibleToPlayer = ((LivingEntityRenderState)((Object)p_360515_)).isInvisible && ((Entity)p_362733_).isInvisibleTo(minecraft.player);
        ((LivingEntityRenderState)((Object)p_360515_)).appearsGlowing = minecraft.shouldEntityAppearGlowing((Entity)p_362733_);
    }

    @Override
    protected void extractAdditionalHitboxes(T p_412552_, ImmutableList.Builder<HitboxRenderState> p_412540_, float p_412715_) {
        AABB aabb = ((Entity)p_412552_).getBoundingBox();
        float f = 0.01f;
        HitboxRenderState hitboxrenderstate = new HitboxRenderState(aabb.minX - ((Entity)p_412552_).getX(), ((Entity)p_412552_).getEyeHeight() - 0.01f, aabb.minZ - ((Entity)p_412552_).getZ(), aabb.maxX - ((Entity)p_412552_).getX(), ((Entity)p_412552_).getEyeHeight() + 0.01f, aabb.maxZ - ((Entity)p_412552_).getZ(), 1.0f, 0.0f, 0.0f);
        p_412540_.add((Object)hitboxrenderstate);
    }

    private static float solveBodyRot(LivingEntity p_362839_, float p_361247_, float p_361564_) {
        Entity entity = p_362839_.getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            float f2 = Mth.rotLerp(p_361564_, livingentity.yBodyRotO, livingentity.yBodyRot);
            float f = 85.0f;
            float f1 = Mth.clamp(Mth.wrapDegrees(p_361247_ - f2), -85.0f, 85.0f);
            f2 = p_361247_ - f1;
            if (Math.abs(f1) > 50.0f) {
                f2 += f1 * 0.2f;
            }
            return f2;
        }
        return Mth.rotLerp(p_361564_, p_362839_.yBodyRotO, p_362839_.yBodyRot);
    }
}

