/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ItemEntityRenderer
extends EntityRenderer<ItemEntity, ItemEntityRenderState> {
    private static final float ITEM_MIN_HOVER_HEIGHT = 0.0625f;
    private static final float ITEM_BUNDLE_OFFSET_SCALE = 0.15f;
    private static final float FLAT_ITEM_DEPTH_THRESHOLD = 0.0625f;
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();

    public ItemEntityRenderer(EntityRendererProvider.Context p_174198_) {
        super(p_174198_);
        this.itemModelResolver = p_174198_.getItemModelResolver();
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    @Override
    public ItemEntityRenderState createRenderState() {
        return new ItemEntityRenderState();
    }

    @Override
    public void extractRenderState(ItemEntity p_362393_, ItemEntityRenderState p_361441_, float p_360849_) {
        super.extractRenderState(p_362393_, p_361441_, p_360849_);
        p_361441_.ageInTicks = (float)p_362393_.getAge() + p_360849_;
        p_361441_.bobOffset = p_362393_.bobOffs;
        p_361441_.shouldBob = IClientItemExtensions.of((ItemStack)p_362393_.getItem()).shouldBobAsEntity(p_362393_.getItem());
        p_361441_.shouldSpread = IClientItemExtensions.of((ItemStack)p_362393_.getItem()).shouldSpreadAsEntity(p_362393_.getItem());
        p_361441_.extractItemGroupRenderState(p_362393_, p_362393_.getItem(), this.itemModelResolver);
    }

    @Override
    public void render(ItemEntityRenderState p_362172_, PoseStack p_115030_, MultiBufferSource p_115031_, int p_115032_) {
        if (!p_362172_.item.isEmpty()) {
            p_115030_.pushPose();
            AABB aabb = p_362172_.item.getModelBoundingBox();
            float f = -((float)aabb.minY) + 0.0625f;
            float f1 = p_362172_.shouldBob ? Mth.sin(p_362172_.ageInTicks / 10.0f + p_362172_.bobOffset) * 0.1f + 0.1f : 0.0f;
            p_115030_.translate(0.0f, f1 + f, 0.0f);
            float f2 = ItemEntity.getSpin(p_362172_.ageInTicks, p_362172_.bobOffset);
            p_115030_.mulPose((Quaternionfc)Axis.YP.rotation(f2));
            ItemEntityRenderer.renderMultipleFromCount(p_115030_, p_115031_, p_115032_, p_362172_, this.random, aabb);
            p_115030_.popPose();
            super.render(p_362172_, p_115030_, p_115031_, p_115032_);
        }
    }

    public static void renderMultipleFromCount(PoseStack p_323763_, MultiBufferSource p_324606_, int p_323603_, ItemClusterRenderState p_388704_, RandomSource p_324507_) {
        ItemEntityRenderer.renderMultipleFromCount(p_323763_, p_324606_, p_323603_, p_388704_, p_324507_, p_388704_.item.getModelBoundingBox());
    }

    public static void renderMultipleFromCount(PoseStack p_404890_, MultiBufferSource p_405782_, int p_404762_, ItemClusterRenderState p_405697_, RandomSource p_404894_, AABB p_405524_) {
        block6: {
            int i = p_405697_.count;
            if (i == 0) break block6;
            p_404894_.setSeed(p_405697_.seed);
            ItemStackRenderState itemstackrenderstate = p_405697_.item;
            float f = (float)p_405524_.getZsize();
            if (f > 0.0625f) {
                itemstackrenderstate.render(p_404890_, p_405782_, p_404762_, OverlayTexture.NO_OVERLAY);
                for (int j = 1; j < i; ++j) {
                    p_404890_.pushPose();
                    float f1 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f2 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f3 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    if (p_405697_.shouldSpread) {
                        p_404890_.translate(f1, f2, f3);
                    }
                    itemstackrenderstate.render(p_404890_, p_405782_, p_404762_, OverlayTexture.NO_OVERLAY);
                    p_404890_.popPose();
                }
            } else {
                float f4 = f * 1.5f;
                p_404890_.translate(0.0f, 0.0f, -(f4 * (float)(i - 1) / 2.0f));
                itemstackrenderstate.render(p_404890_, p_405782_, p_404762_, OverlayTexture.NO_OVERLAY);
                p_404890_.translate(0.0f, 0.0f, f4);
                for (int k = 1; k < i; ++k) {
                    p_404890_.pushPose();
                    float f5 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float f6 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    if (p_405697_.shouldSpread) {
                        p_404890_.translate(f5, f6, 0.0f);
                    }
                    itemstackrenderstate.render(p_404890_, p_405782_, p_404762_, OverlayTexture.NO_OVERLAY);
                    p_404890_.popPose();
                    p_404890_.translate(0.0f, 0.0f, f4);
                }
            }
        }
    }
}

