/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.GuardianModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.GuardianRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class GuardianRenderer
extends MobRenderer<Guardian, GuardianRenderState, GuardianModel> {
    private static final ResourceLocation GUARDIAN_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/guardian.png");
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull(GUARDIAN_BEAM_LOCATION);

    public GuardianRenderer(EntityRendererProvider.Context p_174159_) {
        this(p_174159_, 0.5f, ModelLayers.GUARDIAN);
    }

    protected GuardianRenderer(EntityRendererProvider.Context p_174161_, float p_174162_, ModelLayerLocation p_174163_) {
        super(p_174161_, new GuardianModel(p_174161_.bakeLayer(p_174163_)), p_174162_);
    }

    @Override
    public boolean shouldRender(Guardian p_114836_, Frustum p_114837_, double p_114838_, double p_114839_, double p_114840_) {
        LivingEntity livingentity;
        if (super.shouldRender(p_114836_, p_114837_, p_114838_, p_114839_, p_114840_)) {
            return true;
        }
        if (p_114836_.hasActiveAttackTarget() && (livingentity = p_114836_.getActiveAttackTarget()) != null) {
            Vec3 vec3 = this.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, 1.0f);
            Vec3 vec31 = this.getPosition(p_114836_, p_114836_.getEyeHeight(), 1.0f);
            return p_114837_.isVisible(new AABB(vec31.x, vec31.y, vec31.z, vec3.x, vec3.y, vec3.z));
        }
        return false;
    }

    private Vec3 getPosition(LivingEntity p_114803_, double p_114804_, float p_114805_) {
        double d0 = Mth.lerp((double)p_114805_, p_114803_.xOld, p_114803_.getX());
        double d1 = Mth.lerp((double)p_114805_, p_114803_.yOld, p_114803_.getY()) + p_114804_;
        double d2 = Mth.lerp((double)p_114805_, p_114803_.zOld, p_114803_.getZ());
        return new Vec3(d0, d1, d2);
    }

    @Override
    public void render(GuardianRenderState p_363200_, PoseStack p_114793_, MultiBufferSource p_114794_, int p_114795_) {
        super.render(p_363200_, p_114793_, p_114794_, p_114795_);
        Vec3 vec3 = p_363200_.attackTargetPosition;
        if (vec3 != null) {
            float f = p_363200_.attackTime * 0.5f % 1.0f;
            p_114793_.pushPose();
            p_114793_.translate(0.0f, p_363200_.eyeHeight, 0.0f);
            GuardianRenderer.renderBeam(p_114793_, p_114794_.getBuffer(BEAM_RENDER_TYPE), vec3.subtract(p_363200_.eyePosition), p_363200_.attackTime, p_363200_.attackScale, f);
            p_114793_.popPose();
        }
    }

    private static void renderBeam(PoseStack p_363906_, VertexConsumer p_365218_, Vec3 p_360399_, float p_363920_, float p_363755_, float p_361709_) {
        float f = (float)(p_360399_.length() + 1.0);
        p_360399_ = p_360399_.normalize();
        float f1 = (float)Math.acos(p_360399_.y);
        float f2 = 1.5707964f - (float)Math.atan2(p_360399_.z, p_360399_.x);
        p_363906_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f2 * 57.295776f));
        p_363906_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f1 * 57.295776f));
        float f3 = p_363920_ * 0.05f * -1.5f;
        float f4 = p_363755_ * p_363755_;
        int i = 64 + (int)(f4 * 191.0f);
        int j = 32 + (int)(f4 * 191.0f);
        int k = 128 - (int)(f4 * 64.0f);
        float f5 = 0.2f;
        float f6 = 0.282f;
        float f7 = Mth.cos(f3 + 2.3561945f) * 0.282f;
        float f8 = Mth.sin(f3 + 2.3561945f) * 0.282f;
        float f9 = Mth.cos(f3 + 0.7853982f) * 0.282f;
        float f10 = Mth.sin(f3 + 0.7853982f) * 0.282f;
        float f11 = Mth.cos(f3 + 3.926991f) * 0.282f;
        float f12 = Mth.sin(f3 + 3.926991f) * 0.282f;
        float f13 = Mth.cos(f3 + 5.4977875f) * 0.282f;
        float f14 = Mth.sin(f3 + 5.4977875f) * 0.282f;
        float f15 = Mth.cos(f3 + (float)Math.PI) * 0.2f;
        float f16 = Mth.sin(f3 + (float)Math.PI) * 0.2f;
        float f17 = Mth.cos(f3 + 0.0f) * 0.2f;
        float f18 = Mth.sin(f3 + 0.0f) * 0.2f;
        float f19 = Mth.cos(f3 + 1.5707964f) * 0.2f;
        float f20 = Mth.sin(f3 + 1.5707964f) * 0.2f;
        float f21 = Mth.cos(f3 + 4.712389f) * 0.2f;
        float f22 = Mth.sin(f3 + 4.712389f) * 0.2f;
        float f23 = 0.0f;
        float f24 = 0.4999f;
        float f25 = -1.0f + p_361709_;
        float f26 = f25 + f * 2.5f;
        PoseStack.Pose posestack$pose = p_363906_.last();
        GuardianRenderer.vertex(p_365218_, posestack$pose, f15, f, f16, i, j, k, 0.4999f, f26);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f15, 0.0f, f16, i, j, k, 0.4999f, f25);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f17, 0.0f, f18, i, j, k, 0.0f, f25);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f17, f, f18, i, j, k, 0.0f, f26);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f19, f, f20, i, j, k, 0.4999f, f26);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f19, 0.0f, f20, i, j, k, 0.4999f, f25);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f21, 0.0f, f22, i, j, k, 0.0f, f25);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f21, f, f22, i, j, k, 0.0f, f26);
        float f27 = Mth.floor(p_363920_) % 2 == 0 ? 0.5f : 0.0f;
        GuardianRenderer.vertex(p_365218_, posestack$pose, f7, f, f8, i, j, k, 0.5f, f27 + 0.5f);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f9, f, f10, i, j, k, 1.0f, f27 + 0.5f);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f13, f, f14, i, j, k, 1.0f, f27);
        GuardianRenderer.vertex(p_365218_, posestack$pose, f11, f, f12, i, j, k, 0.5f, f27);
    }

    private static void vertex(VertexConsumer p_253637_, PoseStack.Pose p_323627_, float p_253994_, float p_254492_, float p_254474_, int p_254080_, int p_253655_, int p_254133_, float p_254233_, float p_253939_) {
        p_253637_.addVertex(p_323627_, p_253994_, p_254492_, p_254474_).setColor(p_254080_, p_253655_, p_254133_, 255).setUv(p_254233_, p_253939_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(p_323627_, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(GuardianRenderState p_363236_) {
        return GUARDIAN_LOCATION;
    }

    @Override
    public GuardianRenderState createRenderState() {
        return new GuardianRenderState();
    }

    @Override
    public void extractRenderState(Guardian p_360824_, GuardianRenderState p_360947_, float p_361770_) {
        super.extractRenderState(p_360824_, p_360947_, p_361770_);
        p_360947_.spikesAnimation = p_360824_.getSpikesAnimation(p_361770_);
        p_360947_.tailAnimation = p_360824_.getTailAnimation(p_361770_);
        p_360947_.eyePosition = p_360824_.getEyePosition(p_361770_);
        Entity entity = GuardianRenderer.getEntityToLookAt(p_360824_);
        if (entity != null) {
            p_360947_.lookDirection = p_360824_.getViewVector(p_361770_);
            p_360947_.lookAtPosition = entity.getEyePosition(p_361770_);
        } else {
            p_360947_.lookDirection = null;
            p_360947_.lookAtPosition = null;
        }
        LivingEntity livingentity = p_360824_.getActiveAttackTarget();
        if (livingentity != null) {
            p_360947_.attackScale = p_360824_.getAttackAnimationScale(p_361770_);
            p_360947_.attackTime = p_360824_.getClientSideAttackTime() + p_361770_;
            p_360947_.attackTargetPosition = this.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, p_361770_);
        } else {
            p_360947_.attackTargetPosition = null;
        }
    }

    @Nullable
    private static Entity getEntityToLookAt(Guardian p_364936_) {
        Entity entity = Minecraft.getInstance().getCameraEntity();
        return p_364936_.hasActiveAttackTarget() ? p_364936_.getActiveAttackTarget() : entity;
    }
}

