/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ExperienceOrbRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ExperienceOrb;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ExperienceOrbRenderer
extends EntityRenderer<ExperienceOrb, ExperienceOrbRenderState> {
    private static final ResourceLocation EXPERIENCE_ORB_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/experience_orb.png");
    private static final RenderType RENDER_TYPE = RenderType.itemEntityTranslucentCull(EXPERIENCE_ORB_LOCATION);

    public ExperienceOrbRenderer(EntityRendererProvider.Context p_174110_) {
        super(p_174110_);
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    @Override
    protected int getBlockLightLevel(ExperienceOrb p_114606_, BlockPos p_114607_) {
        return Mth.clamp(super.getBlockLightLevel(p_114606_, p_114607_) + 7, 0, 15);
    }

    @Override
    public void render(ExperienceOrbRenderState p_363334_, PoseStack p_114602_, MultiBufferSource p_114603_, int p_114604_) {
        p_114602_.pushPose();
        int i = p_363334_.icon;
        float f = (float)(i % 4 * 16 + 0) / 64.0f;
        float f1 = (float)(i % 4 * 16 + 16) / 64.0f;
        float f2 = (float)(i / 4 * 16 + 0) / 64.0f;
        float f3 = (float)(i / 4 * 16 + 16) / 64.0f;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        float f7 = 255.0f;
        float f8 = p_363334_.ageInTicks / 2.0f;
        int j = (int)((Mth.sin(f8 + 0.0f) + 1.0f) * 0.5f * 255.0f);
        int k = 255;
        int l = (int)((Mth.sin(f8 + 4.1887903f) + 1.0f) * 0.1f * 255.0f);
        p_114602_.translate(0.0f, 0.1f, 0.0f);
        p_114602_.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        float f9 = 0.3f;
        p_114602_.scale(0.3f, 0.3f, 0.3f);
        VertexConsumer vertexconsumer = p_114603_.getBuffer(RENDER_TYPE);
        PoseStack.Pose posestack$pose = p_114602_.last();
        ExperienceOrbRenderer.vertex(vertexconsumer, posestack$pose, -0.5f, -0.25f, j, 255, l, f, f3, p_114604_);
        ExperienceOrbRenderer.vertex(vertexconsumer, posestack$pose, 0.5f, -0.25f, j, 255, l, f1, f3, p_114604_);
        ExperienceOrbRenderer.vertex(vertexconsumer, posestack$pose, 0.5f, 0.75f, j, 255, l, f1, f2, p_114604_);
        ExperienceOrbRenderer.vertex(vertexconsumer, posestack$pose, -0.5f, 0.75f, j, 255, l, f, f2, p_114604_);
        p_114602_.popPose();
        super.render(p_363334_, p_114602_, p_114603_, p_114604_);
    }

    private static void vertex(VertexConsumer p_254515_, PoseStack.Pose p_324046_, float p_253952_, float p_254066_, int p_254283_, int p_254566_, int p_253882_, float p_254434_, float p_254223_, int p_254372_) {
        p_254515_.addVertex(p_324046_, p_253952_, p_254066_, 0.0f).setColor(p_254283_, p_254566_, p_253882_, 128).setUv(p_254434_, p_254223_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_254372_).setNormal(p_324046_, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public ExperienceOrbRenderState createRenderState() {
        return new ExperienceOrbRenderState();
    }

    @Override
    public void extractRenderState(ExperienceOrb p_364861_, ExperienceOrbRenderState p_363737_, float p_363634_) {
        super.extractRenderState(p_364861_, p_363737_, p_363634_);
        p_363737_.icon = p_364861_.getIcon();
    }
}

