/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.entity.state.HitboxesRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.entity.state.ServerHitboxesRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EntityRenderDispatcher
implements ResourceManagerReloadListener {
    private static final RenderType SHADOW_RENDER_TYPE = RenderType.entityShadow(ResourceLocation.withDefaultNamespace("textures/misc/shadow.png"));
    private static final float MAX_SHADOW_RADIUS = 32.0f;
    private static final float SHADOW_POWER_FALLOFF_Y = 0.5f;
    private Map<EntityType<?>, EntityRenderer<?, ?>> renderers = ImmutableMap.of();
    private Map<PlayerSkin.Model, EntityRenderer<? extends Player, ?>> playerRenderers = Map.of();
    public final TextureManager textureManager;
    private Level level;
    public Camera camera;
    private Quaternionf cameraOrientation;
    public Entity crosshairPickEntity;
    private final ItemModelResolver itemModelResolver;
    private final MapRenderer mapRenderer;
    private final BlockRenderDispatcher blockRenderDispatcher;
    private final ItemInHandRenderer itemInHandRenderer;
    private final Font font;
    public final Options options;
    private final Supplier<EntityModelSet> entityModels;
    private final EquipmentAssetManager equipmentAssets;
    private boolean shouldRenderShadow = true;
    private boolean renderHitBoxes;

    public <E extends Entity> int getPackedLightCoords(E p_114395_, float p_114396_) {
        return this.getRenderer((EntityRenderState)((Object)p_114395_)).getPackedLightCoords(p_114395_, p_114396_);
    }

    public EntityRenderDispatcher(Minecraft p_234579_, TextureManager p_234580_, ItemModelResolver p_388181_, ItemRenderer p_234581_, MapRenderer p_361209_, BlockRenderDispatcher p_234582_, Font p_234583_, Options p_234584_, Supplier<EntityModelSet> p_387861_, EquipmentAssetManager p_386713_) {
        this.textureManager = p_234580_;
        this.itemModelResolver = p_388181_;
        this.mapRenderer = p_361209_;
        this.itemInHandRenderer = new ItemInHandRenderer(p_234579_, this, p_234581_, p_388181_);
        this.blockRenderDispatcher = p_234582_;
        this.font = p_234583_;
        this.options = p_234584_;
        this.entityModels = p_387861_;
        this.equipmentAssets = p_386713_;
    }

    public <T extends Entity> EntityRenderer<? super T, ?> getRenderer(T p_114383_) {
        if (p_114383_ instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)p_114383_;
            PlayerSkin.Model playerskin$model = abstractclientplayer.getSkin().model();
            EntityRenderer<? extends Player, ?> entityrenderer = this.playerRenderers.get((Object)playerskin$model);
            return entityrenderer != null ? entityrenderer : this.playerRenderers.get((Object)PlayerSkin.Model.WIDE);
        }
        return this.renderers.get(p_114383_.getType());
    }

    public <S extends EntityRenderState> EntityRenderer<?, ? super S> getRenderer(S p_412312_) {
        if (p_412312_ instanceof PlayerRenderState) {
            PlayerRenderState playerrenderstate = (PlayerRenderState)p_412312_;
            PlayerSkin.Model playerskin$model = playerrenderstate.skin.model();
            EntityRenderer<? extends Player, ?> entityrenderer = this.playerRenderers.get((Object)playerskin$model);
            return entityrenderer != null ? entityrenderer : this.playerRenderers.get((Object)PlayerSkin.Model.WIDE);
        }
        return this.renderers.get(p_412312_.entityType);
    }

    public void prepare(Level p_114409_, Camera p_114410_, Entity p_114411_) {
        this.level = p_114409_;
        this.camera = p_114410_;
        this.cameraOrientation = p_114410_.rotation();
        this.crosshairPickEntity = p_114411_;
    }

    public void overrideCameraOrientation(Quaternionf p_254264_) {
        this.cameraOrientation = p_254264_;
    }

    public void setRenderShadow(boolean p_114469_) {
        this.shouldRenderShadow = p_114469_;
    }

    public void setRenderHitBoxes(boolean p_114474_) {
        this.renderHitBoxes = p_114474_;
    }

    public boolean shouldRenderHitBoxes() {
        return this.renderHitBoxes;
    }

    public <E extends Entity> boolean shouldRender(E p_114398_, Frustum p_114399_, double p_114400_, double p_114401_, double p_114402_) {
        EntityRenderer<?, E> entityrenderer = this.getRenderer((EntityRenderState)((Object)p_114398_));
        return entityrenderer.shouldRender(p_114398_, p_114399_, p_114400_, p_114401_, p_114402_);
    }

    public <E extends Entity> void render(E p_114385_, double p_114386_, double p_114387_, double p_114388_, float p_114389_, PoseStack p_114391_, MultiBufferSource p_114392_, int p_114393_) {
        EntityRenderer<?, E> entityrenderer = this.getRenderer((EntityRenderState)((Object)p_114385_));
        this.render(p_114385_, p_114386_, p_114387_, p_114388_, p_114389_, p_114391_, p_114392_, p_114393_, entityrenderer);
    }

    private <E extends Entity, S extends EntityRenderState> void render(E p_365426_, double p_364222_, double p_360564_, double p_365367_, float p_364461_, PoseStack p_363537_, MultiBufferSource p_364290_, int p_363520_, EntityRenderer<? super E, S> p_360327_) {
        S s;
        try {
            s = p_360327_.createRenderState(p_365426_, p_364461_);
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.forThrowable(throwable1, "Extracting render state for an entity in world");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being extracted");
            p_365426_.fillCrashReportCategory(crashreportcategory);
            CrashReportCategory crashreportcategory1 = this.fillRendererDetails(p_364222_, p_360564_, p_365367_, p_360327_, crashreport);
            crashreportcategory1.setDetail("Delta", Float.valueOf(p_364461_));
            throw new ReportedException(crashreport);
        }
        try {
            this.render(s, p_364222_, p_360564_, p_365367_, p_363537_, p_364290_, p_363520_, p_360327_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport1 = CrashReport.forThrowable(throwable, "Rendering entity in world");
            CrashReportCategory crashreportcategory2 = crashreport1.addCategory("Entity being rendered");
            p_365426_.fillCrashReportCategory(crashreportcategory2);
            throw new ReportedException(crashreport1);
        }
    }

    public <S extends EntityRenderState> void render(S p_412464_, double p_412191_, double p_412733_, double p_412728_, PoseStack p_412550_, MultiBufferSource p_412452_, int p_412119_) {
        EntityRenderer<?, S> entityrenderer = this.getRenderer(p_412464_);
        this.render(p_412464_, p_412191_, p_412733_, p_412728_, p_412550_, p_412452_, p_412119_, entityrenderer);
    }

    private <S extends EntityRenderState> void render(S p_412595_, double p_412285_, double p_412620_, double p_412059_, PoseStack p_412055_, MultiBufferSource p_412539_, int p_412431_, EntityRenderer<?, S> p_412321_) {
        try {
            double d2;
            float f1;
            float f;
            Vec3 vec3 = p_412321_.getRenderOffset(p_412595_);
            double d3 = p_412285_ + vec3.x();
            double d0 = p_412620_ + vec3.y();
            double d1 = p_412059_ + vec3.z();
            p_412055_.pushPose();
            p_412055_.translate(d3, d0, d1);
            p_412321_.render(p_412595_, p_412055_, p_412539_, p_412431_);
            if (p_412595_.displayFireAnimation) {
                this.renderFlame(p_412055_, p_412539_, p_412595_, Mth.rotationAroundAxis(Mth.Y_AXIS, this.cameraOrientation, new Quaternionf()));
            }
            if (p_412595_ instanceof PlayerRenderState) {
                p_412055_.translate(-vec3.x(), -vec3.y(), -vec3.z());
            }
            if (this.options.entityShadows().get().booleanValue() && this.shouldRenderShadow && !p_412595_.isInvisible && (f = p_412321_.getShadowRadius(p_412595_)) > 0.0f && (f1 = (float)((1.0 - (d2 = p_412595_.distanceToCameraSq) / 256.0) * (double)p_412321_.getShadowStrength(p_412595_))) > 0.0f) {
                EntityRenderDispatcher.renderShadow(p_412055_, p_412539_, p_412595_, f1, this.level, Math.min(f, 32.0f));
            }
            if (!(p_412595_ instanceof PlayerRenderState)) {
                p_412055_.translate(-vec3.x(), -vec3.y(), -vec3.z());
            }
            if (p_412595_.hitboxesRenderState != null) {
                this.renderHitboxes(p_412055_, p_412595_, p_412595_.hitboxesRenderState, p_412539_);
            }
            p_412055_.popPose();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.addCategory("EntityRenderState being rendered");
            p_412595_.fillCrashReportCategory(crashreportcategory);
            this.fillRendererDetails(p_412285_, p_412620_, p_412059_, p_412321_, crashreport);
            throw new ReportedException(crashreport);
        }
    }

    private <S extends EntityRenderState> CrashReportCategory fillRendererDetails(double p_412658_, double p_412212_, double p_412493_, EntityRenderer<?, S> p_412221_, CrashReport p_412241_) {
        CrashReportCategory crashreportcategory = p_412241_.addCategory("Renderer details");
        crashreportcategory.setDetail("Assigned renderer", p_412221_);
        crashreportcategory.setDetail("Location", CrashReportCategory.formatLocation((LevelHeightAccessor)this.level, p_412658_, p_412212_, p_412493_));
        return crashreportcategory;
    }

    private void renderHitboxes(PoseStack p_412605_, EntityRenderState p_412741_, HitboxesRenderState p_412691_, MultiBufferSource p_412667_) {
        VertexConsumer vertexconsumer = p_412667_.getBuffer(RenderType.lines());
        EntityRenderDispatcher.renderHitboxesAndViewVector(p_412605_, p_412691_, vertexconsumer, p_412741_.eyeHeight);
        ServerHitboxesRenderState serverhitboxesrenderstate = p_412741_.serverHitboxesRenderState;
        if (serverhitboxesrenderstate != null) {
            if (serverhitboxesrenderstate.missing()) {
                HitboxRenderState hitboxrenderstate = (HitboxRenderState)p_412691_.hitboxes().getFirst();
                DebugRenderer.renderFloatingText(p_412605_, p_412667_, "Missing", p_412741_.x, hitboxrenderstate.y1() + 1.5, p_412741_.z, -65536);
            } else if (serverhitboxesrenderstate.hitboxes() != null) {
                p_412605_.pushPose();
                p_412605_.translate(serverhitboxesrenderstate.serverEntityX() - p_412741_.x, serverhitboxesrenderstate.serverEntityY() - p_412741_.y, serverhitboxesrenderstate.serverEntityZ() - p_412741_.z);
                EntityRenderDispatcher.renderHitboxesAndViewVector(p_412605_, serverhitboxesrenderstate.hitboxes(), vertexconsumer, serverhitboxesrenderstate.eyeHeight());
                Vec3 vec3 = new Vec3(serverhitboxesrenderstate.deltaMovementX(), serverhitboxesrenderstate.deltaMovementY(), serverhitboxesrenderstate.deltaMovementZ());
                ShapeRenderer.renderVector(p_412605_, vertexconsumer, new Vector3f(), vec3, -256);
                p_412605_.popPose();
            }
        }
    }

    private static void renderHitboxesAndViewVector(PoseStack p_412542_, HitboxesRenderState p_412760_, VertexConsumer p_412159_, float p_412372_) {
        for (HitboxRenderState hitboxrenderstate : p_412760_.hitboxes()) {
            EntityRenderDispatcher.renderHitbox(p_412542_, p_412159_, hitboxrenderstate);
        }
        Vec3 vec3 = new Vec3(p_412760_.viewX(), p_412760_.viewY(), p_412760_.viewZ());
        ShapeRenderer.renderVector(p_412542_, p_412159_, new Vector3f(0.0f, p_412372_, 0.0f), vec3.scale(2.0), -16776961);
    }

    private static void renderHitbox(PoseStack p_114442_, VertexConsumer p_114443_, HitboxRenderState p_412284_) {
        p_114442_.pushPose();
        p_114442_.translate(p_412284_.offsetX(), p_412284_.offsetY(), p_412284_.offsetZ());
        ShapeRenderer.renderLineBox(p_114442_, p_114443_, p_412284_.x0(), p_412284_.y0(), p_412284_.z0(), p_412284_.x1(), p_412284_.y1(), p_412284_.z1(), p_412284_.red(), p_412284_.green(), p_412284_.blue(), 1.0f);
        p_114442_.popPose();
    }

    private void renderFlame(PoseStack p_114454_, MultiBufferSource p_114455_, EntityRenderState p_363731_, Quaternionf p_304964_) {
        TextureAtlasSprite textureatlassprite = ModelBakery.FIRE_0.sprite();
        TextureAtlasSprite textureatlassprite1 = ModelBakery.FIRE_1.sprite();
        p_114454_.pushPose();
        float f = p_363731_.boundingBoxWidth * 1.4f;
        p_114454_.scale(f, f, f);
        float f1 = 0.5f;
        float f2 = 0.0f;
        float f3 = p_363731_.boundingBoxHeight / f;
        float f4 = 0.0f;
        p_114454_.mulPose((Quaternionfc)p_304964_);
        p_114454_.translate(0.0f, 0.0f, 0.3f - (float)((int)f3) * 0.02f);
        float f5 = 0.0f;
        int i = 0;
        VertexConsumer vertexconsumer = p_114455_.getBuffer(Sheets.cutoutBlockSheet());
        PoseStack.Pose posestack$pose = p_114454_.last();
        while (f3 > 0.0f) {
            TextureAtlasSprite textureatlassprite2 = i % 2 == 0 ? textureatlassprite : textureatlassprite1;
            float f6 = textureatlassprite2.getU0();
            float f7 = textureatlassprite2.getV0();
            float f8 = textureatlassprite2.getU1();
            float f9 = textureatlassprite2.getV1();
            if (i / 2 % 2 == 0) {
                float f10 = f8;
                f8 = f6;
                f6 = f10;
            }
            EntityRenderDispatcher.fireVertex(posestack$pose, vertexconsumer, -f1 - 0.0f, 0.0f - f4, f5, f8, f9);
            EntityRenderDispatcher.fireVertex(posestack$pose, vertexconsumer, f1 - 0.0f, 0.0f - f4, f5, f6, f9);
            EntityRenderDispatcher.fireVertex(posestack$pose, vertexconsumer, f1 - 0.0f, 1.4f - f4, f5, f6, f7);
            EntityRenderDispatcher.fireVertex(posestack$pose, vertexconsumer, -f1 - 0.0f, 1.4f - f4, f5, f8, f7);
            f3 -= 0.45f;
            f4 -= 0.45f;
            f1 *= 0.9f;
            f5 -= 0.03f;
            ++i;
        }
        p_114454_.popPose();
    }

    private static void fireVertex(PoseStack.Pose p_114415_, VertexConsumer p_114416_, float p_114417_, float p_114418_, float p_114419_, float p_114420_, float p_114421_) {
        p_114416_.addVertex(p_114415_, p_114417_, p_114418_, p_114419_).setColor(-1).setUv(p_114420_, p_114421_).setUv1(0, 10).setLight(240).setNormal(p_114415_, 0.0f, 1.0f, 0.0f);
    }

    private static void renderShadow(PoseStack p_114458_, MultiBufferSource p_114459_, EntityRenderState p_365403_, float p_114461_, LevelReader p_114463_, float p_114462_) {
        float f = Math.min(p_114461_ / 0.5f, p_114462_);
        int i = Mth.floor(p_365403_.x - (double)p_114462_);
        int j = Mth.floor(p_365403_.x + (double)p_114462_);
        int k = Mth.floor(p_365403_.y - (double)f);
        int l = Mth.floor(p_365403_.y);
        int i1 = Mth.floor(p_365403_.z - (double)p_114462_);
        int j1 = Mth.floor(p_365403_.z + (double)p_114462_);
        PoseStack.Pose posestack$pose = p_114458_.last();
        VertexConsumer vertexconsumer = p_114459_.getBuffer(SHADOW_RENDER_TYPE);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i1; k1 <= j1; ++k1) {
            for (int l1 = i; l1 <= j; ++l1) {
                blockpos$mutableblockpos.set(l1, 0, k1);
                ChunkAccess chunkaccess = p_114463_.getChunk(blockpos$mutableblockpos);
                for (int i2 = k; i2 <= l; ++i2) {
                    blockpos$mutableblockpos.setY(i2);
                    float f1 = p_114461_ - (float)(p_365403_.y - (double)blockpos$mutableblockpos.getY()) * 0.5f;
                    EntityRenderDispatcher.renderBlockShadow(posestack$pose, vertexconsumer, chunkaccess, p_114463_, blockpos$mutableblockpos, p_365403_.x, p_365403_.y, p_365403_.z, p_114462_, f1);
                }
            }
        }
    }

    private static void renderBlockShadow(PoseStack.Pose p_277956_, VertexConsumer p_277533_, ChunkAccess p_277501_, LevelReader p_277622_, BlockPos p_277911_, double p_277682_, double p_278099_, double p_277806_, float p_277844_, float p_277496_) {
        float f;
        float f1;
        VoxelShape voxelshape;
        BlockPos blockpos = p_277911_.below();
        BlockState blockstate = p_277501_.getBlockState(blockpos);
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE && p_277622_.getMaxLocalRawBrightness(p_277911_) > 3 && blockstate.isCollisionShapeFullBlock(p_277501_, blockpos) && !(voxelshape = blockstate.getShape(p_277501_, blockpos)).isEmpty() && (f1 = p_277496_ * 0.5f * (f = LightTexture.getBrightness(p_277622_.dimensionType(), p_277622_.getMaxLocalRawBrightness(p_277911_)))) >= 0.0f) {
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            int i = ARGB.color(Mth.floor(f1 * 255.0f), 255, 255, 255);
            AABB aabb = voxelshape.bounds();
            double d0 = (double)p_277911_.getX() + aabb.minX;
            double d1 = (double)p_277911_.getX() + aabb.maxX;
            double d2 = (double)p_277911_.getY() + aabb.minY;
            double d3 = (double)p_277911_.getZ() + aabb.minZ;
            double d4 = (double)p_277911_.getZ() + aabb.maxZ;
            float f2 = (float)(d0 - p_277682_);
            float f3 = (float)(d1 - p_277682_);
            float f4 = (float)(d2 - p_278099_);
            float f5 = (float)(d3 - p_277806_);
            float f6 = (float)(d4 - p_277806_);
            float f7 = -f2 / 2.0f / p_277844_ + 0.5f;
            float f8 = -f3 / 2.0f / p_277844_ + 0.5f;
            float f9 = -f5 / 2.0f / p_277844_ + 0.5f;
            float f10 = -f6 / 2.0f / p_277844_ + 0.5f;
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, i, f2, f4, f5, f7, f9);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, i, f2, f4, f6, f7, f10);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, i, f3, f4, f6, f8, f10);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, i, f3, f4, f5, f8, f9);
        }
    }

    private static void shadowVertex(PoseStack.Pose p_114423_, VertexConsumer p_114424_, int p_350992_, float p_114425_, float p_114426_, float p_114427_, float p_114428_, float p_114429_) {
        Vector3f vector3f = p_114423_.pose().transformPosition(p_114425_, p_114426_, p_114427_, new Vector3f());
        p_114424_.addVertex(vector3f.x(), vector3f.y(), vector3f.z(), p_350992_, p_114428_, p_114429_, OverlayTexture.NO_OVERLAY, 0xF000F0, 0.0f, 1.0f, 0.0f);
    }

    public void setLevel(@Nullable Level p_114407_) {
        this.level = p_114407_;
        if (p_114407_ == null) {
            this.camera = null;
        }
    }

    public double distanceToSqr(Entity p_114472_) {
        return this.camera.getPosition().distanceToSqr(p_114472_.position());
    }

    public double distanceToSqr(double p_114379_, double p_114380_, double p_114381_) {
        return this.camera.getPosition().distanceToSqr(p_114379_, p_114380_, p_114381_);
    }

    public Quaternionf cameraOrientation() {
        return this.cameraOrientation;
    }

    public ItemInHandRenderer getItemInHandRenderer() {
        return this.itemInHandRenderer;
    }

    public Map<PlayerSkin.Model, EntityRenderer<? extends Player, ?>> getSkinMap() {
        return Collections.unmodifiableMap(this.playerRenderers);
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_174004_) {
        EntityRendererProvider.Context entityrendererprovider$context = new EntityRendererProvider.Context(this, this.itemModelResolver, this.mapRenderer, this.blockRenderDispatcher, p_174004_, this.entityModels.get(), this.equipmentAssets, this.font);
        this.renderers = EntityRenderers.createEntityRenderers(entityrendererprovider$context);
        this.playerRenderers = EntityRenderers.createPlayerRenderers(entityrendererprovider$context);
        ModLoader.postEvent((Event)new EntityRenderersEvent.AddLayers(this.renderers, this.playerRenderers, entityrendererprovider$context));
    }
}

