/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.dragon.EnderDragonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EnderDragonRenderState;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EnderDragonRenderer
extends EntityRenderer<EnderDragon, EnderDragonRenderState> {
    public static final ResourceLocation CRYSTAL_BEAM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/end_crystal/end_crystal_beam.png");
    private static final ResourceLocation DRAGON_EXPLODING_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation DRAGON_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation DRAGON_EYES_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon_eyes.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull(DRAGON_LOCATION);
    private static final RenderType DECAL = RenderType.entityDecal(DRAGON_LOCATION);
    private static final RenderType EYES = RenderType.eyes(DRAGON_EYES_LOCATION);
    private static final RenderType BEAM = RenderType.entitySmoothCutout(CRYSTAL_BEAM_LOCATION);
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private final EnderDragonModel model;

    public EnderDragonRenderer(EntityRendererProvider.Context p_173973_) {
        super(p_173973_);
        this.shadowRadius = 0.5f;
        this.model = new EnderDragonModel(p_173973_.bakeLayer(ModelLayers.ENDER_DRAGON));
    }

    @Override
    public void render(EnderDragonRenderState p_364805_, PoseStack p_114211_, MultiBufferSource p_114212_, int p_114213_) {
        p_114211_.pushPose();
        float f = p_364805_.getHistoricalPos(7).yRot();
        float f1 = (float)(p_364805_.getHistoricalPos(5).y() - p_364805_.getHistoricalPos(10).y());
        p_114211_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-f));
        p_114211_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f1 * 10.0f));
        p_114211_.translate(0.0f, 0.0f, 1.0f);
        p_114211_.scale(-1.0f, -1.0f, 1.0f);
        p_114211_.translate(0.0f, -1.501f, 0.0f);
        this.model.setupAnim(p_364805_);
        if (p_364805_.deathTime > 0.0f) {
            float f2 = p_364805_.deathTime / 200.0f;
            int i = ARGB.color(Mth.floor(f2 * 255.0f), -1);
            VertexConsumer vertexconsumer = p_114212_.getBuffer(RenderType.dragonExplosionAlpha(DRAGON_EXPLODING_LOCATION));
            this.model.renderToBuffer(p_114211_, vertexconsumer, p_114213_, OverlayTexture.NO_OVERLAY, i);
            VertexConsumer vertexconsumer1 = p_114212_.getBuffer(DECAL);
            this.model.renderToBuffer(p_114211_, vertexconsumer1, p_114213_, OverlayTexture.pack(0.0f, p_364805_.hasRedOverlay));
        } else {
            VertexConsumer vertexconsumer2 = p_114212_.getBuffer(RENDER_TYPE);
            this.model.renderToBuffer(p_114211_, vertexconsumer2, p_114213_, OverlayTexture.pack(0.0f, p_364805_.hasRedOverlay));
        }
        VertexConsumer vertexconsumer3 = p_114212_.getBuffer(EYES);
        this.model.renderToBuffer(p_114211_, vertexconsumer3, p_114213_, OverlayTexture.NO_OVERLAY);
        if (p_364805_.deathTime > 0.0f) {
            float f3 = p_364805_.deathTime / 200.0f;
            p_114211_.pushPose();
            p_114211_.translate(0.0f, -1.0f, -2.0f);
            EnderDragonRenderer.renderRays(p_114211_, f3, p_114212_.getBuffer(RenderType.dragonRays()));
            EnderDragonRenderer.renderRays(p_114211_, f3, p_114212_.getBuffer(RenderType.dragonRaysDepth()));
            p_114211_.popPose();
        }
        p_114211_.popPose();
        if (p_364805_.beamOffset != null) {
            EnderDragonRenderer.renderCrystalBeams((float)p_364805_.beamOffset.x, (float)p_364805_.beamOffset.y, (float)p_364805_.beamOffset.z, p_364805_.ageInTicks, p_114211_, p_114212_, p_114213_);
        }
        super.render(p_364805_, p_114211_, p_114212_, p_114213_);
    }

    private static void renderRays(PoseStack p_352922_, float p_352903_, VertexConsumer p_352894_) {
        p_352922_.pushPose();
        float f = Math.min(p_352903_ > 0.8f ? (p_352903_ - 0.8f) / 0.2f : 0.0f, 1.0f);
        int i = ARGB.colorFromFloat(1.0f - f, 1.0f, 1.0f, 1.0f);
        int j = 0xFF00FF;
        RandomSource randomsource = RandomSource.create(432L);
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f1 = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Quaternionf quaternionf = new Quaternionf();
        int k = Mth.floor((p_352903_ + p_352903_ * p_352903_) / 2.0f * 60.0f);
        for (int l = 0; l < k; ++l) {
            quaternionf.rotationXYZ(randomsource.nextFloat() * ((float)Math.PI * 2), randomsource.nextFloat() * ((float)Math.PI * 2), randomsource.nextFloat() * ((float)Math.PI * 2)).rotateXYZ(randomsource.nextFloat() * ((float)Math.PI * 2), randomsource.nextFloat() * ((float)Math.PI * 2), randomsource.nextFloat() * ((float)Math.PI * 2) + p_352903_ * 1.5707964f);
            p_352922_.mulPose((Quaternionfc)quaternionf);
            float f1 = randomsource.nextFloat() * 20.0f + 5.0f + f * 10.0f;
            float f2 = randomsource.nextFloat() * 2.0f + 1.0f + f * 2.0f;
            vector3f1.set(-HALF_SQRT_3 * f2, f1, -0.5f * f2);
            vector3f2.set(HALF_SQRT_3 * f2, f1, -0.5f * f2);
            vector3f3.set(0.0f, f1, f2);
            PoseStack.Pose posestack$pose = p_352922_.last();
            p_352894_.addVertex(posestack$pose, vector3f).setColor(i);
            p_352894_.addVertex(posestack$pose, vector3f1).setColor(0xFF00FF);
            p_352894_.addVertex(posestack$pose, vector3f2).setColor(0xFF00FF);
            p_352894_.addVertex(posestack$pose, vector3f).setColor(i);
            p_352894_.addVertex(posestack$pose, vector3f2).setColor(0xFF00FF);
            p_352894_.addVertex(posestack$pose, vector3f3).setColor(0xFF00FF);
            p_352894_.addVertex(posestack$pose, vector3f).setColor(i);
            p_352894_.addVertex(posestack$pose, vector3f3).setColor(0xFF00FF);
            p_352894_.addVertex(posestack$pose, vector3f1).setColor(0xFF00FF);
        }
        p_352922_.popPose();
    }

    public static void renderCrystalBeams(float p_114188_, float p_114189_, float p_114190_, float p_114191_, PoseStack p_114193_, MultiBufferSource p_114194_, int p_114192_) {
        float f = Mth.sqrt(p_114188_ * p_114188_ + p_114190_ * p_114190_);
        float f1 = Mth.sqrt(p_114188_ * p_114188_ + p_114189_ * p_114189_ + p_114190_ * p_114190_);
        p_114193_.pushPose();
        p_114193_.translate(0.0f, 2.0f, 0.0f);
        p_114193_.mulPose((Quaternionfc)Axis.YP.rotation((float)(-Math.atan2(p_114190_, p_114188_)) - 1.5707964f));
        p_114193_.mulPose((Quaternionfc)Axis.XP.rotation((float)(-Math.atan2(f, p_114189_)) - 1.5707964f));
        VertexConsumer vertexconsumer = p_114194_.getBuffer(BEAM);
        float f2 = 0.0f - p_114191_ * 0.01f;
        float f3 = f1 / 32.0f - p_114191_ * 0.01f;
        int i = 8;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = p_114193_.last();
        for (int j = 1; j <= 8; ++j) {
            float f7 = Mth.sin((float)j * ((float)Math.PI * 2) / 8.0f) * 0.75f;
            float f8 = Mth.cos((float)j * ((float)Math.PI * 2) / 8.0f) * 0.75f;
            float f9 = (float)j / 8.0f;
            vertexconsumer.addVertex(posestack$pose, f4 * 0.2f, f5 * 0.2f, 0.0f).setColor(-16777216).setUv(f6, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114192_).setNormal(posestack$pose, 0.0f, -1.0f, 0.0f);
            vertexconsumer.addVertex(posestack$pose, f4, f5, f1).setColor(-1).setUv(f6, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114192_).setNormal(posestack$pose, 0.0f, -1.0f, 0.0f);
            vertexconsumer.addVertex(posestack$pose, f7, f8, f1).setColor(-1).setUv(f9, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114192_).setNormal(posestack$pose, 0.0f, -1.0f, 0.0f);
            vertexconsumer.addVertex(posestack$pose, f7 * 0.2f, f8 * 0.2f, 0.0f).setColor(-16777216).setUv(f9, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114192_).setNormal(posestack$pose, 0.0f, -1.0f, 0.0f);
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        p_114193_.popPose();
    }

    @Override
    public EnderDragonRenderState createRenderState() {
        return new EnderDragonRenderState();
    }

    @Override
    public void extractRenderState(EnderDragon p_361171_, EnderDragonRenderState p_363002_, float p_363418_) {
        super.extractRenderState(p_361171_, p_363002_, p_363418_);
        p_363002_.flapTime = Mth.lerp(p_363418_, p_361171_.oFlapTime, p_361171_.flapTime);
        p_363002_.deathTime = p_361171_.dragonDeathTime > 0 ? (float)p_361171_.dragonDeathTime + p_363418_ : 0.0f;
        p_363002_.hasRedOverlay = p_361171_.hurtTime > 0;
        EndCrystal endcrystal = p_361171_.nearestCrystal;
        if (endcrystal != null) {
            Vec3 vec3 = endcrystal.getPosition(p_363418_).add(0.0, EndCrystalRenderer.getY((float)endcrystal.time + p_363418_), 0.0);
            p_363002_.beamOffset = vec3.subtract(p_361171_.getPosition(p_363418_));
        } else {
            p_363002_.beamOffset = null;
        }
        DragonPhaseInstance dragonphaseinstance = p_361171_.getPhaseManager().getCurrentPhase();
        p_363002_.isLandingOrTakingOff = dragonphaseinstance == EnderDragonPhase.LANDING || dragonphaseinstance == EnderDragonPhase.TAKEOFF;
        p_363002_.isSitting = dragonphaseinstance.isSitting();
        BlockPos blockpos = p_361171_.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(p_361171_.getFightOrigin()));
        p_363002_.distanceToEgg = blockpos.distToCenterSqr(p_361171_.position());
        p_363002_.partialTicks = p_361171_.isDeadOrDying() ? 0.0f : p_363418_;
        p_363002_.flightHistory.copyFrom(p_361171_.flightHistory);
    }

    @Override
    protected void extractAdditionalHitboxes(EnderDragon p_412673_, ImmutableList.Builder<HitboxRenderState> p_412323_, float p_412176_) {
        super.extractAdditionalHitboxes(p_412673_, p_412323_, p_412176_);
        double d0 = -Mth.lerp((double)p_412176_, p_412673_.xOld, p_412673_.getX());
        double d1 = -Mth.lerp((double)p_412176_, p_412673_.yOld, p_412673_.getY());
        double d2 = -Mth.lerp((double)p_412176_, p_412673_.zOld, p_412673_.getZ());
        for (EnderDragonPart enderdragonpart : p_412673_.getSubEntities()) {
            AABB aabb = enderdragonpart.getBoundingBox();
            HitboxRenderState hitboxrenderstate = new HitboxRenderState(aabb.minX - enderdragonpart.getX(), aabb.minY - enderdragonpart.getY(), aabb.minZ - enderdragonpart.getZ(), aabb.maxX - enderdragonpart.getX(), aabb.maxY - enderdragonpart.getY(), aabb.maxZ - enderdragonpart.getZ(), (float)(d0 + Mth.lerp((double)p_412176_, enderdragonpart.xOld, enderdragonpart.getX())), (float)(d1 + Mth.lerp((double)p_412176_, enderdragonpart.yOld, enderdragonpart.getY())), (float)(d2 + Mth.lerp((double)p_412176_, enderdragonpart.zOld, enderdragonpart.getZ())), 0.25f, 1.0f, 0.0f);
            p_412323_.add((Object)hitboxrenderstate);
        }
    }

    @Override
    protected boolean affectedByCulling(EnderDragon p_361699_) {
        return false;
    }
}

