/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.DolphinModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.DolphinCarryingItemLayer;
import net.minecraft.client.renderer.entity.state.DolphinRenderState;
import net.minecraft.client.renderer.entity.state.HoldingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Dolphin;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DolphinRenderer
extends AgeableMobRenderer<Dolphin, DolphinRenderState, DolphinModel> {
    private static final ResourceLocation DOLPHIN_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/dolphin.png");

    public DolphinRenderer(EntityRendererProvider.Context p_173960_) {
        super(p_173960_, new DolphinModel(p_173960_.bakeLayer(ModelLayers.DOLPHIN)), new DolphinModel(p_173960_.bakeLayer(ModelLayers.DOLPHIN_BABY)), 0.7f);
        this.addLayer(new DolphinCarryingItemLayer(this));
    }

    @Override
    public ResourceLocation getTextureLocation(DolphinRenderState p_362016_) {
        return DOLPHIN_LOCATION;
    }

    @Override
    public DolphinRenderState createRenderState() {
        return new DolphinRenderState();
    }

    @Override
    public void extractRenderState(Dolphin p_362277_, DolphinRenderState p_364903_, float p_361483_) {
        super.extractRenderState(p_362277_, p_364903_, p_361483_);
        HoldingEntityRenderState.extractHoldingEntityRenderState(p_362277_, p_364903_, this.itemModelResolver);
        p_364903_.isMoving = p_362277_.getDeltaMovement().horizontalDistanceSqr() > 1.0E-7;
    }
}

