/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.CreakingModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LivingEntityEmissiveLayer;
import net.minecraft.client.renderer.entity.state.CreakingRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreakingRenderer<T extends Creaking>
extends MobRenderer<T, CreakingRenderState, CreakingModel> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/creaking/creaking.png");
    private static final ResourceLocation EYES_TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/creaking/creaking_eyes.png");

    public CreakingRenderer(EntityRendererProvider.Context p_379341_) {
        super(p_379341_, new CreakingModel(p_379341_.bakeLayer(ModelLayers.CREAKING)), 0.6f);
        this.addLayer(new LivingEntityEmissiveLayer<CreakingRenderState, CreakingModel>(this, EYES_TEXTURE_LOCATION, (p_379361_, p_380081_) -> 1.0f, CreakingModel::getHeadModelParts, RenderType::eyes, true));
    }

    @Override
    public ResourceLocation getTextureLocation(CreakingRenderState p_379686_) {
        return TEXTURE_LOCATION;
    }

    @Override
    public CreakingRenderState createRenderState() {
        return new CreakingRenderState();
    }

    @Override
    public void extractRenderState(T p_379591_, CreakingRenderState p_380210_, float p_379411_) {
        super.extractRenderState(p_379591_, p_380210_, p_379411_);
        p_380210_.attackAnimationState.copyFrom(((Creaking)p_379591_).attackAnimationState);
        p_380210_.invulnerabilityAnimationState.copyFrom(((Creaking)p_379591_).invulnerabilityAnimationState);
        p_380210_.deathAnimationState.copyFrom(((Creaking)p_379591_).deathAnimationState);
        if (((Creaking)p_379591_).isTearingDown()) {
            p_380210_.deathTime = 0.0f;
            p_380210_.hasRedOverlay = false;
            p_380210_.eyesGlowing = ((Creaking)p_379591_).hasGlowingEyes();
        } else {
            p_380210_.eyesGlowing = ((Creaking)p_379591_).isActive();
        }
        p_380210_.canMove = ((Creaking)p_379591_).canMove();
    }
}

