/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.CowRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.CowVariant;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CowRenderer
extends MobRenderer<Cow, CowRenderState, CowModel> {
    private final Map<CowVariant.ModelType, AdultAndBabyModelPair<CowModel>> models;

    public CowRenderer(EntityRendererProvider.Context p_173956_) {
        super(p_173956_, new CowModel(p_173956_.bakeLayer(ModelLayers.COW)), 0.7f);
        this.models = CowRenderer.bakeModels(p_173956_);
    }

    private static Map<CowVariant.ModelType, AdultAndBabyModelPair<CowModel>> bakeModels(EntityRendererProvider.Context p_401303_) {
        return Maps.newEnumMap(Map.of(CowVariant.ModelType.NORMAL, new AdultAndBabyModelPair<CowModel>(new CowModel(p_401303_.bakeLayer(ModelLayers.COW)), new CowModel(p_401303_.bakeLayer(ModelLayers.COW_BABY))), CowVariant.ModelType.WARM, new AdultAndBabyModelPair<CowModel>(new CowModel(p_401303_.bakeLayer(ModelLayers.WARM_COW)), new CowModel(p_401303_.bakeLayer(ModelLayers.WARM_COW_BABY))), CowVariant.ModelType.COLD, new AdultAndBabyModelPair<CowModel>(new CowModel(p_401303_.bakeLayer(ModelLayers.COLD_COW)), new CowModel(p_401303_.bakeLayer(ModelLayers.COLD_COW_BABY)))));
    }

    @Override
    public ResourceLocation getTextureLocation(CowRenderState p_401372_) {
        return p_401372_.variant == null ? MissingTextureAtlasSprite.getLocation() : p_401372_.variant.modelAndTexture().asset().texturePath();
    }

    @Override
    public CowRenderState createRenderState() {
        return new CowRenderState();
    }

    @Override
    public void extractRenderState(Cow p_364800_, CowRenderState p_401182_, float p_360614_) {
        super.extractRenderState(p_364800_, p_401182_, p_360614_);
        p_401182_.variant = p_364800_.getVariant().value();
    }

    @Override
    public void render(CowRenderState p_401408_, PoseStack p_401206_, MultiBufferSource p_401086_, int p_401222_) {
        if (p_401408_.variant != null) {
            this.model = this.models.get(p_401408_.variant.modelAndTexture().model()).getModel(p_401408_.isBaby);
            super.render(p_401408_, p_401206_, p_401086_, p_401222_);
        }
    }
}

