/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.ColdChickenModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.ChickenRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChickenRenderer
extends MobRenderer<Chicken, ChickenRenderState, ChickenModel> {
    private final Map<ChickenVariant.ModelType, AdultAndBabyModelPair<ChickenModel>> models;

    public ChickenRenderer(EntityRendererProvider.Context p_173952_) {
        super(p_173952_, new ChickenModel(p_173952_.bakeLayer(ModelLayers.CHICKEN)), 0.3f);
        this.models = ChickenRenderer.bakeModels(p_173952_);
    }

    private static Map<ChickenVariant.ModelType, AdultAndBabyModelPair<ChickenModel>> bakeModels(EntityRendererProvider.Context p_401798_) {
        return Maps.newEnumMap(Map.of(ChickenVariant.ModelType.NORMAL, new AdultAndBabyModelPair<ChickenModel>(new ChickenModel(p_401798_.bakeLayer(ModelLayers.CHICKEN)), new ChickenModel(p_401798_.bakeLayer(ModelLayers.CHICKEN_BABY))), ChickenVariant.ModelType.COLD, new AdultAndBabyModelPair<ColdChickenModel>(new ColdChickenModel(p_401798_.bakeLayer(ModelLayers.COLD_CHICKEN)), new ColdChickenModel(p_401798_.bakeLayer(ModelLayers.COLD_CHICKEN_BABY)))));
    }

    @Override
    public void render(ChickenRenderState p_401826_, PoseStack p_401883_, MultiBufferSource p_401836_, int p_401766_) {
        if (p_401826_.variant != null) {
            this.model = this.models.get(p_401826_.variant.modelAndTexture().model()).getModel(p_401826_.isBaby);
            super.render(p_401826_, p_401883_, p_401836_, p_401766_);
        }
    }

    @Override
    public ResourceLocation getTextureLocation(ChickenRenderState p_364952_) {
        return p_364952_.variant == null ? MissingTextureAtlasSprite.getLocation() : p_364952_.variant.modelAndTexture().asset().texturePath();
    }

    @Override
    public ChickenRenderState createRenderState() {
        return new ChickenRenderState();
    }

    @Override
    public void extractRenderState(Chicken p_361981_, ChickenRenderState p_365088_, float p_364120_) {
        super.extractRenderState(p_361981_, p_365088_, p_364120_);
        p_365088_.flap = Mth.lerp(p_364120_, p_361981_.oFlap, p_361981_.flap);
        p_365088_.flapSpeed = Mth.lerp(p_364120_, p_361981_.oFlapSpeed, p_361981_.flapSpeed);
        p_365088_.variant = p_361981_.getVariant().value();
    }
}

