/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.SkeletonRenderState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractSkeletonRenderer<T extends AbstractSkeleton, S extends SkeletonRenderState>
extends HumanoidMobRenderer<T, S, SkeletonModel<S>> {
    public AbstractSkeletonRenderer(EntityRendererProvider.Context p_365063_, ModelLayerLocation p_364353_, ModelLayerLocation p_361271_, ModelLayerLocation p_360962_) {
        this(p_365063_, p_361271_, p_360962_, new SkeletonModel(p_365063_.bakeLayer(p_364353_)));
    }

    public AbstractSkeletonRenderer(EntityRendererProvider.Context p_360948_, ModelLayerLocation p_364416_, ModelLayerLocation p_360716_, SkeletonModel<S> p_361394_) {
        super(p_360948_, p_361394_, 0.5f);
        this.addLayer(new HumanoidArmorLayer(this, new SkeletonModel(p_360948_.bakeLayer(p_364416_)), new SkeletonModel(p_360948_.bakeLayer(p_360716_)), p_360948_.getEquipmentRenderer()));
    }

    @Override
    public void extractRenderState(T p_360621_, S p_364836_, float p_362389_) {
        super.extractRenderState(p_360621_, p_364836_, p_362389_);
        ((SkeletonRenderState)((Object)p_364836_)).isAggressive = ((Mob)p_360621_).isAggressive();
        ((SkeletonRenderState)((Object)p_364836_)).isShaking = ((AbstractSkeleton)p_360621_).isShaking();
        ((SkeletonRenderState)((Object)p_364836_)).isHoldingBow = ((LivingEntity)p_360621_).getMainHandItem().is(Items.BOW);
    }

    @Override
    protected boolean isShaking(S p_364410_) {
        return ((SkeletonRenderState)((Object)p_364410_)).isShaking;
    }

    @Override
    protected HumanoidModel.ArmPose getArmPose(AbstractSkeleton p_389585_, HumanoidArm p_389423_) {
        return p_389585_.getMainArm() == p_389423_ && p_389585_.isAggressive() && p_389585_.getMainHandItem().is(Items.BOW) ? HumanoidModel.ArmPose.BOW_AND_ARROW : HumanoidModel.ArmPose.EMPTY;
    }
}

