/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.MinecartRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractMinecartRenderer<T extends AbstractMinecart, S extends MinecartRenderState>
extends EntityRenderer<T, S> {
    private static final ResourceLocation MINECART_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/minecart.png");
    private static final float DISPLAY_BLOCK_SCALE = 0.75f;
    protected final MinecartModel model;
    private final BlockRenderDispatcher blockRenderer;

    public AbstractMinecartRenderer(EntityRendererProvider.Context p_363408_, ModelLayerLocation p_360820_) {
        super(p_363408_);
        this.shadowRadius = 0.7f;
        this.model = new MinecartModel(p_363408_.bakeLayer(p_360820_));
        this.blockRenderer = p_363408_.getBlockRenderDispatcher();
    }

    @Override
    public void render(S p_363194_, PoseStack p_360847_, MultiBufferSource p_363596_, int p_361740_) {
        BlockState blockstate;
        super.render(p_363194_, p_360847_, p_363596_, p_361740_);
        p_360847_.pushPose();
        long i = ((MinecartRenderState)((Object)p_363194_)).offsetSeed;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        p_360847_.translate(f, f1, f2);
        if (((MinecartRenderState)((Object)p_363194_)).isNewRender) {
            AbstractMinecartRenderer.newRender(p_363194_, p_360847_);
        } else {
            AbstractMinecartRenderer.oldRender(p_363194_, p_360847_);
        }
        float f3 = ((MinecartRenderState)((Object)p_363194_)).hurtTime;
        if (f3 > 0.0f) {
            p_360847_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.sin(f3) * f3 * ((MinecartRenderState)((Object)p_363194_)).damageTime / 10.0f * (float)((MinecartRenderState)((Object)p_363194_)).hurtDir));
        }
        if ((blockstate = ((MinecartRenderState)((Object)p_363194_)).displayBlockState).getRenderShape() != RenderShape.INVISIBLE) {
            p_360847_.pushPose();
            p_360847_.scale(0.75f, 0.75f, 0.75f);
            p_360847_.translate(-0.5f, (float)(((MinecartRenderState)((Object)p_363194_)).displayOffset - 8) / 16.0f, 0.5f);
            p_360847_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            this.renderMinecartContents(p_363194_, blockstate, p_360847_, p_363596_, p_361740_);
            p_360847_.popPose();
        }
        p_360847_.scale(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(p_363194_);
        VertexConsumer vertexconsumer = p_363596_.getBuffer(this.model.renderType(MINECART_LOCATION));
        this.model.renderToBuffer(p_360847_, vertexconsumer, p_361740_, OverlayTexture.NO_OVERLAY);
        p_360847_.popPose();
    }

    private static <S extends MinecartRenderState> void newRender(S p_360917_, PoseStack p_362046_) {
        p_362046_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(p_360917_.yRot));
        p_362046_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-p_360917_.xRot));
        p_362046_.translate(0.0f, 0.375f, 0.0f);
    }

    private static <S extends MinecartRenderState> void oldRender(S p_364095_, PoseStack p_360278_) {
        double d0 = p_364095_.x;
        double d1 = p_364095_.y;
        double d2 = p_364095_.z;
        float f = p_364095_.xRot;
        float f1 = p_364095_.yRot;
        if (p_364095_.posOnRail != null && p_364095_.frontPos != null && p_364095_.backPos != null) {
            Vec3 vec3 = p_364095_.frontPos;
            Vec3 vec31 = p_364095_.backPos;
            p_360278_.translate(p_364095_.posOnRail.x - d0, (vec3.y + vec31.y) / 2.0 - d1, p_364095_.posOnRail.z - d2);
            Vec3 vec32 = vec31.add(-vec3.x, -vec3.y, -vec3.z);
            if (vec32.length() != 0.0) {
                vec32 = vec32.normalize();
                f1 = (float)(Math.atan2(vec32.z, vec32.x) * 180.0 / Math.PI);
                f = (float)(Math.atan(vec32.y) * 73.0);
            }
        }
        p_360278_.translate(0.0f, 0.375f, 0.0f);
        p_360278_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - f1));
        p_360278_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-f));
    }

    @Override
    public void extractRenderState(T p_360458_, S p_361455_, float p_363949_) {
        super.extractRenderState(p_360458_, p_361455_, p_363949_);
        MinecartBehavior minecartBehavior = ((AbstractMinecart)p_360458_).getBehavior();
        if (minecartBehavior instanceof NewMinecartBehavior) {
            NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartBehavior;
            AbstractMinecartRenderer.newExtractState(p_360458_, newminecartbehavior, p_361455_, p_363949_);
            ((MinecartRenderState)((Object)p_361455_)).isNewRender = true;
        } else {
            minecartBehavior = ((AbstractMinecart)p_360458_).getBehavior();
            if (minecartBehavior instanceof OldMinecartBehavior) {
                OldMinecartBehavior oldminecartbehavior = (OldMinecartBehavior)minecartBehavior;
                AbstractMinecartRenderer.oldExtractState(p_360458_, oldminecartbehavior, p_361455_, p_363949_);
                ((MinecartRenderState)((Object)p_361455_)).isNewRender = false;
            }
        }
        long i = (long)((Entity)p_360458_).getId() * 493286711L;
        ((MinecartRenderState)((Object)p_361455_)).offsetSeed = i * i * 4392167121L + i * 98761L;
        ((MinecartRenderState)((Object)p_361455_)).hurtTime = (float)((VehicleEntity)p_360458_).getHurtTime() - p_363949_;
        ((MinecartRenderState)((Object)p_361455_)).hurtDir = ((VehicleEntity)p_360458_).getHurtDir();
        ((MinecartRenderState)((Object)p_361455_)).damageTime = Math.max(((VehicleEntity)p_360458_).getDamage() - p_363949_, 0.0f);
        ((MinecartRenderState)((Object)p_361455_)).displayOffset = ((AbstractMinecart)p_360458_).getDisplayOffset();
        ((MinecartRenderState)((Object)p_361455_)).displayBlockState = ((AbstractMinecart)p_360458_).getDisplayBlockState();
    }

    private static <T extends AbstractMinecart, S extends MinecartRenderState> void newExtractState(T p_365349_, NewMinecartBehavior p_365110_, S p_363052_, float p_364223_) {
        if (p_365110_.cartHasPosRotLerp()) {
            p_363052_.renderPos = p_365110_.getCartLerpPosition(p_364223_);
            p_363052_.xRot = p_365110_.getCartLerpXRot(p_364223_);
            p_363052_.yRot = p_365110_.getCartLerpYRot(p_364223_);
        } else {
            p_363052_.renderPos = null;
            p_363052_.xRot = p_365349_.getXRot();
            p_363052_.yRot = p_365349_.getYRot();
        }
    }

    private static <T extends AbstractMinecart, S extends MinecartRenderState> void oldExtractState(T p_363303_, OldMinecartBehavior p_363748_, S p_360336_, float p_363476_) {
        float f = 0.3f;
        p_360336_.xRot = p_363303_.getXRot(p_363476_);
        p_360336_.yRot = p_363303_.getYRot(p_363476_);
        double d0 = p_360336_.x;
        double d1 = p_360336_.y;
        double d2 = p_360336_.z;
        Vec3 vec3 = p_363748_.getPos(d0, d1, d2);
        if (vec3 != null) {
            p_360336_.posOnRail = vec3;
            Vec3 vec31 = p_363748_.getPosOffs(d0, d1, d2, 0.3f);
            Vec3 vec32 = p_363748_.getPosOffs(d0, d1, d2, -0.3f);
            p_360336_.frontPos = Objects.requireNonNullElse(vec31, vec3);
            p_360336_.backPos = Objects.requireNonNullElse(vec32, vec3);
        } else {
            p_360336_.posOnRail = null;
            p_360336_.frontPos = null;
            p_360336_.backPos = null;
        }
    }

    protected void renderMinecartContents(S p_365106_, BlockState p_363143_, PoseStack p_363296_, MultiBufferSource p_362225_, int p_361529_) {
        this.blockRenderer.renderSingleBlock(p_363143_, p_363296_, p_362225_, p_361529_, OverlayTexture.NO_OVERLAY);
    }

    @Override
    protected AABB getBoundingBoxForCulling(T p_361172_) {
        AABB aabb = super.getBoundingBoxForCulling(p_361172_);
        return !((AbstractMinecart)p_361172_).getDisplayBlockState().isAir() ? aabb.expandTowards(0.0, (float)((AbstractMinecart)p_361172_).getDisplayOffset() * 0.75f / 16.0f, 0.0) : aabb;
    }

    @Override
    public Vec3 getRenderOffset(S p_363702_) {
        Vec3 vec3 = super.getRenderOffset(p_363702_);
        return ((MinecartRenderState)((Object)p_363702_)).isNewRender && ((MinecartRenderState)((Object)p_363702_)).renderPos != null ? vec3.add(((MinecartRenderState)((Object)p_363702_)).renderPos.x - ((MinecartRenderState)((Object)p_363702_)).x, ((MinecartRenderState)((Object)p_363702_)).renderPos.y - ((MinecartRenderState)((Object)p_363702_)).y, ((MinecartRenderState)((Object)p_363702_)).renderPos.z - ((MinecartRenderState)((Object)p_363702_)).z) : vec3;
    }
}

