/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PathfindingRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Map<Integer, Path> pathMap = Maps.newHashMap();
    private final Map<Integer, Float> pathMaxDist = Maps.newHashMap();
    private final Map<Integer, Long> creationMap = Maps.newHashMap();
    private static final long TIMEOUT = 5000L;
    private static final float MAX_RENDER_DIST = 80.0f;
    private static final boolean SHOW_OPEN_CLOSED = true;
    private static final boolean SHOW_OPEN_CLOSED_COST_MALUS = false;
    private static final boolean SHOW_OPEN_CLOSED_NODE_TYPE_WITH_TEXT = false;
    private static final boolean SHOW_OPEN_CLOSED_NODE_TYPE_WITH_BOX = true;
    private static final boolean SHOW_GROUND_LABELS = true;
    private static final float TEXT_SCALE = 0.02f;

    public void addPath(int p_113612_, Path p_113613_, float p_113614_) {
        this.pathMap.put(p_113612_, p_113613_);
        this.creationMap.put(p_113612_, Util.getMillis());
        this.pathMaxDist.put(p_113612_, Float.valueOf(p_113614_));
    }

    @Override
    public void render(PoseStack p_113629_, MultiBufferSource p_113630_, double p_113631_, double p_113632_, double p_113633_) {
        if (!this.pathMap.isEmpty()) {
            long i = Util.getMillis();
            for (Integer integer : this.pathMap.keySet()) {
                Path path = this.pathMap.get(integer);
                float f = this.pathMaxDist.get(integer).floatValue();
                PathfindingRenderer.renderPath(p_113629_, p_113630_, path, f, true, true, p_113631_, p_113632_, p_113633_);
            }
            for (Integer integer1 : this.creationMap.keySet().toArray(new Integer[0])) {
                if (i - this.creationMap.get(integer1) <= 5000L) continue;
                this.pathMap.remove(integer1);
                this.creationMap.remove(integer1);
            }
        }
    }

    public static void renderPath(PoseStack p_270399_, MultiBufferSource p_270359_, Path p_270189_, float p_270841_, boolean p_270481_, boolean p_270748_, double p_270187_, double p_270252_, double p_270371_) {
        PathfindingRenderer.renderPathLine(p_270399_, p_270359_.getBuffer(RenderType.debugLineStrip(6.0)), p_270189_, p_270187_, p_270252_, p_270371_);
        BlockPos blockpos = p_270189_.getTarget();
        if (PathfindingRenderer.distanceToCamera(blockpos, p_270187_, p_270252_, p_270371_) <= 80.0f) {
            DebugRenderer.renderFilledBox(p_270399_, p_270359_, new AABB((float)blockpos.getX() + 0.25f, (float)blockpos.getY() + 0.25f, (double)blockpos.getZ() + 0.25, (float)blockpos.getX() + 0.75f, (float)blockpos.getY() + 0.75f, (float)blockpos.getZ() + 0.75f).move(-p_270187_, -p_270252_, -p_270371_), 0.0f, 1.0f, 0.0f, 0.5f);
            for (int i = 0; i < p_270189_.getNodeCount(); ++i) {
                Node node = p_270189_.getNode(i);
                if (!(PathfindingRenderer.distanceToCamera(node.asBlockPos(), p_270187_, p_270252_, p_270371_) <= 80.0f)) continue;
                float f = i == p_270189_.getNextNodeIndex() ? 1.0f : 0.0f;
                float f1 = i == p_270189_.getNextNodeIndex() ? 0.0f : 1.0f;
                DebugRenderer.renderFilledBox(p_270399_, p_270359_, new AABB((float)node.x + 0.5f - p_270841_, (float)node.y + 0.01f * (float)i, (float)node.z + 0.5f - p_270841_, (float)node.x + 0.5f + p_270841_, (float)node.y + 0.25f + 0.01f * (float)i, (float)node.z + 0.5f + p_270841_).move(-p_270187_, -p_270252_, -p_270371_), f, 0.0f, f1, 0.5f);
            }
        }
        Path.DebugData path$debugdata = p_270189_.debugData();
        if (p_270481_ && path$debugdata != null) {
            for (Node node1 : path$debugdata.closedSet()) {
                if (!(PathfindingRenderer.distanceToCamera(node1.asBlockPos(), p_270187_, p_270252_, p_270371_) <= 80.0f)) continue;
                DebugRenderer.renderFilledBox(p_270399_, p_270359_, new AABB((float)node1.x + 0.5f - p_270841_ / 2.0f, (float)node1.y + 0.01f, (float)node1.z + 0.5f - p_270841_ / 2.0f, (float)node1.x + 0.5f + p_270841_ / 2.0f, (double)node1.y + 0.1, (float)node1.z + 0.5f + p_270841_ / 2.0f).move(-p_270187_, -p_270252_, -p_270371_), 1.0f, 0.8f, 0.8f, 0.5f);
            }
            for (Node node3 : path$debugdata.openSet()) {
                if (!(PathfindingRenderer.distanceToCamera(node3.asBlockPos(), p_270187_, p_270252_, p_270371_) <= 80.0f)) continue;
                DebugRenderer.renderFilledBox(p_270399_, p_270359_, new AABB((float)node3.x + 0.5f - p_270841_ / 2.0f, (float)node3.y + 0.01f, (float)node3.z + 0.5f - p_270841_ / 2.0f, (float)node3.x + 0.5f + p_270841_ / 2.0f, (double)node3.y + 0.1, (float)node3.z + 0.5f + p_270841_ / 2.0f).move(-p_270187_, -p_270252_, -p_270371_), 0.8f, 1.0f, 1.0f, 0.5f);
            }
        }
        if (p_270748_) {
            for (int j = 0; j < p_270189_.getNodeCount(); ++j) {
                Node node2 = p_270189_.getNode(j);
                if (!(PathfindingRenderer.distanceToCamera(node2.asBlockPos(), p_270187_, p_270252_, p_270371_) <= 80.0f)) continue;
                DebugRenderer.renderFloatingText(p_270399_, p_270359_, String.valueOf((Object)node2.type), (double)node2.x + 0.5, (double)node2.y + 0.75, (double)node2.z + 0.5, -1, 0.02f, true, 0.0f, true);
                DebugRenderer.renderFloatingText(p_270399_, p_270359_, String.format(Locale.ROOT, "%.2f", Float.valueOf(node2.costMalus)), (double)node2.x + 0.5, (double)node2.y + 0.25, (double)node2.z + 0.5, -1, 0.02f, true, 0.0f, true);
            }
        }
    }

    public static void renderPathLine(PoseStack p_270666_, VertexConsumer p_270602_, Path p_270511_, double p_270524_, double p_270163_, double p_270176_) {
        for (int i = 0; i < p_270511_.getNodeCount(); ++i) {
            Node node = p_270511_.getNode(i);
            if (PathfindingRenderer.distanceToCamera(node.asBlockPos(), p_270524_, p_270163_, p_270176_) > 80.0f) continue;
            float f = (float)i / (float)p_270511_.getNodeCount() * 0.33f;
            int j = i == 0 ? 0 : Mth.hsvToRgb(f, 0.9f, 0.9f);
            int k = j >> 16 & 0xFF;
            int l = j >> 8 & 0xFF;
            int i1 = j & 0xFF;
            p_270602_.addVertex(p_270666_.last(), (float)((double)node.x - p_270524_ + 0.5), (float)((double)node.y - p_270163_ + 0.5), (float)((double)node.z - p_270176_ + 0.5)).setColor(k, l, i1, 255);
        }
    }

    private static float distanceToCamera(BlockPos p_113635_, double p_113636_, double p_113637_, double p_113638_) {
        return (float)(Math.abs((double)p_113635_.getX() - p_113636_) + Math.abs((double)p_113635_.getY() - p_113637_) + Math.abs((double)p_113635_.getZ() - p_113638_));
    }
}

