/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.RenderSectionRegion;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;

@OnlyIn(value=Dist.CLIENT)
public class SectionCompiler {
    private final BlockRenderDispatcher blockRenderer;
    private final BlockEntityRenderDispatcher blockEntityRenderer;

    public SectionCompiler(BlockRenderDispatcher p_350768_, BlockEntityRenderDispatcher p_350715_) {
        this.blockRenderer = p_350768_;
        this.blockEntityRenderer = p_350715_;
    }

    public Results compile(SectionPos p_350790_, RenderSectionRegion p_427336_, VertexSorting p_350635_, SectionBufferBuilderPack p_350612_) {
        return this.compile(p_350790_, p_427336_, p_350635_, p_350612_, List.of());
    }

    public Results compile(SectionPos p_350790_, RenderSectionRegion p_427336_, VertexSorting p_350635_, SectionBufferBuilderPack p_350612_, List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers) {
        Results sectioncompiler$results = new Results();
        BlockPos blockpos = p_350790_.origin();
        BlockPos blockpos1 = blockpos.offset(15, 15, 15);
        VisGraph visgraph = new VisGraph();
        PoseStack posestack = new PoseStack();
        ModelBlockRenderer.enableCaching();
        EnumMap<ChunkSectionLayer, BufferBuilder> map = new EnumMap<ChunkSectionLayer, BufferBuilder>(ChunkSectionLayer.class);
        SingleThreadedRandomSource randomsource = new SingleThreadedRandomSource(RandomSupport.generateUniqueSeed());
        ObjectArrayList list = new ObjectArrayList();
        Function<ChunkSectionLayer, VertexConsumer> bufferLookup = renderType -> this.getOrBeginLayer((Map<ChunkSectionLayer, BufferBuilder>)map, p_350612_, (ChunkSectionLayer)((Object)((Object)renderType)));
        for (BlockPos blockPos : BlockPos.betweenClosed(blockpos, blockpos1)) {
            FluidState fluidstate;
            BlockEntity blockentity;
            BlockState blockstate = p_427336_.getBlockState(blockPos);
            if (blockstate.isSolidRender()) {
                visgraph.setOpaque(blockPos);
            }
            if (blockstate.hasBlockEntity() && (blockentity = p_427336_.getBlockEntity(blockPos)) != null) {
                this.handleBlockEntity(sectioncompiler$results, blockentity);
            }
            if (!(fluidstate = blockstate.getFluidState()).isEmpty()) {
                ChunkSectionLayer chunksectionlayer = ItemBlockRenderTypes.getRenderLayer(fluidstate);
                BufferBuilder bufferbuilder = this.getOrBeginLayer(map, p_350612_, chunksectionlayer);
                this.blockRenderer.renderLiquid(blockPos, p_427336_, bufferbuilder, blockstate, fluidstate);
            }
            if (blockstate.getRenderShape() != RenderShape.MODEL) continue;
            randomsource.setSeed(blockstate.getSeed(blockPos));
            this.blockRenderer.getBlockModel(blockstate).collectParts(p_427336_, blockPos, blockstate, randomsource, (List)list);
            posestack.pushPose();
            posestack.translate(SectionPos.sectionRelative(blockPos.getX()), SectionPos.sectionRelative(blockPos.getY()), SectionPos.sectionRelative(blockPos.getZ()));
            this.blockRenderer.renderBatched(blockstate, blockPos, (BlockAndTintGetter)p_427336_, posestack, bufferLookup, true, (List<BlockModelPart>)list);
            posestack.popPose();
            list.clear();
        }
        ClientHooks.addAdditionalGeometry(additionalRenderers, bufferLookup, (RenderSectionRegion)p_427336_, (PoseStack)posestack);
        for (Map.Entry entry : map.entrySet()) {
            ChunkSectionLayer chunksectionlayer1 = (ChunkSectionLayer)((Object)entry.getKey());
            MeshData meshdata = ((BufferBuilder)entry.getValue()).build();
            if (meshdata == null) continue;
            if (chunksectionlayer1 == ChunkSectionLayer.TRANSLUCENT) {
                sectioncompiler$results.transparencyState = meshdata.sortQuads(p_350612_.buffer(chunksectionlayer1), p_350635_);
            }
            sectioncompiler$results.renderedLayers.put(chunksectionlayer1, meshdata);
        }
        ModelBlockRenderer.clearCache();
        sectioncompiler$results.visibilitySet = visgraph.resolve();
        return sectioncompiler$results;
    }

    private BufferBuilder getOrBeginLayer(Map<ChunkSectionLayer, BufferBuilder> p_350651_, SectionBufferBuilderPack p_350965_, ChunkSectionLayer p_427511_) {
        BufferBuilder bufferbuilder = p_350651_.get((Object)p_427511_);
        if (bufferbuilder == null) {
            ByteBufferBuilder bytebufferbuilder = p_350965_.buffer(p_427511_);
            bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
            p_350651_.put(p_427511_, bufferbuilder);
        }
        return bufferbuilder;
    }

    private <E extends BlockEntity> void handleBlockEntity(Results p_350754_, E p_350386_) {
        BlockEntityRenderer<E> blockentityrenderer = this.blockEntityRenderer.getRenderer(p_350386_);
        if (blockentityrenderer != null && !blockentityrenderer.shouldRenderOffScreen()) {
            p_350754_.blockEntities.add(p_350386_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Results {
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final Map<ChunkSectionLayer, MeshData> renderedLayers = new EnumMap<ChunkSectionLayer, MeshData>(ChunkSectionLayer.class);
        public VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        public MeshData.SortState transparencyState;

        public void release() {
            this.renderedLayers.values().forEach(MeshData::close);
        }
    }
}

