/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompileTaskDynamicQueue {
    private static final int MAX_RECOMPILE_QUOTA = 2;
    private int recompileQuota = 2;
    private final List<SectionRenderDispatcher.RenderSection.CompileTask> tasks = new ObjectArrayList();
    private volatile int size = 0;

    public synchronized void add(SectionRenderDispatcher.RenderSection.CompileTask p_366842_) {
        this.tasks.add(p_366842_);
        ++this.size;
    }

    @Nullable
    public synchronized SectionRenderDispatcher.RenderSection.CompileTask poll(Vec3 p_366737_) {
        boolean flag1;
        int i = -1;
        int j = -1;
        double d0 = Double.MAX_VALUE;
        double d1 = Double.MAX_VALUE;
        ListIterator<SectionRenderDispatcher.RenderSection.CompileTask> listiterator = this.tasks.listIterator();
        while (listiterator.hasNext()) {
            int k = listiterator.nextIndex();
            SectionRenderDispatcher.RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask = listiterator.next();
            if (sectionrenderdispatcher$rendersection$compiletask.isCancelled.get()) {
                listiterator.remove();
                continue;
            }
            double d2 = sectionrenderdispatcher$rendersection$compiletask.getRenderOrigin().distToCenterSqr(p_366737_);
            if (!sectionrenderdispatcher$rendersection$compiletask.isRecompile() && d2 < d0) {
                d0 = d2;
                i = k;
            }
            if (!sectionrenderdispatcher$rendersection$compiletask.isRecompile() || !(d2 < d1)) continue;
            d1 = d2;
            j = k;
        }
        boolean flag = j >= 0;
        boolean bl = flag1 = i >= 0;
        if (!flag || flag1 && (this.recompileQuota <= 0 || !(d1 < d0))) {
            this.recompileQuota = 2;
            return this.removeTaskByIndex(i);
        }
        --this.recompileQuota;
        return this.removeTaskByIndex(j);
    }

    public int size() {
        return this.size;
    }

    @Nullable
    private SectionRenderDispatcher.RenderSection.CompileTask removeTaskByIndex(int p_366525_) {
        if (p_366525_ >= 0) {
            --this.size;
            return this.tasks.remove(p_366525_);
        }
        return null;
    }

    public synchronized void clear() {
        for (SectionRenderDispatcher.RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask : this.tasks) {
            sectionrenderdispatcher$rendersection$compiletask.cancel();
        }
        this.tasks.clear();
        this.size = 0;
    }
}

