/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum ChunkSectionLayer {
    SOLID(RenderPipelines.SOLID, 0x400000, true, false),
    CUTOUT_MIPPED(RenderPipelines.CUTOUT_MIPPED, 0x400000, true, false),
    CUTOUT(RenderPipelines.CUTOUT, 786432, false, false),
    TRANSLUCENT(RenderPipelines.TRANSLUCENT, 786432, true, true),
    TRIPWIRE(RenderPipelines.TRIPWIRE, 1536, true, true);

    private final RenderPipeline pipeline;
    private final int bufferSize;
    private final boolean useMipmaps;
    private final boolean sortOnUpload;
    private final String label;

    private ChunkSectionLayer(RenderPipeline p_427401_, int p_427231_, boolean p_427353_, boolean p_427370_) {
        this.pipeline = p_427401_;
        this.bufferSize = p_427231_;
        this.useMipmaps = p_427353_;
        this.sortOnUpload = p_427370_;
        this.label = this.toString().toLowerCase(Locale.ROOT);
    }

    public RenderPipeline pipeline() {
        return this.pipeline;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public String label() {
        return this.label;
    }

    public boolean sortOnUpload() {
        return this.sortOnUpload;
    }

    public GpuTextureView textureView() {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstracttexture = texturemanager.getTexture(TextureAtlas.LOCATION_BLOCKS);
        abstracttexture.setUseMipmaps(this.useMipmaps);
        return abstracttexture.getTextureView();
    }

    public RenderTarget outputTarget() {
        Minecraft minecraft = Minecraft.getInstance();
        switch (this.ordinal()) {
            case 3: {
                RenderTarget rendertarget1 = minecraft.levelRenderer.getTranslucentTarget();
                return rendertarget1 != null ? rendertarget1 : minecraft.getMainRenderTarget();
            }
            case 4: {
                RenderTarget rendertarget = minecraft.levelRenderer.getWeatherTarget();
                return rendertarget != null ? rendertarget : minecraft.getMainRenderTarget();
            }
        }
        return minecraft.getMainRenderTarget();
    }
}

