/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityWithBoundingBoxRenderer;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TestInstanceRenderer
implements BlockEntityRenderer<TestInstanceBlockEntity> {
    private final BeaconRenderer<TestInstanceBlockEntity> beacon;
    private final BlockEntityWithBoundingBoxRenderer<TestInstanceBlockEntity> box;

    public TestInstanceRenderer(BlockEntityRendererProvider.Context p_397450_) {
        this.beacon = new BeaconRenderer(p_397450_);
        this.box = new BlockEntityWithBoundingBoxRenderer(p_397450_);
    }

    @Override
    public void render(TestInstanceBlockEntity p_397390_, float p_397164_, PoseStack p_397714_, MultiBufferSource p_397845_, int p_397115_, int p_397818_, Vec3 p_401004_) {
        this.beacon.render(p_397390_, p_397164_, p_397714_, p_397845_, p_397115_, p_397818_, p_401004_);
        this.box.render(p_397390_, p_397164_, p_397714_, p_397845_, p_397115_, p_397818_, p_401004_);
    }

    @Override
    public boolean shouldRenderOffScreen() {
        return this.beacon.shouldRenderOffScreen() || this.box.shouldRenderOffScreen();
    }

    @Override
    public int getViewDistance() {
        return Math.max(this.beacon.getViewDistance(), this.box.getViewDistance());
    }

    @Override
    public boolean shouldRender(TestInstanceBlockEntity p_397042_, Vec3 p_397171_) {
        return this.beacon.shouldRender(p_397042_, p_397171_) || this.box.shouldRender(p_397042_, p_397171_);
    }
}

