/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ShulkerBoxRenderer
implements BlockEntityRenderer<ShulkerBoxBlockEntity> {
    private final ShulkerBoxModel model;

    public ShulkerBoxRenderer(BlockEntityRendererProvider.Context p_173626_) {
        this(p_173626_.getModelSet());
    }

    public ShulkerBoxRenderer(EntityModelSet p_388849_) {
        this.model = new ShulkerBoxModel(p_388849_.bakeLayer(ModelLayers.SHULKER_BOX));
    }

    @Override
    public void render(ShulkerBoxBlockEntity p_112478_, float p_112479_, PoseStack p_112480_, MultiBufferSource p_112481_, int p_112482_, int p_112483_, Vec3 p_401208_) {
        Direction direction = p_112478_.getBlockState().getValueOrElse(ShulkerBoxBlock.FACING, Direction.UP);
        DyeColor dyecolor = p_112478_.getColor();
        Material material = dyecolor == null ? Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION : Sheets.getShulkerBoxMaterial(dyecolor);
        float f = p_112478_.getProgress(p_112479_);
        this.render(p_112480_, p_112481_, p_112482_, p_112483_, direction, f, material);
    }

    public void render(PoseStack p_388735_, MultiBufferSource p_386677_, int p_388822_, int p_386683_, Direction p_387528_, float p_387342_, Material p_387103_) {
        p_388735_.pushPose();
        this.prepareModel(p_388735_, p_387528_, p_387342_);
        VertexConsumer vertexconsumer = p_387103_.buffer(p_386677_, this.model::renderType);
        this.model.renderToBuffer(p_388735_, vertexconsumer, p_388822_, p_386683_);
        p_388735_.popPose();
    }

    private void prepareModel(PoseStack p_428342_, Direction p_428479_, float p_428538_) {
        p_428342_.translate(0.5f, 0.5f, 0.5f);
        float f = 0.9995f;
        p_428342_.scale(0.9995f, 0.9995f, 0.9995f);
        p_428342_.mulPose((Quaternionfc)p_428479_.getRotation());
        p_428342_.scale(1.0f, -1.0f, -1.0f);
        p_428342_.translate(0.0f, -1.0f, 0.0f);
        this.model.animate(p_428538_);
    }

    public void getExtents(Direction p_428199_, float p_428569_, Set<Vector3f> p_428287_) {
        PoseStack posestack = new PoseStack();
        this.prepareModel(posestack, p_428199_, p_428569_);
        this.model.root().getExtentsForGui(posestack, p_428287_);
    }

    public AABB getRenderBoundingBox(ShulkerBoxBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5, (double)pos.getX() + 1.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 1.5);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ShulkerBoxModel
    extends Model {
        private final ModelPart lid;

        public ShulkerBoxModel(ModelPart p_361240_) {
            super(p_361240_, RenderType::entityCutoutNoCull);
            this.lid = p_361240_.getChild("lid");
        }

        public void animate(float p_365330_) {
            this.lid.setPos(0.0f, 24.0f - p_365330_ * 0.5f * 16.0f, 0.0f);
            this.lid.yRot = 270.0f * p_365330_ * ((float)Math.PI / 180);
        }
    }
}

