/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Quadrant;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record Variant(ResourceLocation modelLocation, SimpleModelState modelState) implements BlockModelPart.Unbaked
{
    public static final MapCodec<Variant> MAP_CODEC = RecordCodecBuilder.mapCodec(p_409079_ -> p_409079_.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Variant::modelLocation), (App)SimpleModelState.MAP_CODEC.forGetter(Variant::modelState)).apply((Applicative)p_409079_, Variant::new));
    public static final Codec<Variant> CODEC = MAP_CODEC.codec();

    public Variant(ResourceLocation p_404842_) {
        this(p_404842_, SimpleModelState.DEFAULT);
    }

    public Variant withXRot(Quadrant p_404895_) {
        return this.withState(this.modelState.withX(p_404895_));
    }

    public Variant withYRot(Quadrant p_404966_) {
        return this.withState(this.modelState.withY(p_404966_));
    }

    public Variant withUvLock(boolean p_405100_) {
        return this.withState(this.modelState.withUvLock(p_405100_));
    }

    public Variant withModel(ResourceLocation p_405850_) {
        return new Variant(p_405850_, this.modelState);
    }

    public Variant withState(SimpleModelState p_404847_) {
        return new Variant(this.modelLocation, p_404847_);
    }

    public Variant with(VariantMutator p_405775_) {
        return (Variant)p_405775_.apply(this);
    }

    @Override
    public BlockModelPart bake(ModelBaker p_410762_) {
        return SimpleModelWrapper.bake(p_410762_, this.modelLocation, this.modelState.asModelState());
    }

    @Override
    public void resolveDependencies(ResolvableModel.Resolver p_410425_) {
        p_410425_.markDependency(this.modelLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record SimpleModelState(Quadrant x, Quadrant y, boolean uvLock) {
        public static final MapCodec<SimpleModelState> MAP_CODEC = RecordCodecBuilder.mapCodec(p_405304_ -> p_405304_.group((App)Quadrant.CODEC.optionalFieldOf("x", (Object)Quadrant.R0).forGetter(SimpleModelState::x), (App)Quadrant.CODEC.optionalFieldOf("y", (Object)Quadrant.R0).forGetter(SimpleModelState::y), (App)Codec.BOOL.optionalFieldOf("uvlock", (Object)false).forGetter(SimpleModelState::uvLock)).apply((Applicative)p_405304_, SimpleModelState::new));
        public static final SimpleModelState DEFAULT = new SimpleModelState(Quadrant.R0, Quadrant.R0, false);

        public ModelState asModelState() {
            BlockModelRotation blockmodelrotation = BlockModelRotation.by(this.x, this.y);
            return this.uvLock ? blockmodelrotation.withUvLock() : blockmodelrotation;
        }

        public SimpleModelState withX(Quadrant p_405203_) {
            return new SimpleModelState(p_405203_, this.y, this.uvLock);
        }

        public SimpleModelState withY(Quadrant p_405288_) {
            return new SimpleModelState(this.x, p_405288_, this.uvLock);
        }

        public SimpleModelState withUvLock(boolean p_405150_) {
            return new SimpleModelState(this.x, this.y, p_405150_);
        }
    }
}

