/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TextureSlots {
    public static final TextureSlots EMPTY = new TextureSlots(Map.of());
    private static final char REFERENCE_CHAR = '#';
    private final Map<String, Material> resolvedValues;

    TextureSlots(Map<String, Material> p_387448_) {
        this.resolvedValues = p_387448_;
    }

    @Nullable
    public Material getMaterial(String p_387889_) {
        if (TextureSlots.isTextureReference(p_387889_)) {
            p_387889_ = p_387889_.substring(1);
        }
        return this.resolvedValues.get(p_387889_);
    }

    private static boolean isTextureReference(String p_388918_) {
        return p_388918_.charAt(0) == '#';
    }

    public static Data parseTextureMap(JsonObject p_387105_, ResourceLocation p_387237_) {
        Data.Builder textureslots$data$builder = new Data.Builder();
        for (Map.Entry entry : p_387105_.entrySet()) {
            TextureSlots.parseEntry(p_387237_, (String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString(), textureslots$data$builder);
        }
        return textureslots$data$builder.build();
    }

    private static void parseEntry(ResourceLocation p_387514_, String p_388911_, String p_386463_, Data.Builder p_387858_) {
        if (TextureSlots.isTextureReference(p_386463_)) {
            p_387858_.addReference(p_388911_, p_386463_.substring(1));
        } else {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(p_386463_);
            if (resourcelocation == null) {
                throw new JsonParseException(p_386463_ + " is not valid resource location");
            }
            p_387858_.addTexture(p_388911_, new Material(p_387514_, resourcelocation));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Data(Map<String, SlotContents> values) {
        public static final Data EMPTY = new Data(Map.of());

        @OnlyIn(value=Dist.CLIENT)
        public static class Builder {
            private final Map<String, SlotContents> textureMap = new HashMap<String, SlotContents>();

            public Builder addReference(String p_388062_, String p_388610_) {
                this.textureMap.put(p_388062_, new Reference(p_388610_));
                return this;
            }

            public Builder addTexture(String p_388884_, Material p_387399_) {
                this.textureMap.put(p_388884_, new Value(p_387399_));
                return this;
            }

            public Data build() {
                return this.textureMap.isEmpty() ? EMPTY : new Data(Map.copyOf(this.textureMap));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record Value(Material material) implements SlotContents
    {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static sealed interface SlotContents
    permits Value, Reference {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Resolver {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final List<Data> entries = new ArrayList<Data>();

        public Resolver addLast(Data p_387439_) {
            this.entries.addLast(p_387439_);
            return this;
        }

        public Resolver addFirst(Data p_388591_) {
            this.entries.addFirst(p_388591_);
            return this;
        }

        public TextureSlots resolve(ModelDebugName p_388348_) {
            if (this.entries.isEmpty()) {
                return EMPTY;
            }
            Object2ObjectArrayMap object2objectmap = new Object2ObjectArrayMap();
            Object2ObjectArrayMap object2objectmap1 = new Object2ObjectArrayMap();
            for (Data textureslots$data : Lists.reverse(this.entries)) {
                textureslots$data.values.forEach((arg_0, arg_1) -> Resolver.lambda$resolve$0((Object2ObjectMap)object2objectmap1, (Object2ObjectMap)object2objectmap, arg_0, arg_1));
            }
            if (object2objectmap1.isEmpty()) {
                return new TextureSlots((Map<String, Material>)object2objectmap);
            }
            boolean flag = true;
            while (flag) {
                flag = false;
                ObjectIterator objectiterator = Object2ObjectMaps.fastIterator((Object2ObjectMap)object2objectmap1);
                while (objectiterator.hasNext()) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)objectiterator.next();
                    Material material = (Material)object2objectmap.get((Object)((Reference)entry.getValue()).target);
                    if (material == null) continue;
                    object2objectmap.put((Object)((String)entry.getKey()), (Object)material);
                    objectiterator.remove();
                    flag = true;
                }
            }
            if (!object2objectmap1.isEmpty()) {
                LOGGER.warn("Unresolved texture references in {}:\n{}", (Object)p_388348_.debugName(), (Object)object2objectmap1.entrySet().stream().map(p_387981_ -> "\t#" + (String)p_387981_.getKey() + "-> #" + ((Reference)p_387981_.getValue()).target + "\n").collect(Collectors.joining()));
            }
            return new TextureSlots((Map<String, Material>)object2objectmap);
        }

        private static /* synthetic */ void lambda$resolve$0(Object2ObjectMap object2objectmap1, Object2ObjectMap object2objectmap, String p_389334_, SlotContents p_389335_) {
            SlotContents slotContents = p_389335_;
            Objects.requireNonNull(slotContents);
            SlotContents selector0$temp = slotContents;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Value.class, Reference.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    Value textureslots$value = (Value)selector0$temp;
                    object2objectmap1.remove((Object)p_389334_);
                    object2objectmap.put((Object)p_389334_, (Object)textureslots$value.material());
                    break;
                }
                case 1: {
                    Reference textureslots$reference = (Reference)selector0$temp;
                    object2objectmap.remove((Object)p_389334_);
                    object2objectmap1.put((Object)p_389334_, (Object)textureslots$reference);
                    break;
                }
                default: {
                    throw new MatchException(null, null);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record Reference(String target) implements SlotContents
    {
    }
}

