/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;

@OnlyIn(value=Dist.CLIENT)
public record SimpleModelWrapper(QuadCollection quads, boolean useAmbientOcclusion, TextureAtlasSprite particleIcon, @Nullable ChunkSectionLayer renderType) implements BlockModelPart
{
    @Deprecated
    public SimpleModelWrapper(QuadCollection quads, boolean useAmbientOcclusion, TextureAtlasSprite particleIcon) {
        this(quads, useAmbientOcclusion, particleIcon, null);
    }

    public static SimpleModelWrapper bake(ModelBaker p_405335_, ResourceLocation p_405098_, ModelState p_405869_) {
        ResolvedModel resolvedmodel = p_405335_.getModel(p_405098_);
        return SimpleModelWrapper.bake(p_405335_, resolvedmodel, p_405869_);
    }

    public static SimpleModelWrapper bake(ModelBaker p_405335_, ResolvedModel resolvedmodel, ModelState p_405869_) {
        TextureSlots textureslots = resolvedmodel.getTopTextureSlots();
        boolean flag = resolvedmodel.getTopAmbientOcclusion();
        TextureAtlasSprite textureatlassprite = resolvedmodel.resolveParticleSprite(textureslots, p_405335_);
        QuadCollection quadcollection = resolvedmodel.bakeTopGeometry(textureslots, p_405335_, p_405869_);
        RenderTypeGroup renderTypeGroup = (RenderTypeGroup)resolvedmodel.getTopAdditionalProperties().getOptional(NeoForgeModelProperties.RENDER_TYPE);
        ChunkSectionLayer renderTypes = renderTypeGroup == null || renderTypeGroup.isEmpty() ? null : renderTypeGroup.block();
        return new SimpleModelWrapper(quadcollection, flag, textureatlassprite, renderTypes);
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable Direction p_405263_) {
        return this.quads.getQuads(p_405263_);
    }

    public ChunkSectionLayer getRenderType(BlockState state) {
        return this.renderType != null ? this.renderType : BlockModelPart.super.getRenderType(state);
    }
}

