/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.TransformationHelper;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public record ItemTransform(Vector3fc rotation, Vector3fc translation, Vector3fc scale, Vector3fc rightRotation) {
    public static final ItemTransform NO_TRANSFORM = new ItemTransform((Vector3fc)new Vector3f(), (Vector3fc)new Vector3f(), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f));

    public ItemTransform(Vector3fc rotation, Vector3fc translation, Vector3fc scale) {
        this(rotation, translation, scale, (Vector3fc)new Vector3f());
    }

    public void apply(boolean p_111764_, PoseStack.Pose p_405188_) {
        if (this == NO_TRANSFORM) {
            p_405188_.translate(-0.5f, -0.5f, -0.5f);
        } else {
            float f2;
            float f1;
            float f;
            if (p_111764_) {
                f = -this.translation.x();
                f1 = -this.rotation.y();
                f2 = -this.rotation.z();
            } else {
                f = this.translation.x();
                f1 = this.rotation.y();
                f2 = this.rotation.z();
            }
            p_405188_.translate(f, this.translation.y(), this.translation.z());
            p_405188_.rotate((Quaternionfc)new Quaternionf().rotationXYZ(this.rotation.x() * ((float)Math.PI / 180), f1 * ((float)Math.PI / 180), f2 * ((float)Math.PI / 180)));
            p_405188_.scale(this.scale.x(), this.scale.y(), this.scale.z());
            p_405188_.rotate((Quaternionfc)TransformationHelper.quatFromXYZ((float)this.rightRotation.x(), (float)(this.rightRotation.y() * (float)(p_111764_ ? -1 : 1)), (float)(this.rightRotation.z() * (float)(p_111764_ ? -1 : 1)), (boolean)true));
            p_405188_.translate(-0.5f, -0.5f, -0.5f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ItemTransform> {
        public static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
        public static final Vector3f DEFAULT_TRANSLATION = new Vector3f(0.0f, 0.0f, 0.0f);
        public static final Vector3f DEFAULT_SCALE = new Vector3f(1.0f, 1.0f, 1.0f);
        public static final float MAX_TRANSLATION = 5.0f;
        public static final float MAX_SCALE = 4.0f;

        public ItemTransform deserialize(JsonElement p_111775_, Type p_111776_, JsonDeserializationContext p_111777_) throws JsonParseException {
            JsonObject jsonobject = p_111775_.getAsJsonObject();
            Vector3f vector3f = this.getVector3f(jsonobject, "rotation", DEFAULT_ROTATION);
            Vector3f vector3f1 = this.getVector3f(jsonobject, "translation", DEFAULT_TRANSLATION);
            vector3f1.mul(0.0625f);
            vector3f1.set(Mth.clamp(vector3f1.x, -5.0f, 5.0f), Mth.clamp(vector3f1.y, -5.0f, 5.0f), Mth.clamp(vector3f1.z, -5.0f, 5.0f));
            Vector3f vector3f2 = this.getVector3f(jsonobject, "scale", DEFAULT_SCALE);
            vector3f2.set(Mth.clamp(vector3f2.x, -4.0f, 4.0f), Mth.clamp(vector3f2.y, -4.0f, 4.0f), Mth.clamp(vector3f2.z, -4.0f, 4.0f));
            Vector3f rightRotation = this.getVector3f(jsonobject, "right_rotation", DEFAULT_ROTATION);
            return new ItemTransform((Vector3fc)vector3f, (Vector3fc)vector3f1, (Vector3fc)vector3f2, (Vector3fc)rightRotation);
        }

        private Vector3f getVector3f(JsonObject p_111779_, String p_111780_, Vector3f p_253777_) {
            if (!p_111779_.has(p_111780_)) {
                return p_253777_;
            }
            JsonArray jsonarray = GsonHelper.getAsJsonArray(p_111779_, p_111780_);
            if (jsonarray.size() != 3) {
                throw new JsonParseException("Expected 3 " + p_111780_ + " values, found: " + jsonarray.size());
            }
            float[] afloat = new float[3];
            for (int i = 0; i < afloat.length; ++i) {
                afloat[i] = GsonHelper.convertToFloat(jsonarray.get(i), p_111780_ + "[" + i + "]");
            }
            return new Vector3f(afloat[0], afloat[1], afloat[2]);
        }
    }
}

