/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.context.ContextMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import net.neoforged.neoforge.client.model.UnbakedModelParser;
import net.neoforged.neoforge.common.util.TransformationHelper;

@OnlyIn(value=Dist.CLIENT)
public record BlockModel(@Nullable UnbakedGeometry geometry, @Nullable UnbakedModel.GuiLight guiLight, @Nullable Boolean ambientOcclusion, @Nullable ItemTransforms transforms, TextureSlots.Data textureSlots, @Nullable ResourceLocation parent, @Nullable Transformation rootTransform, RenderTypeGroup renderTypeGroup, Map<String, Boolean> partVisibility) implements UnbakedModel
{
    @VisibleForTesting
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(UnbakedModel.class, (Object)new UnbakedModelParser.Deserializer()).registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(Transformation.class, (Object)new TransformationHelper.Deserializer()).create();

    public BlockModel(@Nullable UnbakedGeometry geometry, @Nullable UnbakedModel.GuiLight guiLight, @Nullable Boolean ambientOcclusion, @Nullable ItemTransforms transforms, TextureSlots.Data textureSlots, @Nullable ResourceLocation parent) {
        this(geometry, guiLight, ambientOcclusion, transforms, textureSlots, parent, null, RenderTypeGroup.EMPTY, Map.of());
    }

    @Deprecated
    public static BlockModel fromStream(Reader p_111462_) {
        return GsonHelper.fromJson(GSON, p_111462_, BlockModel.class);
    }

    public void fillAdditionalProperties(ContextMap.Builder propertiesBuilder) {
        NeoForgeModelProperties.fillRootTransformProperty((ContextMap.Builder)propertiesBuilder, (Transformation)this.rootTransform);
        NeoForgeModelProperties.fillRenderTypeProperty((ContextMap.Builder)propertiesBuilder, (RenderTypeGroup)this.renderTypeGroup);
        NeoForgeModelProperties.fillPartVisibilityProperty((ContextMap.Builder)propertiesBuilder, this.partVisibility);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement p_111498_, Type p_111499_, JsonDeserializationContext p_111500_) throws JsonParseException {
            JsonObject jsonobject = p_111498_.getAsJsonObject();
            UnbakedGeometry unbakedgeometry = this.getElements(p_111500_, jsonobject);
            String s = this.getParentName(jsonobject);
            TextureSlots.Data textureslots$data = this.getTextureMap(jsonobject);
            Boolean obool = this.getAmbientOcclusion(jsonobject);
            ItemTransforms itemtransforms = null;
            if (jsonobject.has("display")) {
                JsonObject jsonobject1 = GsonHelper.getAsJsonObject(jsonobject, "display");
                itemtransforms = (ItemTransforms)p_111500_.deserialize((JsonElement)jsonobject1, ItemTransforms.class);
            }
            UnbakedModel.GuiLight unbakedmodel$guilight = null;
            if (jsonobject.has("gui_light")) {
                unbakedmodel$guilight = UnbakedModel.GuiLight.getByName(GsonHelper.getAsString(jsonobject, "gui_light"));
            }
            ResourceLocation resourcelocation = s.isEmpty() ? null : ResourceLocation.parse(s);
            Transformation rootTransform = NeoForgeModelProperties.deserializeRootTransform((JsonObject)jsonobject, (JsonDeserializationContext)p_111500_);
            RenderTypeGroup renderTypeGroup = NeoForgeModelProperties.deserializeRenderType((JsonObject)jsonobject);
            Map partVisibility = NeoForgeModelProperties.deserializePartVisibility((JsonObject)jsonobject);
            return new BlockModel(unbakedgeometry, unbakedmodel$guilight, obool, itemtransforms, textureslots$data, resourcelocation, rootTransform, renderTypeGroup, partVisibility);
        }

        private TextureSlots.Data getTextureMap(JsonObject p_111510_) {
            if (p_111510_.has("textures")) {
                JsonObject jsonobject = GsonHelper.getAsJsonObject(p_111510_, "textures");
                return TextureSlots.parseTextureMap(jsonobject, TextureAtlas.LOCATION_BLOCKS);
            }
            return TextureSlots.Data.EMPTY;
        }

        private String getParentName(JsonObject p_111512_) {
            return GsonHelper.getAsString(p_111512_, "parent", "");
        }

        @Nullable
        protected Boolean getAmbientOcclusion(JsonObject p_273052_) {
            return p_273052_.has("ambientocclusion") ? Boolean.valueOf(GsonHelper.getAsBoolean(p_273052_, "ambientocclusion")) : null;
        }

        @Nullable
        protected UnbakedGeometry getElements(JsonDeserializationContext p_111507_, JsonObject p_111508_) {
            if (!p_111508_.has("elements")) {
                return null;
            }
            ArrayList<BlockElement> list = new ArrayList<BlockElement>();
            for (JsonElement jsonelement : GsonHelper.getAsJsonArray(p_111508_, "elements")) {
                list.add((BlockElement)p_111507_.deserialize(jsonelement, BlockElement.class));
            }
            return new SimpleUnbakedGeometry(list);
        }
    }
}

