/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@OnlyIn(value=Dist.CLIENT)
public class WorldBorderRenderer {
    public static final ResourceLocation FORCEFIELD_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/forcefield.png");
    private boolean needsRebuild = true;
    private double lastMinX;
    private double lastMinZ;
    private double lastBorderMinX;
    private double lastBorderMaxX;
    private double lastBorderMinZ;
    private double lastBorderMaxZ;
    private final GpuBuffer worldBorderBuffer = RenderSystem.getDevice().createBuffer(() -> "World border vertex buffer", 40, 16 * DefaultVertexFormat.POSITION_TEX.getVertexSize());
    private final RenderSystem.AutoStorageIndexBuffer indices = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);

    private void rebuildWorldBorderBuffer(WorldBorder p_401795_, double p_401863_, double p_401925_, double p_401782_, float p_401880_, float p_401871_, float p_401854_) {
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized(DefaultVertexFormat.POSITION_TEX.getVertexSize() * 4 * 4);){
            double d0 = p_401795_.getMinX();
            double d1 = p_401795_.getMaxX();
            double d2 = p_401795_.getMinZ();
            double d3 = p_401795_.getMaxZ();
            double d4 = Math.max((double)Mth.floor(p_401925_ - p_401863_), d2);
            double d5 = Math.min((double)Mth.ceil(p_401925_ + p_401863_), d3);
            float f = (float)(Mth.floor(d4) & 1) * 0.5f;
            float f1 = (float)(d5 - d4) / 2.0f;
            double d6 = Math.max((double)Mth.floor(p_401782_ - p_401863_), d0);
            double d7 = Math.min((double)Mth.ceil(p_401782_ + p_401863_), d1);
            float f2 = (float)(Mth.floor(d6) & 1) * 0.5f;
            float f3 = (float)(d7 - d6) / 2.0f;
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(0.0f, -p_401880_, (float)(d3 - d4)).setUv(f2, p_401871_);
            bufferbuilder.addVertex((float)(d7 - d6), -p_401880_, (float)(d3 - d4)).setUv(f3 + f2, p_401871_);
            bufferbuilder.addVertex((float)(d7 - d6), p_401880_, (float)(d3 - d4)).setUv(f3 + f2, p_401854_);
            bufferbuilder.addVertex(0.0f, p_401880_, (float)(d3 - d4)).setUv(f2, p_401854_);
            bufferbuilder.addVertex(0.0f, -p_401880_, 0.0f).setUv(f, p_401871_);
            bufferbuilder.addVertex(0.0f, -p_401880_, (float)(d5 - d4)).setUv(f1 + f, p_401871_);
            bufferbuilder.addVertex(0.0f, p_401880_, (float)(d5 - d4)).setUv(f1 + f, p_401854_);
            bufferbuilder.addVertex(0.0f, p_401880_, 0.0f).setUv(f, p_401854_);
            bufferbuilder.addVertex((float)(d7 - d6), -p_401880_, 0.0f).setUv(f2, p_401871_);
            bufferbuilder.addVertex(0.0f, -p_401880_, 0.0f).setUv(f3 + f2, p_401871_);
            bufferbuilder.addVertex(0.0f, p_401880_, 0.0f).setUv(f3 + f2, p_401854_);
            bufferbuilder.addVertex((float)(d7 - d6), p_401880_, 0.0f).setUv(f2, p_401854_);
            bufferbuilder.addVertex((float)(d1 - d6), -p_401880_, (float)(d5 - d4)).setUv(f, p_401871_);
            bufferbuilder.addVertex((float)(d1 - d6), -p_401880_, 0.0f).setUv(f1 + f, p_401871_);
            bufferbuilder.addVertex((float)(d1 - d6), p_401880_, 0.0f).setUv(f1 + f, p_401854_);
            bufferbuilder.addVertex((float)(d1 - d6), p_401880_, (float)(d5 - d4)).setUv(f, p_401854_);
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(this.worldBorderBuffer.slice(), meshdata.vertexBuffer());
            }
            this.lastBorderMinX = d0;
            this.lastBorderMaxX = d1;
            this.lastBorderMinZ = d2;
            this.lastBorderMaxZ = d3;
            this.lastMinX = d6;
            this.lastMinZ = d4;
            this.needsRebuild = false;
        }
    }

    public void render(WorldBorder p_365515_, Vec3 p_360961_, double p_364707_, double p_361253_) {
        double d0 = p_365515_.getMinX();
        double d1 = p_365515_.getMaxX();
        double d2 = p_365515_.getMinZ();
        double d3 = p_365515_.getMaxZ();
        if (!(p_360961_.x < d1 - p_364707_ && p_360961_.x > d0 + p_364707_ && p_360961_.z < d3 - p_364707_ && p_360961_.z > d2 + p_364707_ || p_360961_.x < d0 - p_364707_ || p_360961_.x > d1 + p_364707_ || p_360961_.z < d2 - p_364707_ || p_360961_.z > d3 + p_364707_)) {
            GpuTextureView gputextureview1;
            GpuTextureView gputextureview;
            double d4 = 1.0 - p_365515_.getDistanceToBorder(p_360961_.x, p_360961_.z) / p_364707_;
            d4 = Math.pow(d4, 4.0);
            d4 = Mth.clamp(d4, 0.0, 1.0);
            double d5 = p_360961_.x;
            double d6 = p_360961_.z;
            float f = (float)p_361253_;
            int i = p_365515_.getStatus().getColor();
            float f1 = (float)ARGB.red(i) / 255.0f;
            float f2 = (float)ARGB.green(i) / 255.0f;
            float f3 = (float)ARGB.blue(i) / 255.0f;
            float f4 = (float)(Util.getMillis() % 3000L) / 3000.0f;
            float f5 = (float)(-Mth.frac(p_360961_.y * 0.5));
            float f6 = f5 + f;
            if (this.shouldRebuildWorldBorderBuffer(p_365515_)) {
                this.rebuildWorldBorderBuffer(p_365515_, p_364707_, d6, d5, f, f6, f5);
            }
            TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
            AbstractTexture abstracttexture = texturemanager.getTexture(FORCEFIELD_LOCATION);
            abstracttexture.setUseMipmaps(false);
            RenderPipeline renderpipeline = RenderPipelines.WORLD_BORDER;
            RenderTarget rendertarget = Minecraft.getInstance().getMainRenderTarget();
            RenderTarget rendertarget1 = Minecraft.getInstance().levelRenderer.getWeatherTarget();
            if (rendertarget1 != null) {
                gputextureview = rendertarget1.getColorTextureView();
                gputextureview1 = rendertarget1.getDepthTextureView();
            } else {
                gputextureview = rendertarget.getColorTextureView();
                gputextureview1 = rendertarget.getDepthTextureView();
            }
            GpuBuffer gpubuffer = this.indices.getBuffer(6);
            GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(f1, f2, f3, (float)d4), (Vector3fc)new Vector3f((float)(this.lastMinX - d5), (float)(-p_360961_.y), (float)(this.lastMinZ - d6)), (Matrix4fc)new Matrix4f().translation(f4, f4, 0.0f), 0.0f);
            try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "World border", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
                renderpass.setPipeline(renderpipeline);
                RenderSystem.bindDefaultUniforms(renderpass);
                renderpass.setUniform("DynamicTransforms", gpubufferslice);
                renderpass.setIndexBuffer(gpubuffer, this.indices.type());
                renderpass.bindSampler("Sampler0", abstracttexture.getTextureView());
                renderpass.setVertexBuffer(0, this.worldBorderBuffer);
                ArrayList arraylist = new ArrayList();
                for (WorldBorder.DistancePerDirection worldborder$distanceperdirection : p_365515_.closestBorder(d5, d6)) {
                    if (!(worldborder$distanceperdirection.distance() < p_364707_)) continue;
                    int j = worldborder$distanceperdirection.direction().get2DDataValue();
                    arraylist.add(new RenderPass.Draw(0, this.worldBorderBuffer, gpubuffer, this.indices.type(), 6 * j, 6));
                }
                renderpass.drawMultipleIndexed(arraylist, null, null, Collections.emptyList(), this);
            }
        }
    }

    public void invalidate() {
        this.needsRebuild = true;
    }

    private boolean shouldRebuildWorldBorderBuffer(WorldBorder p_401887_) {
        return this.needsRebuild || p_401887_.getMinX() != this.lastBorderMinX || p_401887_.getMinZ() != this.lastBorderMinZ || p_401887_.getMaxX() != this.lastBorderMaxX || p_401887_.getMaxZ() != this.lastBorderMaxZ;
    }
}

