/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WeatherEffectRenderer {
    private static final int RAIN_RADIUS = 10;
    private static final int RAIN_DIAMETER = 21;
    private static final ResourceLocation RAIN_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/rain.png");
    private static final ResourceLocation SNOW_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/snow.png");
    private static final int RAIN_TABLE_SIZE = 32;
    private static final int HALF_RAIN_TABLE_SIZE = 16;
    private int rainSoundTime;
    private final float[] columnSizeX = new float[1024];
    private final float[] columnSizeZ = new float[1024];

    public WeatherEffectRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.length(f, f1);
                this.columnSizeX[i * 32 + j] = -f1 / f2;
                this.columnSizeZ[i * 32 + j] = f / f2;
            }
        }
    }

    public void render(Level p_364994_, MultiBufferSource p_383071_, int p_363664_, float p_361655_, Vec3 p_363375_) {
        if (((ClientLevel)p_364994_).effects().renderSnowAndRain((ClientLevel)p_364994_, p_363664_, p_361655_, p_363375_.x, p_363375_.y, p_363375_.z)) {
            return;
        }
        float f = p_364994_.getRainLevel(p_361655_);
        if (!(f <= 0.0f)) {
            int i = Minecraft.useFancyGraphics() ? 10 : 5;
            ArrayList<ColumnInstance> list = new ArrayList<ColumnInstance>();
            ArrayList<ColumnInstance> list1 = new ArrayList<ColumnInstance>();
            this.collectColumnInstances(p_364994_, p_363664_, p_361655_, p_363375_, i, list, list1);
            if (!list.isEmpty() || !list1.isEmpty()) {
                this.render(p_383071_, p_363375_, i, f, list, list1);
            }
        }
    }

    private void collectColumnInstances(Level p_363309_, int p_364806_, float p_363571_, Vec3 p_361736_, int p_365047_, List<ColumnInstance> p_363743_, List<ColumnInstance> p_363189_) {
        int i = Mth.floor(p_361736_.x);
        int j = Mth.floor(p_361736_.y);
        int k = Mth.floor(p_361736_.z);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        RandomSource randomsource = RandomSource.create();
        for (int l = k - p_365047_; l <= k + p_365047_; ++l) {
            for (int i1 = i - p_365047_; i1 <= i + p_365047_; ++i1) {
                Biome.Precipitation biome$precipitation;
                int j1 = p_363309_.getHeight(Heightmap.Types.MOTION_BLOCKING, i1, l);
                int k1 = Math.max(j - p_365047_, j1);
                int l1 = Math.max(j + p_365047_, j1);
                if (l1 - k1 == 0 || (biome$precipitation = this.getPrecipitationAt(p_363309_, blockpos$mutableblockpos.set(i1, j, l))) == Biome.Precipitation.NONE) continue;
                int i2 = i1 * i1 * 3121 + i1 * 45238971 ^ l * l * 418711 + l * 13761;
                randomsource.setSeed(i2);
                int j2 = Math.max(j, j1);
                int k2 = LevelRenderer.getLightColor(p_363309_, blockpos$mutableblockpos.set(i1, j2, l));
                if (biome$precipitation == Biome.Precipitation.RAIN) {
                    p_363743_.add(this.createRainColumnInstance(randomsource, p_364806_, i1, k1, l1, l, k2, p_363571_));
                    continue;
                }
                if (biome$precipitation != Biome.Precipitation.SNOW) continue;
                p_363189_.add(this.createSnowColumnInstance(randomsource, p_364806_, i1, k1, l1, l, k2, p_363571_));
            }
        }
    }

    private void render(MultiBufferSource p_382792_, Vec3 p_360652_, int p_365362_, float p_362894_, List<ColumnInstance> p_362059_, List<ColumnInstance> p_362633_) {
        if (!p_362059_.isEmpty()) {
            RenderType rendertype = RenderType.weather(RAIN_LOCATION, Minecraft.useShaderTransparency());
            this.renderInstances(p_382792_.getBuffer(rendertype), p_362059_, p_360652_, 1.0f, p_365362_, p_362894_);
        }
        if (!p_362633_.isEmpty()) {
            RenderType rendertype1 = RenderType.weather(SNOW_LOCATION, Minecraft.useShaderTransparency());
            this.renderInstances(p_382792_.getBuffer(rendertype1), p_362633_, p_360652_, 0.8f, p_365362_, p_362894_);
        }
    }

    private ColumnInstance createRainColumnInstance(RandomSource p_364494_, int p_361188_, int p_362466_, int p_364844_, int p_361656_, int p_364160_, int p_361622_, float p_363800_) {
        int i = p_361188_ & 0x1FFFF;
        int j = p_362466_ * p_362466_ * 3121 + p_362466_ * 45238971 + p_364160_ * p_364160_ * 418711 + p_364160_ * 13761 & 0xFF;
        float f = 3.0f + p_364494_.nextFloat();
        float f1 = -((float)(i + j) + p_363800_) / 32.0f * f;
        float f2 = f1 % 32.0f;
        return new ColumnInstance(p_362466_, p_364160_, p_364844_, p_361656_, 0.0f, f2, p_361622_);
    }

    private ColumnInstance createSnowColumnInstance(RandomSource p_364207_, int p_364249_, int p_360966_, int p_361182_, int p_360486_, int p_364645_, int p_361024_, float p_362542_) {
        float f = (float)p_364249_ + p_362542_;
        float f1 = (float)(p_364207_.nextDouble() + (double)(f * 0.01f * (float)p_364207_.nextGaussian()));
        float f2 = (float)(p_364207_.nextDouble() + (double)(f * (float)p_364207_.nextGaussian() * 0.001f));
        float f3 = -((float)(p_364249_ & 0x1FF) + p_362542_) / 512.0f;
        int i = LightTexture.pack((LightTexture.block(p_361024_) * 3 + 15) / 4, (LightTexture.sky(p_361024_) * 3 + 15) / 4);
        return new ColumnInstance(p_360966_, p_364645_, p_361182_, p_360486_, f1, f3 + f2, i);
    }

    private void renderInstances(VertexConsumer p_383100_, List<ColumnInstance> p_364429_, Vec3 p_363972_, float p_364489_, int p_361243_, float p_362812_) {
        for (ColumnInstance weathereffectrenderer$columninstance : p_364429_) {
            float f = (float)((double)weathereffectrenderer$columninstance.x + 0.5 - p_363972_.x);
            float f1 = (float)((double)weathereffectrenderer$columninstance.z + 0.5 - p_363972_.z);
            float f2 = (float)Mth.lengthSquared(f, f1);
            float f3 = Mth.lerp(f2 / (float)(p_361243_ * p_361243_), p_364489_, 0.5f) * p_362812_;
            int i = ARGB.white(f3);
            int j = (weathereffectrenderer$columninstance.z - Mth.floor(p_363972_.z) + 16) * 32 + weathereffectrenderer$columninstance.x - Mth.floor(p_363972_.x) + 16;
            float f4 = this.columnSizeX[j] / 2.0f;
            float f5 = this.columnSizeZ[j] / 2.0f;
            float f6 = f - f4;
            float f7 = f + f4;
            float f8 = (float)((double)weathereffectrenderer$columninstance.topY - p_363972_.y);
            float f9 = (float)((double)weathereffectrenderer$columninstance.bottomY - p_363972_.y);
            float f10 = f1 - f5;
            float f11 = f1 + f5;
            float f12 = weathereffectrenderer$columninstance.uOffset + 0.0f;
            float f13 = weathereffectrenderer$columninstance.uOffset + 1.0f;
            float f14 = (float)weathereffectrenderer$columninstance.bottomY * 0.25f + weathereffectrenderer$columninstance.vOffset;
            float f15 = (float)weathereffectrenderer$columninstance.topY * 0.25f + weathereffectrenderer$columninstance.vOffset;
            p_383100_.addVertex(f6, f8, f10).setUv(f12, f14).setColor(i).setLight(weathereffectrenderer$columninstance.lightCoords);
            p_383100_.addVertex(f7, f8, f11).setUv(f13, f14).setColor(i).setLight(weathereffectrenderer$columninstance.lightCoords);
            p_383100_.addVertex(f7, f9, f11).setUv(f13, f15).setColor(i).setLight(weathereffectrenderer$columninstance.lightCoords);
            p_383100_.addVertex(f6, f9, f10).setUv(f12, f15).setColor(i).setLight(weathereffectrenderer$columninstance.lightCoords);
        }
    }

    public void tickRainParticles(ClientLevel p_361823_, Camera p_364990_, int p_361788_, ParticleStatus p_363302_) {
        if (p_361823_.effects().tickRain(p_361823_, p_361788_, p_364990_)) {
            return;
        }
        float f = p_361823_.getRainLevel(1.0f) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
        if (!(f <= 0.0f)) {
            RandomSource randomsource = RandomSource.create((long)p_361788_ * 312987231L);
            BlockPos blockpos = BlockPos.containing(p_364990_.getPosition());
            Vec3i blockpos1 = null;
            int i = (int)(100.0f * f * f) / (p_363302_ == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int l;
                int k = randomsource.nextInt(21) - 10;
                BlockPos blockpos2 = p_361823_.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos.offset(k, 0, l = randomsource.nextInt(21) - 10));
                if (blockpos2.getY() <= p_361823_.getMinY() || blockpos2.getY() > blockpos.getY() + 10 || blockpos2.getY() < blockpos.getY() - 10 || this.getPrecipitationAt(p_361823_, blockpos2) != Biome.Precipitation.RAIN) continue;
                blockpos1 = blockpos2.below();
                if (p_363302_ == ParticleStatus.MINIMAL) break;
                double d0 = randomsource.nextDouble();
                double d1 = randomsource.nextDouble();
                BlockState blockstate = p_361823_.getBlockState((BlockPos)blockpos1);
                FluidState fluidstate = p_361823_.getFluidState((BlockPos)blockpos1);
                VoxelShape voxelshape = blockstate.getCollisionShape(p_361823_, (BlockPos)blockpos1);
                double d2 = voxelshape.max(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.getHeight(p_361823_, (BlockPos)blockpos1);
                double d4 = Math.max(d2, d3);
                SimpleParticleType particleoptions = !fluidstate.is(FluidTags.LAVA) && !blockstate.is(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLitCampfire(blockstate) ? ParticleTypes.RAIN : ParticleTypes.SMOKE;
                p_361823_.addParticle(particleoptions, (double)blockpos1.getX() + d0, (double)blockpos1.getY() + d4, (double)blockpos1.getZ() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && randomsource.nextInt(3) < this.rainSoundTime++) {
                this.rainSoundTime = 0;
                if (blockpos1.getY() > blockpos.getY() + 1 && p_361823_.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() > Mth.floor(blockpos.getY())) {
                    p_361823_.playLocalSound((BlockPos)blockpos1, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, 0.1f, 0.5f, false);
                } else {
                    p_361823_.playLocalSound((BlockPos)blockpos1, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    private Biome.Precipitation getPrecipitationAt(Level p_362885_, BlockPos p_362817_) {
        if (!p_362885_.getChunkSource().hasChunk(SectionPos.blockToSectionCoord(p_362817_.getX()), SectionPos.blockToSectionCoord(p_362817_.getZ()))) {
            return Biome.Precipitation.NONE;
        }
        Biome biome = (Biome)p_362885_.getBiome(p_362817_).value();
        return biome.getPrecipitationAt(p_362817_, p_362885_.getSeaLevel());
    }

    @OnlyIn(value=Dist.CLIENT)
    record ColumnInstance(int x, int z, int bottomY, int topY, float uOffset, float vOffset, int lightCoords) {
    }
}

