/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@OnlyIn(value=Dist.CLIENT)
public interface UniformValue {
    public static final Codec<UniformValue> CODEC = Type.CODEC.dispatch(UniformValue::type, p_418396_ -> p_418396_.valueCodec);

    public void writeTo(Std140Builder var1);

    public void addSize(Std140SizeCalculator var1);

    public Type type();

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type implements StringRepresentable
    {
        INT("int", IntUniform.CODEC),
        IVEC3("ivec3", IVec3Uniform.CODEC),
        FLOAT("float", FloatUniform.CODEC),
        VEC2("vec2", Vec2Uniform.CODEC),
        VEC3("vec3", Vec3Uniform.CODEC),
        VEC4("vec4", Vec4Uniform.CODEC),
        MATRIX4X4("matrix4x4", Matrix4x4Uniform.CODEC);

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private final String name;
        final MapCodec<? extends UniformValue> valueCodec;

        private Type(String p_418405_, Codec<? extends UniformValue> p_418274_) {
            this.name = p_418405_;
            this.valueCodec = p_418274_.fieldOf("value");
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Vec4Uniform(Vector4f value) implements UniformValue
    {
        public static final Codec<Vec4Uniform> CODEC = ExtraCodecs.VECTOR4F.xmap(Vec4Uniform::new, Vec4Uniform::value);

        @Override
        public void writeTo(Std140Builder p_418009_) {
            p_418009_.putVec4((Vector4fc)this.value);
        }

        @Override
        public void addSize(Std140SizeCalculator p_418414_) {
            p_418414_.putVec4();
        }

        @Override
        public Type type() {
            return Type.VEC4;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Vec3Uniform(Vector3f value) implements UniformValue
    {
        public static final Codec<Vec3Uniform> CODEC = ExtraCodecs.VECTOR3F.xmap(Vec3Uniform::new, Vec3Uniform::value);

        @Override
        public void writeTo(Std140Builder p_418183_) {
            p_418183_.putVec3((Vector3fc)this.value);
        }

        @Override
        public void addSize(Std140SizeCalculator p_418181_) {
            p_418181_.putVec3();
        }

        @Override
        public Type type() {
            return Type.VEC3;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Vec2Uniform(Vector2f value) implements UniformValue
    {
        public static final Codec<Vec2Uniform> CODEC = ExtraCodecs.VECTOR2F.xmap(Vec2Uniform::new, Vec2Uniform::value);

        @Override
        public void writeTo(Std140Builder p_418356_) {
            p_418356_.putVec2((Vector2fc)this.value);
        }

        @Override
        public void addSize(Std140SizeCalculator p_418037_) {
            p_418037_.putVec2();
        }

        @Override
        public Type type() {
            return Type.VEC2;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Matrix4x4Uniform(Matrix4fc value) implements UniformValue
    {
        public static final Codec<Matrix4x4Uniform> CODEC = ExtraCodecs.MATRIX4F.xmap(Matrix4x4Uniform::new, Matrix4x4Uniform::value);

        @Override
        public void writeTo(Std140Builder p_418041_) {
            p_418041_.putMat4f(this.value);
        }

        @Override
        public void addSize(Std140SizeCalculator p_418487_) {
            p_418487_.putMat4f();
        }

        @Override
        public Type type() {
            return Type.MATRIX4X4;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record IntUniform(int value) implements UniformValue
    {
        public static final Codec<IntUniform> CODEC = Codec.INT.xmap(IntUniform::new, IntUniform::value);

        @Override
        public void writeTo(Std140Builder p_418460_) {
            p_418460_.putInt(this.value);
        }

        @Override
        public void addSize(Std140SizeCalculator p_418327_) {
            p_418327_.putInt();
        }

        @Override
        public Type type() {
            return Type.INT;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record IVec3Uniform(Vector3i value) implements UniformValue
    {
        public static final Codec<IVec3Uniform> CODEC = ExtraCodecs.VECTOR3I.xmap(IVec3Uniform::new, IVec3Uniform::value);

        @Override
        public void writeTo(Std140Builder p_418141_) {
            p_418141_.putIVec3((Vector3ic)this.value);
        }

        @Override
        public void addSize(Std140SizeCalculator p_418431_) {
            p_418431_.putIVec3();
        }

        @Override
        public Type type() {
            return Type.IVEC3;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record FloatUniform(float value) implements UniformValue
    {
        public static final Codec<FloatUniform> CODEC = Codec.FLOAT.xmap(FloatUniform::new, FloatUniform::value);

        @Override
        public void writeTo(Std140Builder p_418143_) {
            p_418143_.putFloat(this.value);
        }

        @Override
        public void addSize(Std140SizeCalculator p_418390_) {
            p_418390_.putFloat();
        }

        @Override
        public Type type() {
            return Type.FLOAT;
        }
    }
}

