/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@OnlyIn(value=Dist.CLIENT)
public class SkyRenderer
implements AutoCloseable {
    private static final ResourceLocation SUN_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/sun.png");
    private static final ResourceLocation MOON_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/moon_phases.png");
    public static final ResourceLocation END_SKY_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/end_sky.png");
    private static final float SKY_DISC_RADIUS = 512.0f;
    private static final int SKY_VERTICES = 10;
    private static final int STAR_COUNT = 1500;
    private static final int END_SKY_QUAD_COUNT = 6;
    private final GpuBuffer starBuffer;
    private final RenderSystem.AutoStorageIndexBuffer starIndices = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
    private final GpuBuffer topSkyBuffer;
    private final GpuBuffer bottomSkyBuffer;
    private final GpuBuffer endSkyBuffer;
    private int starIndexCount;

    public SkyRenderer() {
        this.starBuffer = this.buildStars();
        this.endSkyBuffer = SkyRenderer.buildEndSky();
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized(10 * DefaultVertexFormat.POSITION.getVertexSize());){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
            this.buildSkyDisc(bufferbuilder, 16.0f);
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                this.topSkyBuffer = RenderSystem.getDevice().createBuffer(() -> "Top sky vertex buffer", 32, meshdata.vertexBuffer());
            }
            bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
            this.buildSkyDisc(bufferbuilder, -16.0f);
            try (MeshData meshdata1 = bufferbuilder.buildOrThrow();){
                this.bottomSkyBuffer = RenderSystem.getDevice().createBuffer(() -> "Bottom sky vertex buffer", 32, meshdata1.vertexBuffer());
            }
        }
    }

    private GpuBuffer buildStars() {
        GpuBuffer gpubuffer;
        RandomSource randomsource = RandomSource.create(10842L);
        float f = 100.0f;
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized(DefaultVertexFormat.POSITION.getVertexSize() * 1500 * 4);){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            for (int i = 0; i < 1500; ++i) {
                float f1 = randomsource.nextFloat() * 2.0f - 1.0f;
                float f2 = randomsource.nextFloat() * 2.0f - 1.0f;
                float f3 = randomsource.nextFloat() * 2.0f - 1.0f;
                float f4 = 0.15f + randomsource.nextFloat() * 0.1f;
                float f5 = Mth.lengthSquared(f1, f2, f3);
                if (f5 <= 0.010000001f || f5 >= 1.0f) continue;
                Vector3f vector3f = new Vector3f(f1, f2, f3).normalize(100.0f);
                float f6 = (float)(randomsource.nextDouble() * 3.1415927410125732 * 2.0);
                Matrix3f matrix3f = new Matrix3f().rotateTowards((Vector3fc)new Vector3f((Vector3fc)vector3f).negate(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotateZ(-f6);
                bufferbuilder.addVertex(new Vector3f(f4, -f4, 0.0f).mul((Matrix3fc)matrix3f).add((Vector3fc)vector3f));
                bufferbuilder.addVertex(new Vector3f(f4, f4, 0.0f).mul((Matrix3fc)matrix3f).add((Vector3fc)vector3f));
                bufferbuilder.addVertex(new Vector3f(-f4, f4, 0.0f).mul((Matrix3fc)matrix3f).add((Vector3fc)vector3f));
                bufferbuilder.addVertex(new Vector3f(-f4, -f4, 0.0f).mul((Matrix3fc)matrix3f).add((Vector3fc)vector3f));
            }
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                this.starIndexCount = meshdata.drawState().indexCount();
                gpubuffer = RenderSystem.getDevice().createBuffer(() -> "Stars vertex buffer", 40, meshdata.vertexBuffer());
            }
        }
        return gpubuffer;
    }

    private void buildSkyDisc(VertexConsumer p_382865_, float p_361373_) {
        float f = Math.signum(p_361373_) * 512.0f;
        p_382865_.addVertex(0.0f, p_361373_, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            p_382865_.addVertex(f * Mth.cos((float)i * ((float)Math.PI / 180)), p_361373_, 512.0f * Mth.sin((float)i * ((float)Math.PI / 180)));
        }
    }

    public void renderSkyDisc(float p_362027_, float p_360898_, float p_362939_) {
        GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(p_362027_, p_360898_, p_362939_, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
        GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Sky disc", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
            renderpass.setPipeline(RenderPipelines.SKY);
            RenderSystem.bindDefaultUniforms(renderpass);
            renderpass.setUniform("DynamicTransforms", gpubufferslice);
            renderpass.setVertexBuffer(0, this.topSkyBuffer);
            renderpass.draw(0, 10);
        }
    }

    public void renderDarkDisc() {
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate(0.0f, 12.0f, 0.0f);
        GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)matrix4fstack, (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
        GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Sky dark", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
            renderpass.setPipeline(RenderPipelines.SKY);
            RenderSystem.bindDefaultUniforms(renderpass);
            renderpass.setUniform("DynamicTransforms", gpubufferslice);
            renderpass.setVertexBuffer(0, this.bottomSkyBuffer);
            renderpass.draw(0, 10);
        }
        matrix4fstack.popMatrix();
    }

    public void renderSunMoonAndStars(PoseStack p_363513_, MultiBufferSource.BufferSource p_382843_, float p_362201_, int p_362572_, float p_362569_, float p_363542_) {
        p_363513_.pushPose();
        p_363513_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        p_363513_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(p_362201_ * 360.0f));
        this.renderSun(p_362569_, p_382843_, p_363513_);
        this.renderMoon(p_362572_, p_362569_, p_382843_, p_363513_);
        p_382843_.endBatch();
        if (p_363542_ > 0.0f) {
            this.renderStars(p_363542_, p_363513_);
        }
        p_363513_.popPose();
    }

    private void renderSun(float p_362331_, MultiBufferSource p_383061_, PoseStack p_361665_) {
        float f = 30.0f;
        float f1 = 100.0f;
        VertexConsumer vertexconsumer = p_383061_.getBuffer(RenderType.celestial(SUN_LOCATION));
        int i = ARGB.white(p_362331_);
        Matrix4f matrix4f = p_361665_.last().pose();
        vertexconsumer.addVertex(matrix4f, -30.0f, 100.0f, -30.0f).setUv(0.0f, 0.0f).setColor(i);
        vertexconsumer.addVertex(matrix4f, 30.0f, 100.0f, -30.0f).setUv(1.0f, 0.0f).setColor(i);
        vertexconsumer.addVertex(matrix4f, 30.0f, 100.0f, 30.0f).setUv(1.0f, 1.0f).setColor(i);
        vertexconsumer.addVertex(matrix4f, -30.0f, 100.0f, 30.0f).setUv(0.0f, 1.0f).setColor(i);
    }

    private void renderMoon(int p_364754_, float p_362497_, MultiBufferSource p_382845_, PoseStack p_362676_) {
        float f = 20.0f;
        int i = p_364754_ % 4;
        int j = p_364754_ / 4 % 2;
        float f1 = (float)(i + 0) / 4.0f;
        float f2 = (float)(j + 0) / 2.0f;
        float f3 = (float)(i + 1) / 4.0f;
        float f4 = (float)(j + 1) / 2.0f;
        float f5 = 100.0f;
        VertexConsumer vertexconsumer = p_382845_.getBuffer(RenderType.celestial(MOON_LOCATION));
        int k = ARGB.white(p_362497_);
        Matrix4f matrix4f = p_362676_.last().pose();
        vertexconsumer.addVertex(matrix4f, -20.0f, -100.0f, 20.0f).setUv(f3, f4).setColor(k);
        vertexconsumer.addVertex(matrix4f, 20.0f, -100.0f, 20.0f).setUv(f1, f4).setColor(k);
        vertexconsumer.addVertex(matrix4f, 20.0f, -100.0f, -20.0f).setUv(f1, f2).setColor(k);
        vertexconsumer.addVertex(matrix4f, -20.0f, -100.0f, -20.0f).setUv(f3, f2).setColor(k);
    }

    private void renderStars(float p_361150_, PoseStack p_365236_) {
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.mul((Matrix4fc)p_365236_.last().pose());
        RenderPipeline renderpipeline = RenderPipelines.STARS;
        GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
        GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
        GpuBuffer gpubuffer = this.starIndices.getBuffer(this.starIndexCount);
        GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)matrix4fstack, (Vector4fc)new Vector4f(p_361150_, p_361150_, p_361150_, p_361150_), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Stars", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
            renderpass.setPipeline(renderpipeline);
            RenderSystem.bindDefaultUniforms(renderpass);
            renderpass.setUniform("DynamicTransforms", gpubufferslice);
            renderpass.setVertexBuffer(0, this.starBuffer);
            renderpass.setIndexBuffer(gpubuffer, this.starIndices.type());
            renderpass.drawIndexed(0, 0, this.starIndexCount, 1);
        }
        matrix4fstack.popMatrix();
    }

    public void renderSunriseAndSunset(PoseStack p_362809_, MultiBufferSource.BufferSource p_383216_, float p_364108_, int p_361766_) {
        p_362809_.pushPose();
        p_362809_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        float f = Mth.sin(p_364108_) < 0.0f ? 180.0f : 0.0f;
        p_362809_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f));
        p_362809_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
        Matrix4f matrix4f = p_362809_.last().pose();
        VertexConsumer vertexconsumer = p_383216_.getBuffer(RenderType.sunriseSunset());
        float f1 = ARGB.alphaFloat(p_361766_);
        vertexconsumer.addVertex(matrix4f, 0.0f, 100.0f, 0.0f).setColor(p_361766_);
        int i = ARGB.transparent(p_361766_);
        int j = 16;
        for (int k = 0; k <= 16; ++k) {
            float f2 = (float)k * ((float)Math.PI * 2) / 16.0f;
            float f3 = Mth.sin(f2);
            float f4 = Mth.cos(f2);
            vertexconsumer.addVertex(matrix4f, f3 * 120.0f, f4 * 120.0f, -f4 * 40.0f * f1).setColor(i);
        }
        p_362809_.popPose();
    }

    private static GpuBuffer buildEndSky() {
        GpuBuffer gpubuffer;
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized(24 * DefaultVertexFormat.POSITION_TEX_COLOR.getVertexSize());){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            for (int i = 0; i < 6; ++i) {
                Matrix4f matrix4f = new Matrix4f();
                switch (i) {
                    case 1: {
                        matrix4f.rotationX(1.5707964f);
                        break;
                    }
                    case 2: {
                        matrix4f.rotationX(-1.5707964f);
                        break;
                    }
                    case 3: {
                        matrix4f.rotationX((float)Math.PI);
                        break;
                    }
                    case 4: {
                        matrix4f.rotationZ(1.5707964f);
                        break;
                    }
                    case 5: {
                        matrix4f.rotationZ(-1.5707964f);
                    }
                }
                bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(-14145496);
                bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(-14145496);
                bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(-14145496);
                bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(-14145496);
            }
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                gpubuffer = RenderSystem.getDevice().createBuffer(() -> "End sky vertex buffer", 40, meshdata.vertexBuffer());
            }
        }
        return gpubuffer;
    }

    public void renderEndSky() {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstracttexture = texturemanager.getTexture(END_SKY_LOCATION);
        abstracttexture.setUseMipmaps(false);
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
        GpuBuffer gpubuffer = rendersystem$autostorageindexbuffer.getBuffer(36);
        GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
        GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
        GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "End sky", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
            renderpass.setPipeline(RenderPipelines.END_SKY);
            RenderSystem.bindDefaultUniforms(renderpass);
            renderpass.setUniform("DynamicTransforms", gpubufferslice);
            renderpass.bindSampler("Sampler0", abstracttexture.getTextureView());
            renderpass.setVertexBuffer(0, this.endSkyBuffer);
            renderpass.setIndexBuffer(gpubuffer, rendersystem$autostorageindexbuffer.type());
            renderpass.drawIndexed(0, 0, 36, 1);
        }
    }

    @Override
    public void close() {
        this.starBuffer.close();
        this.topSkyBuffer.close();
        this.bottomSkyBuffer.close();
        this.endSkyBuffer.close();
    }
}

