/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.CompiledRenderPipeline;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostChainConfig;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ShaderManager
extends SimplePreparableReloadListener<Configs>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_LOG_LENGTH = 32768;
    public static final String SHADER_PATH = "shaders";
    private static final String SHADER_INCLUDE_PATH = "shaders/include/";
    private static final FileToIdConverter POST_CHAIN_ID_CONVERTER = FileToIdConverter.json("post_effect");
    final TextureManager textureManager;
    private final Consumer<Exception> recoveryHandler;
    private CompilationCache compilationCache = new CompilationCache(Configs.EMPTY);
    final CachedOrthoProjectionMatrixBuffer postChainProjectionMatrixBuffer = new CachedOrthoProjectionMatrixBuffer("post", 0.1f, 1000.0f, false);

    public ShaderManager(TextureManager p_366478_, Consumer<Exception> p_368560_) {
        this.textureManager = p_366478_;
        this.recoveryHandler = p_368560_;
    }

    @Override
    protected Configs prepare(ResourceManager p_366761_, ProfilerFiller p_366562_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<ResourceLocation, Resource> map = p_366761_.listResources(SHADER_PATH, ShaderManager::isShader);
        for (Map.Entry<ResourceLocation, Resource> entry : map.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            ShaderType shadertype = ShaderType.byLocation(resourcelocation);
            if (shadertype == null) continue;
            ShaderManager.loadShader(resourcelocation, entry.getValue(), shadertype, map, (ImmutableMap.Builder<ShaderSourceKey, String>)builder);
        }
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, Resource> entry1 : POST_CHAIN_ID_CONVERTER.listMatchingResources(p_366761_).entrySet()) {
            ShaderManager.loadPostChain(entry1.getKey(), entry1.getValue(), (ImmutableMap.Builder<ResourceLocation, PostChainConfig>)builder1);
        }
        return new Configs((Map<ShaderSourceKey, String>)builder.build(), (Map<ResourceLocation, PostChainConfig>)builder1.build());
    }

    private static void loadShader(ResourceLocation p_366513_, Resource p_366763_, ShaderType p_410200_, Map<ResourceLocation, Resource> p_366725_, ImmutableMap.Builder<ShaderSourceKey, String> p_366733_) {
        ResourceLocation resourcelocation = p_410200_.idConverter().fileToId(p_366513_);
        GlslPreprocessor glslpreprocessor = ShaderManager.createPreprocessor(p_366725_, p_366513_);
        try (BufferedReader reader = p_366763_.openAsReader();){
            String s = IOUtils.toString((Reader)reader);
            p_366733_.put((Object)new ShaderSourceKey(resourcelocation, p_410200_), (Object)String.join((CharSequence)"", glslpreprocessor.process(s)));
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to load shader source at {}", (Object)p_366513_, (Object)ioexception);
        }
    }

    private static GlslPreprocessor createPreprocessor(final Map<ResourceLocation, Resource> p_366891_, ResourceLocation p_366860_) {
        final ResourceLocation resourcelocation = p_366860_.withPath(FileUtil::getFullResourcePath);
        return new GlslPreprocessor(){
            private final Set<ResourceLocation> importedLocations = new ObjectArraySet();

            @Override
            public String applyImport(boolean p_366551_, String p_366739_) {
                ResourceLocation resourcelocation1;
                try {
                    resourcelocation1 = p_366551_ ? resourcelocation.withPath(p_366623_ -> FileUtil.normalizeResourcePath(p_366623_ + p_366739_)) : ResourceLocation.parse(p_366739_).withPrefix(ShaderManager.SHADER_INCLUDE_PATH);
                }
                catch (ResourceLocationException resourcelocationexception) {
                    LOGGER.error("Malformed GLSL import {}: {}", (Object)p_366739_, (Object)resourcelocationexception.getMessage());
                    return "#error " + resourcelocationexception.getMessage();
                }
                if (!this.importedLocations.add(resourcelocation1)) {
                    return null;
                }
                try {
                    String s;
                    try (BufferedReader reader = ((Resource)p_366891_.get(resourcelocation1)).openAsReader();){
                        s = IOUtils.toString((Reader)reader);
                    }
                    return s;
                }
                catch (IOException ioexception) {
                    LOGGER.error("Could not open GLSL import {}: {}", (Object)resourcelocation1, (Object)ioexception.getMessage());
                    return "#error " + ioexception.getMessage();
                }
            }
        };
    }

    private static void loadPostChain(ResourceLocation p_366838_, Resource p_366558_, ImmutableMap.Builder<ResourceLocation, PostChainConfig> p_366892_) {
        ResourceLocation resourcelocation = POST_CHAIN_ID_CONVERTER.fileToId(p_366838_);
        try (BufferedReader reader = p_366558_.openAsReader();){
            JsonElement jsonelement = StrictJsonParser.parse(reader);
            p_366892_.put((Object)resourcelocation, (Object)((PostChainConfig)PostChainConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonSyntaxException::new)));
        }
        catch (JsonParseException | IOException ioexception) {
            LOGGER.error("Failed to parse post chain at {}", (Object)p_366838_, (Object)ioexception);
        }
    }

    private static boolean isShader(ResourceLocation p_366565_) {
        return ShaderType.byLocation(p_366565_) != null || p_366565_.getPath().endsWith(".glsl");
    }

    @Override
    protected void apply(Configs p_366597_, ResourceManager p_366533_, ProfilerFiller p_366866_) {
        CompilationCache shadermanager$compilationcache = new CompilationCache(p_366597_);
        HashSet<RenderPipeline> set = new HashSet<RenderPipeline>(RenderPipelines.getStaticPipelines());
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        GpuDevice gpudevice = RenderSystem.getDevice();
        gpudevice.clearPipelineCache();
        for (RenderPipeline renderpipeline : set) {
            CompiledRenderPipeline compiledrenderpipeline = gpudevice.precompilePipeline(renderpipeline, shadermanager$compilationcache::getShaderSource);
            if (compiledrenderpipeline.isValid()) continue;
            list.add(renderpipeline.getLocation());
        }
        if (!list.isEmpty()) {
            gpudevice.clearPipelineCache();
            throw new RuntimeException("Failed to load required shader programs:\n" + list.stream().map(p_409066_ -> " - " + String.valueOf(p_409066_)).collect(Collectors.joining("\n")));
        }
        this.compilationCache.close();
        this.compilationCache = shadermanager$compilationcache;
    }

    @Override
    public String getName() {
        return "Shader Loader";
    }

    private void tryTriggerRecovery(Exception p_383219_) {
        if (!this.compilationCache.triggeredRecovery) {
            this.recoveryHandler.accept(p_383219_);
            this.compilationCache.triggeredRecovery = true;
        }
    }

    @Nullable
    public PostChain getPostChain(ResourceLocation p_366709_, Set<ResourceLocation> p_366652_) {
        try {
            return this.compilationCache.getOrLoadPostChain(p_366709_, p_366652_);
        }
        catch (CompilationException shadermanager$compilationexception) {
            LOGGER.error("Failed to load post chain: {}", (Object)p_366709_, (Object)shadermanager$compilationexception);
            this.compilationCache.postChains.put(p_366709_, Optional.empty());
            this.tryTriggerRecovery(shadermanager$compilationexception);
            return null;
        }
    }

    @Override
    public void close() {
        this.compilationCache.close();
        this.postChainProjectionMatrixBuffer.close();
    }

    public String getShader(ResourceLocation p_410854_, ShaderType p_410496_) {
        return this.compilationCache.getShaderSource(p_410854_, p_410496_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class CompilationCache
    implements AutoCloseable {
        private final Configs configs;
        final Map<ResourceLocation, Optional<PostChain>> postChains = new HashMap<ResourceLocation, Optional<PostChain>>();
        boolean triggeredRecovery;

        CompilationCache(Configs p_368510_) {
            this.configs = p_368510_;
        }

        @Nullable
        public PostChain getOrLoadPostChain(ResourceLocation p_368720_, Set<ResourceLocation> p_368722_) throws CompilationException {
            Optional<PostChain> optional = this.postChains.get(p_368720_);
            if (optional != null) {
                return optional.orElse(null);
            }
            PostChain postchain = this.loadPostChain(p_368720_, p_368722_);
            this.postChains.put(p_368720_, Optional.of(postchain));
            return postchain;
        }

        private PostChain loadPostChain(ResourceLocation p_368578_, Set<ResourceLocation> p_368581_) throws CompilationException {
            PostChainConfig postchainconfig = this.configs.postChains.get(p_368578_);
            if (postchainconfig == null) {
                throw new CompilationException("Could not find post chain with id: " + String.valueOf(p_368578_));
            }
            return PostChain.load(postchainconfig, ShaderManager.this.textureManager, p_368581_, p_368578_, ShaderManager.this.postChainProjectionMatrixBuffer);
        }

        @Override
        public void close() {
            this.postChains.values().forEach(p_418047_ -> p_418047_.ifPresent(PostChain::close));
            this.postChains.clear();
        }

        public String getShaderSource(ResourceLocation p_409941_, ShaderType p_410764_) {
            return this.configs.shaderSources.get(new ShaderSourceKey(p_409941_, p_410764_));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Configs(Map<ShaderSourceKey, String> shaderSources, Map<ResourceLocation, PostChainConfig> postChains) {
        public static final Configs EMPTY = new Configs(Map.of(), Map.of());
    }

    @OnlyIn(value=Dist.CLIENT)
    record ShaderSourceKey(ResourceLocation id, ShaderType type) {
        @Override
        public String toString() {
            return String.valueOf(this.id) + " (" + String.valueOf((Object)this.type) + ")";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompilationException
    extends Exception {
        public CompilationException(String p_366771_) {
            super(p_366771_);
        }
    }
}

