/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.Octree;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.CompiledSectionMesh;
import net.minecraft.client.renderer.chunk.SectionMesh;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SectionOcclusionGraph {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final int MINIMUM_ADVANCED_CULLING_DISTANCE = 60;
    private static final int MINIMUM_ADVANCED_CULLING_SECTION_DISTANCE = SectionPos.blockToSectionCoord(60);
    private static final double CEILED_SECTION_DIAGONAL = Math.ceil(Math.sqrt(3.0) * 16.0);
    private boolean needsFullUpdate = true;
    @Nullable
    private Future<?> fullUpdateTask;
    @Nullable
    private ViewArea viewArea;
    private final AtomicReference<GraphState> currentGraph = new AtomicReference();
    private final AtomicReference<GraphEvents> nextGraphEvents = new AtomicReference();
    private final AtomicBoolean needsFrustumUpdate = new AtomicBoolean(false);

    public void waitAndReset(@Nullable ViewArea p_294431_) {
        if (this.fullUpdateTask != null) {
            try {
                this.fullUpdateTask.get();
                this.fullUpdateTask = null;
            }
            catch (Exception exception) {
                LOGGER.warn("Full update failed", (Throwable)exception);
            }
        }
        this.viewArea = p_294431_;
        if (p_294431_ != null) {
            this.currentGraph.set(new GraphState(p_294431_));
            this.invalidate();
        } else {
            this.currentGraph.set(null);
        }
    }

    public void invalidate() {
        this.needsFullUpdate = true;
    }

    public void addSectionsInFrustum(Frustum p_294180_, List<SectionRenderDispatcher.RenderSection> p_296160_, List<SectionRenderDispatcher.RenderSection> p_371751_) {
        this.currentGraph.get().storage().sectionTree.visitNodes((p_370300_, p_370301_, p_370302_, p_370303_) -> {
            SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection = p_370300_.getSection();
            if (sectionrenderdispatcher$rendersection != null) {
                p_296160_.add(sectionrenderdispatcher$rendersection);
                if (p_370303_) {
                    p_371751_.add(sectionrenderdispatcher$rendersection);
                }
            }
        }, p_294180_, 32);
    }

    public boolean consumeFrustumUpdate() {
        return this.needsFrustumUpdate.compareAndSet(true, false);
    }

    public void onChunkReadyToRender(ChunkPos p_294122_) {
        GraphEvents sectionocclusiongraph$graphevents1;
        GraphEvents sectionocclusiongraph$graphevents = this.nextGraphEvents.get();
        if (sectionocclusiongraph$graphevents != null) {
            this.addNeighbors(sectionocclusiongraph$graphevents, p_294122_);
        }
        if ((sectionocclusiongraph$graphevents1 = this.currentGraph.get().events) != sectionocclusiongraph$graphevents) {
            this.addNeighbors(sectionocclusiongraph$graphevents1, p_294122_);
        }
    }

    public void schedulePropagationFrom(SectionRenderDispatcher.RenderSection p_295414_) {
        GraphEvents sectionocclusiongraph$graphevents1;
        GraphEvents sectionocclusiongraph$graphevents = this.nextGraphEvents.get();
        if (sectionocclusiongraph$graphevents != null) {
            sectionocclusiongraph$graphevents.sectionsToPropagateFrom.add(p_295414_);
        }
        if ((sectionocclusiongraph$graphevents1 = this.currentGraph.get().events) != sectionocclusiongraph$graphevents) {
            sectionocclusiongraph$graphevents1.sectionsToPropagateFrom.add(p_295414_);
        }
    }

    public void update(boolean p_294298_, Camera p_294529_, Frustum p_294426_, List<SectionRenderDispatcher.RenderSection> p_295280_, LongOpenHashSet p_366410_) {
        Vec3 vec3 = p_294529_.getPosition();
        if (this.needsFullUpdate && (this.fullUpdateTask == null || this.fullUpdateTask.isDone())) {
            this.scheduleFullUpdate(p_294298_, p_294529_, vec3, p_366410_);
        }
        this.runPartialUpdate(p_294298_, p_294426_, p_295280_, vec3, p_366410_);
    }

    private void scheduleFullUpdate(boolean p_294514_, Camera p_295663_, Vec3 p_295096_, LongOpenHashSet p_366772_) {
        this.needsFullUpdate = false;
        LongOpenHashSet longopenhashset = p_366772_.clone();
        this.fullUpdateTask = CompletableFuture.runAsync(() -> {
            GraphState sectionocclusiongraph$graphstate = new GraphState(this.viewArea);
            this.nextGraphEvents.set(sectionocclusiongraph$graphstate.events);
            ArrayDeque queue = Queues.newArrayDeque();
            this.initializeQueueForFullUpdate(p_295663_, queue);
            queue.forEach(p_295724_ -> sectionocclusiongraph$graphstate.storage.sectionToNodeMap.put(p_295724_.section, (Node)p_295724_));
            this.runUpdates(sectionocclusiongraph$graphstate.storage, p_295096_, queue, p_294514_, p_294678_ -> {}, longopenhashset);
            this.currentGraph.set(sectionocclusiongraph$graphstate);
            this.nextGraphEvents.set(null);
            this.needsFrustumUpdate.set(true);
        }, Util.backgroundExecutor());
    }

    private void runPartialUpdate(boolean p_294795_, Frustum p_294341_, List<SectionRenderDispatcher.RenderSection> p_294796_, Vec3 p_295915_, LongOpenHashSet p_366753_) {
        GraphState sectionocclusiongraph$graphstate = this.currentGraph.get();
        this.queueSectionsWithNewNeighbors(sectionocclusiongraph$graphstate);
        if (!sectionocclusiongraph$graphstate.events.sectionsToPropagateFrom.isEmpty()) {
            ArrayDeque queue = Queues.newArrayDeque();
            while (!sectionocclusiongraph$graphstate.events.sectionsToPropagateFrom.isEmpty()) {
                SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection = (SectionRenderDispatcher.RenderSection)sectionocclusiongraph$graphstate.events.sectionsToPropagateFrom.poll();
                Node sectionocclusiongraph$node = sectionocclusiongraph$graphstate.storage.sectionToNodeMap.get(sectionrenderdispatcher$rendersection);
                if (sectionocclusiongraph$node == null || sectionocclusiongraph$node.section != sectionrenderdispatcher$rendersection) continue;
                queue.add(sectionocclusiongraph$node);
            }
            Frustum frustum = LevelRenderer.offsetFrustum(p_294341_);
            Consumer<SectionRenderDispatcher.RenderSection> consumer = p_370305_ -> {
                if (frustum.isVisible(p_370305_.getBoundingBox())) {
                    this.needsFrustumUpdate.set(true);
                }
            };
            this.runUpdates(sectionocclusiongraph$graphstate.storage, p_295915_, queue, p_294795_, consumer, p_366753_);
        }
    }

    private void queueSectionsWithNewNeighbors(GraphState p_296471_) {
        LongIterator longiterator = p_296471_.events.chunksWhichReceivedNeighbors.iterator();
        while (longiterator.hasNext()) {
            long i = longiterator.nextLong();
            List list = (List)p_296471_.storage.chunksWaitingForNeighbors.get(i);
            if (list == null || !((SectionRenderDispatcher.RenderSection)list.get(0)).hasAllNeighbors()) continue;
            p_296471_.events.sectionsToPropagateFrom.addAll(list);
            p_296471_.storage.chunksWaitingForNeighbors.remove(i);
        }
        p_296471_.events.chunksWhichReceivedNeighbors.clear();
    }

    private void addNeighbors(GraphEvents p_295866_, ChunkPos p_295968_) {
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x - 1, p_295968_.z));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x, p_295968_.z - 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x + 1, p_295968_.z));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x, p_295968_.z + 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x - 1, p_295968_.z - 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x - 1, p_295968_.z + 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x + 1, p_295968_.z - 1));
        p_295866_.chunksWhichReceivedNeighbors.add(ChunkPos.asLong(p_295968_.x + 1, p_295968_.z + 1));
    }

    private void initializeQueueForFullUpdate(Camera p_295148_, Queue<Node> p_294801_) {
        BlockPos blockpos = p_295148_.getBlockPosition();
        long i = SectionPos.asLong(blockpos);
        int j = SectionPos.y(i);
        SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection = this.viewArea.getRenderSection(i);
        if (sectionrenderdispatcher$rendersection == null) {
            LevelHeightAccessor levelheightaccessor = this.viewArea.getLevelHeightAccessor();
            boolean flag = j < levelheightaccessor.getMinSectionY();
            int k = flag ? levelheightaccessor.getMinSectionY() : levelheightaccessor.getMaxSectionY();
            int l = this.viewArea.getViewDistance();
            ArrayList list = Lists.newArrayList();
            int i1 = SectionPos.x(i);
            int j1 = SectionPos.z(i);
            for (int k1 = -l; k1 <= l; ++k1) {
                for (int l1 = -l; l1 <= l; ++l1) {
                    SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection1 = this.viewArea.getRenderSection(SectionPos.asLong(k1 + i1, k, l1 + j1));
                    if (sectionrenderdispatcher$rendersection1 == null || !this.isInViewDistance(i, sectionrenderdispatcher$rendersection1.getSectionNode())) continue;
                    Direction direction = flag ? Direction.UP : Direction.DOWN;
                    Node sectionocclusiongraph$node = new Node(sectionrenderdispatcher$rendersection1, direction, 0);
                    sectionocclusiongraph$node.setDirections(sectionocclusiongraph$node.directions, direction);
                    if (k1 > 0) {
                        sectionocclusiongraph$node.setDirections(sectionocclusiongraph$node.directions, Direction.EAST);
                    } else if (k1 < 0) {
                        sectionocclusiongraph$node.setDirections(sectionocclusiongraph$node.directions, Direction.WEST);
                    }
                    if (l1 > 0) {
                        sectionocclusiongraph$node.setDirections(sectionocclusiongraph$node.directions, Direction.SOUTH);
                    } else if (l1 < 0) {
                        sectionocclusiongraph$node.setDirections(sectionocclusiongraph$node.directions, Direction.NORTH);
                    }
                    list.add(sectionocclusiongraph$node);
                }
            }
            list.sort(Comparator.comparingDouble(p_392553_ -> blockpos.distSqr(SectionPos.of(p_392553_.section.getSectionNode()).center())));
            p_294801_.addAll(list);
        } else {
            p_294801_.add(new Node(sectionrenderdispatcher$rendersection, null, 0));
        }
    }

    private void runUpdates(GraphStorage p_295507_, Vec3 p_294343_, Queue<Node> p_295598_, boolean p_295668_, Consumer<SectionRenderDispatcher.RenderSection> p_295393_, LongOpenHashSet p_366468_) {
        SectionPos sectionpos = SectionPos.of(p_294343_);
        long i = sectionpos.asLong();
        BlockPos blockpos = sectionpos.center();
        while (!p_295598_.isEmpty()) {
            long j;
            Node sectionocclusiongraph$node = p_295598_.poll();
            SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection = sectionocclusiongraph$node.section;
            if (!p_366468_.contains(sectionocclusiongraph$node.section.getSectionNode())) {
                if (p_295507_.sectionTree.add(sectionocclusiongraph$node.section)) {
                    p_295393_.accept(sectionocclusiongraph$node.section);
                }
            } else {
                sectionocclusiongraph$node.section.sectionMesh.compareAndSet(CompiledSectionMesh.UNCOMPILED, CompiledSectionMesh.EMPTY);
            }
            boolean flag = Math.abs(SectionPos.x(j = sectionrenderdispatcher$rendersection.getSectionNode()) - sectionpos.x()) > MINIMUM_ADVANCED_CULLING_SECTION_DISTANCE || Math.abs(SectionPos.y(j) - sectionpos.y()) > MINIMUM_ADVANCED_CULLING_SECTION_DISTANCE || Math.abs(SectionPos.z(j) - sectionpos.z()) > MINIMUM_ADVANCED_CULLING_SECTION_DISTANCE;
            for (Direction direction : DIRECTIONS) {
                Node sectionocclusiongraph$node1;
                SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection1 = this.getRelativeFrom(i, sectionrenderdispatcher$rendersection, direction);
                if (sectionrenderdispatcher$rendersection1 == null || p_295668_ && sectionocclusiongraph$node.hasDirection(direction.getOpposite())) continue;
                if (p_295668_ && sectionocclusiongraph$node.hasSourceDirections()) {
                    SectionMesh sectionmesh = sectionrenderdispatcher$rendersection.getSectionMesh();
                    boolean flag1 = false;
                    for (int k = 0; k < DIRECTIONS.length; ++k) {
                        if (!sectionocclusiongraph$node.hasSourceDirection(k) || !sectionmesh.facesCanSeeEachother(DIRECTIONS[k].getOpposite(), direction)) continue;
                        flag1 = true;
                        break;
                    }
                    if (!flag1) continue;
                }
                if (p_295668_ && flag) {
                    boolean flag3;
                    boolean flag2;
                    int l = SectionPos.sectionToBlockCoord(SectionPos.x(j));
                    int i1 = SectionPos.sectionToBlockCoord(SectionPos.y(j));
                    int j1 = SectionPos.sectionToBlockCoord(SectionPos.z(j));
                    boolean bl = direction.getAxis() == Direction.Axis.X ? blockpos.getX() > l : (flag2 = blockpos.getX() < l);
                    boolean bl2 = direction.getAxis() == Direction.Axis.Y ? blockpos.getY() > i1 : (flag3 = blockpos.getY() < i1);
                    boolean flag4 = direction.getAxis() == Direction.Axis.Z ? blockpos.getZ() > j1 : blockpos.getZ() < j1;
                    Vector3d vector3d = new Vector3d((double)(l + (flag2 ? 16 : 0)), (double)(i1 + (flag3 ? 16 : 0)), (double)(j1 + (flag4 ? 16 : 0)));
                    Vector3d vector3d1 = new Vector3d(p_294343_.x, p_294343_.y, p_294343_.z).sub((Vector3dc)vector3d).normalize().mul(CEILED_SECTION_DIAGONAL);
                    boolean flag5 = true;
                    while (vector3d.distanceSquared(p_294343_.x, p_294343_.y, p_294343_.z) > 3600.0) {
                        vector3d.add((Vector3dc)vector3d1);
                        LevelHeightAccessor levelheightaccessor = this.viewArea.getLevelHeightAccessor();
                        if (vector3d.y > (double)levelheightaccessor.getMaxY() || vector3d.y < (double)levelheightaccessor.getMinY()) break;
                        SectionRenderDispatcher.RenderSection sectionrenderdispatcher$rendersection2 = this.viewArea.getRenderSectionAt(BlockPos.containing(vector3d.x, vector3d.y, vector3d.z));
                        if (sectionrenderdispatcher$rendersection2 != null && p_295507_.sectionToNodeMap.get(sectionrenderdispatcher$rendersection2) != null) continue;
                        flag5 = false;
                        break;
                    }
                    if (!flag5) continue;
                }
                if ((sectionocclusiongraph$node1 = p_295507_.sectionToNodeMap.get(sectionrenderdispatcher$rendersection1)) != null) {
                    sectionocclusiongraph$node1.addSourceDirection(direction);
                    continue;
                }
                Node sectionocclusiongraph$node2 = new Node(sectionrenderdispatcher$rendersection1, direction, sectionocclusiongraph$node.step + 1);
                sectionocclusiongraph$node2.setDirections(sectionocclusiongraph$node.directions, direction);
                if (sectionrenderdispatcher$rendersection1.hasAllNeighbors()) {
                    p_295598_.add(sectionocclusiongraph$node2);
                    p_295507_.sectionToNodeMap.put(sectionrenderdispatcher$rendersection1, sectionocclusiongraph$node2);
                    continue;
                }
                if (!this.isInViewDistance(i, sectionrenderdispatcher$rendersection1.getSectionNode())) continue;
                p_295507_.sectionToNodeMap.put(sectionrenderdispatcher$rendersection1, sectionocclusiongraph$node2);
                long k1 = SectionPos.sectionToChunk(sectionrenderdispatcher$rendersection1.getSectionNode());
                ((List)p_295507_.chunksWaitingForNeighbors.computeIfAbsent(k1, p_294377_ -> new ArrayList())).add(sectionrenderdispatcher$rendersection1);
            }
        }
    }

    private boolean isInViewDistance(long p_366544_, long p_366485_) {
        return ChunkTrackingView.isInViewDistance(SectionPos.x(p_366544_), SectionPos.z(p_366544_), this.viewArea.getViewDistance(), SectionPos.x(p_366485_), SectionPos.z(p_366485_));
    }

    @Nullable
    private SectionRenderDispatcher.RenderSection getRelativeFrom(long p_366669_, SectionRenderDispatcher.RenderSection p_295211_, Direction p_294491_) {
        long i = p_295211_.getNeighborSectionNode(p_294491_);
        if (!this.isInViewDistance(p_366669_, i)) {
            return null;
        }
        return Mth.abs(SectionPos.y(p_366669_) - SectionPos.y(i)) > this.viewArea.getViewDistance() ? null : this.viewArea.getRenderSection(i);
    }

    @Nullable
    @VisibleForDebug
    public Node getNode(SectionRenderDispatcher.RenderSection p_296364_) {
        return this.currentGraph.get().storage.sectionToNodeMap.get(p_296364_);
    }

    public Octree getOctree() {
        return this.currentGraph.get().storage.sectionTree;
    }

    @OnlyIn(value=Dist.CLIENT)
    record GraphState(GraphStorage storage, GraphEvents events) {
        GraphState(ViewArea p_366764_) {
            this(new GraphStorage(p_366764_), new GraphEvents());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class GraphStorage {
        public final SectionToNodeMap sectionToNodeMap;
        public final Octree sectionTree;
        public final Long2ObjectMap<List<SectionRenderDispatcher.RenderSection>> chunksWaitingForNeighbors;

        public GraphStorage(ViewArea p_366828_) {
            this.sectionToNodeMap = new SectionToNodeMap(p_366828_.sections.length);
            this.sectionTree = new Octree(p_366828_.getCameraSectionPos(), p_366828_.getViewDistance(), p_366828_.sectionGridSizeY, p_366828_.level.getMinY());
            this.chunksWaitingForNeighbors = new Long2ObjectOpenHashMap();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record GraphEvents(LongSet chunksWhichReceivedNeighbors, BlockingQueue<SectionRenderDispatcher.RenderSection> sectionsToPropagateFrom) {
        GraphEvents() {
            this((LongSet)new LongOpenHashSet(), new LinkedBlockingQueue<SectionRenderDispatcher.RenderSection>());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SectionToNodeMap {
        private final Node[] nodes;

        SectionToNodeMap(int p_296136_) {
            this.nodes = new Node[p_296136_];
        }

        public void put(SectionRenderDispatcher.RenderSection p_295644_, Node p_295953_) {
            this.nodes[p_295644_.index] = p_295953_;
        }

        @Nullable
        public Node get(SectionRenderDispatcher.RenderSection p_295721_) {
            int i = p_295721_.index;
            return i >= 0 && i < this.nodes.length ? this.nodes[i] : null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @VisibleForDebug
    public static class Node {
        @VisibleForDebug
        protected final SectionRenderDispatcher.RenderSection section;
        private byte sourceDirections;
        byte directions;
        @VisibleForDebug
        public final int step;

        Node(SectionRenderDispatcher.RenderSection p_295110_, @Nullable Direction p_295920_, int p_295951_) {
            this.section = p_295110_;
            if (p_295920_ != null) {
                this.addSourceDirection(p_295920_);
            }
            this.step = p_295951_;
        }

        void setDirections(byte p_295029_, Direction p_296033_) {
            this.directions = (byte)(this.directions | p_295029_ | 1 << p_296033_.ordinal());
        }

        boolean hasDirection(Direction p_294996_) {
            return (this.directions & 1 << p_294996_.ordinal()) > 0;
        }

        void addSourceDirection(Direction p_295444_) {
            this.sourceDirections = (byte)(this.sourceDirections | this.sourceDirections | 1 << p_295444_.ordinal());
        }

        @VisibleForDebug
        public boolean hasSourceDirection(int p_294302_) {
            return (this.sourceDirections & 1 << p_294302_) > 0;
        }

        boolean hasSourceDirections() {
            return this.sourceDirections != 0;
        }

        public int hashCode() {
            return Long.hashCode(this.section.getSectionNode());
        }

        public boolean equals(Object p_295498_) {
            boolean bl;
            if (!(p_295498_ instanceof Node)) {
                bl = false;
            } else {
                Node sectionocclusiongraph$node = (Node)p_295498_;
                bl = this.section.getSectionNode() == sectionocclusiongraph$node.section.getSectionNode();
            }
            return bl;
        }
    }
}

