/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderStateShard {
    public static final double MAX_ENCHANTMENT_GLINT_SPEED_MILLIS = 8.0;
    protected final String name;
    private final Runnable setupState;
    private final Runnable clearState;
    public static final TextureStateShard BLOCK_SHEET_MIPPED = new TextureStateShard(TextureAtlas.LOCATION_BLOCKS, true);
    public static final TextureStateShard BLOCK_SHEET = new TextureStateShard(TextureAtlas.LOCATION_BLOCKS, false);
    public static final EmptyTextureStateShard NO_TEXTURE = new EmptyTextureStateShard();
    public static final TexturingStateShard DEFAULT_TEXTURING = new TexturingStateShard("default_texturing", () -> {}, () -> {});
    public static final TexturingStateShard GLINT_TEXTURING = new TexturingStateShard("glint_texturing", () -> RenderStateShard.setupGlintTexturing(8.0f), RenderSystem::resetTextureMatrix);
    public static final TexturingStateShard ENTITY_GLINT_TEXTURING = new TexturingStateShard("entity_glint_texturing", () -> RenderStateShard.setupGlintTexturing(0.5f), RenderSystem::resetTextureMatrix);
    public static final TexturingStateShard ARMOR_ENTITY_GLINT_TEXTURING = new TexturingStateShard("armor_entity_glint_texturing", () -> RenderStateShard.setupGlintTexturing(0.16f), RenderSystem::resetTextureMatrix);
    public static final LightmapStateShard LIGHTMAP = new LightmapStateShard(true);
    public static final LightmapStateShard NO_LIGHTMAP = new LightmapStateShard(false);
    public static final OverlayStateShard OVERLAY = new OverlayStateShard(true);
    public static final OverlayStateShard NO_OVERLAY = new OverlayStateShard(false);
    public static final LayeringStateShard NO_LAYERING = new LayeringStateShard("no_layering", () -> {}, () -> {});
    public static final LayeringStateShard VIEW_OFFSET_Z_LAYERING = new LayeringStateShard("view_offset_z_layering", () -> {
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        RenderSystem.getProjectionType().applyLayeringTransform((Matrix4f)matrix4fstack, 1.0f);
    }, () -> {
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.popMatrix();
    });
    public static final LayeringStateShard VIEW_OFFSET_Z_LAYERING_FORWARD = new LayeringStateShard("view_offset_z_layering_forward", () -> {
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        RenderSystem.getProjectionType().applyLayeringTransform((Matrix4f)matrix4fstack, -1.0f);
    }, () -> {
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.popMatrix();
    });
    public static final OutputStateShard MAIN_TARGET = new OutputStateShard("main_target", () -> Minecraft.getInstance().getMainRenderTarget());
    public static final OutputStateShard OUTLINE_TARGET = new OutputStateShard("outline_target", () -> {
        RenderTarget rendertarget = Minecraft.getInstance().levelRenderer.entityOutlineTarget();
        return rendertarget != null ? rendertarget : Minecraft.getInstance().getMainRenderTarget();
    });
    public static final OutputStateShard TRANSLUCENT_TARGET = new OutputStateShard("translucent_target", () -> {
        RenderTarget rendertarget = Minecraft.getInstance().levelRenderer.getTranslucentTarget();
        return rendertarget != null ? rendertarget : Minecraft.getInstance().getMainRenderTarget();
    });
    public static final OutputStateShard PARTICLES_TARGET = new OutputStateShard("particles_target", () -> {
        RenderTarget rendertarget = Minecraft.getInstance().levelRenderer.getParticlesTarget();
        return rendertarget != null ? rendertarget : Minecraft.getInstance().getMainRenderTarget();
    });
    public static final OutputStateShard WEATHER_TARGET = new OutputStateShard("weather_target", () -> {
        RenderTarget rendertarget = Minecraft.getInstance().levelRenderer.getWeatherTarget();
        return rendertarget != null ? rendertarget : Minecraft.getInstance().getMainRenderTarget();
    });
    public static final OutputStateShard ITEM_ENTITY_TARGET = new OutputStateShard("item_entity_target", () -> {
        RenderTarget rendertarget = Minecraft.getInstance().levelRenderer.getItemEntityTarget();
        return rendertarget != null ? rendertarget : Minecraft.getInstance().getMainRenderTarget();
    });
    public static final LineStateShard DEFAULT_LINE = new LineStateShard(OptionalDouble.of(1.0));

    public RenderStateShard(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        this.name = p_110161_;
        this.setupState = p_110162_;
        this.clearState = p_110163_;
    }

    public void setupRenderState() {
        this.setupState.run();
    }

    public void clearRenderState() {
        this.clearState.run();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static void setupGlintTexturing(float p_110187_) {
        long i = (long)((double)Util.getMillis() * Minecraft.getInstance().options.glintSpeed().get() * 8.0);
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(-f, f1, 0.0f);
        matrix4f.rotateZ(0.17453292f).scale(p_110187_);
        RenderSystem.setTextureMatrix(matrix4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TextureStateShard
    extends EmptyTextureStateShard {
        private final Optional<ResourceLocation> texture;
        protected boolean mipmap;

        public TextureStateShard(ResourceLocation p_110333_, boolean p_110334_) {
            super(() -> {
                TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
                AbstractTexture abstracttexture = texturemanager.getTexture(p_110333_);
                abstracttexture.setUseMipmaps(p_110334_);
                RenderSystem.setShaderTexture(0, abstracttexture.getTextureView());
            }, () -> {});
            this.texture = Optional.of(p_110333_);
            this.mipmap = p_110334_;
        }

        @Override
        public String toString() {
            return this.name + "[" + String.valueOf(this.texture) + "(mipmap=" + this.mipmap + ")]";
        }

        @Override
        protected Optional<ResourceLocation> cutoutTexture() {
            return this.texture;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EmptyTextureStateShard
    extends RenderStateShard {
        public EmptyTextureStateShard(Runnable p_173117_, Runnable p_173118_) {
            super("texture", p_173117_, p_173118_);
        }

        EmptyTextureStateShard() {
            super("texture", () -> {}, () -> {});
        }

        protected Optional<ResourceLocation> cutoutTexture() {
            return Optional.empty();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TexturingStateShard
    extends RenderStateShard {
        public TexturingStateShard(String p_110349_, Runnable p_110350_, Runnable p_110351_) {
            super(p_110349_, p_110350_, p_110351_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LightmapStateShard
    extends BooleanStateShard {
        public LightmapStateShard(boolean p_110271_) {
            super("lightmap", () -> {
                if (p_110271_) {
                    Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
                }
            }, () -> {
                if (p_110271_) {
                    Minecraft.getInstance().gameRenderer.lightTexture().turnOffLightLayer();
                }
            }, p_110271_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class OverlayStateShard
    extends BooleanStateShard {
        public OverlayStateShard(boolean p_110304_) {
            super("overlay", () -> {
                if (p_110304_) {
                    Minecraft.getInstance().gameRenderer.overlayTexture().setupOverlayColor();
                }
            }, () -> {
                if (p_110304_) {
                    Minecraft.getInstance().gameRenderer.overlayTexture().teardownOverlayColor();
                }
            }, p_110304_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LayeringStateShard
    extends RenderStateShard {
        public LayeringStateShard(String p_110267_, Runnable p_110268_, Runnable p_110269_) {
            super(p_110267_, p_110268_, p_110269_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class OutputStateShard
    extends RenderStateShard {
        private final Supplier<RenderTarget> renderTargetSupplier;

        public OutputStateShard(String p_110300_, Supplier<RenderTarget> p_410564_) {
            super(p_110300_, () -> {}, () -> {});
            this.renderTargetSupplier = p_410564_;
        }

        public RenderTarget getRenderTarget() {
            return this.renderTargetSupplier.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LineStateShard
    extends RenderStateShard {
        private final OptionalDouble width;

        public LineStateShard(OptionalDouble p_110278_) {
            super("line_width", () -> {
                if (!Objects.equals(p_110278_, OptionalDouble.of(1.0))) {
                    if (p_110278_.isPresent()) {
                        RenderSystem.lineWidth((float)p_110278_.getAsDouble());
                    } else {
                        RenderSystem.lineWidth(Math.max(2.5f, (float)Minecraft.getInstance().getWindow().getWidth() / 1920.0f * 2.5f));
                    }
                }
            }, () -> {
                if (!Objects.equals(p_110278_, OptionalDouble.of(1.0))) {
                    RenderSystem.lineWidth(1.0f);
                }
            });
            this.width = p_110278_;
        }

        @Override
        public String toString() {
            return this.name + "[" + String.valueOf(this.width.isPresent() ? Double.valueOf(this.width.getAsDouble()) : "window_scale") + "]";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class OffsetTexturingStateShard
    extends TexturingStateShard {
        public OffsetTexturingStateShard(float p_110290_, float p_110291_) {
            super("offset_texturing", () -> RenderSystem.setTextureMatrix(new Matrix4f().translation(p_110290_, p_110291_, 0.0f)), () -> RenderSystem.resetTextureMatrix());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MultiTextureStateShard
    extends EmptyTextureStateShard {
        private final Optional<ResourceLocation> cutoutTexture;

        MultiTextureStateShard(List<Entry> p_390474_) {
            super(() -> {
                for (int i = 0; i < p_390474_.size(); ++i) {
                    Entry renderstateshard$multitexturestateshard$entry = (Entry)p_390474_.get(i);
                    TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
                    AbstractTexture abstracttexture = texturemanager.getTexture(renderstateshard$multitexturestateshard$entry.id);
                    abstracttexture.setUseMipmaps(renderstateshard$multitexturestateshard$entry.mipmap);
                    RenderSystem.setShaderTexture(i, abstracttexture.getTextureView());
                }
            }, () -> {});
            this.cutoutTexture = p_390474_.isEmpty() ? Optional.empty() : Optional.of(p_390474_.getFirst().id);
        }

        @Override
        protected Optional<ResourceLocation> cutoutTexture() {
            return this.cutoutTexture;
        }

        public static Builder builder() {
            return new Builder();
        }

        @OnlyIn(value=Dist.CLIENT)
        public record Entry(ResourceLocation id, boolean mipmap) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public static final class Builder {
            private final ImmutableList.Builder<Entry> builder = new ImmutableList.Builder();

            public Builder add(ResourceLocation p_173133_, boolean p_173134_) {
                this.builder.add((Object)new Entry(p_173133_, p_173134_));
                return this;
            }

            public MultiTextureStateShard build() {
                return new MultiTextureStateShard((List<Entry>)this.builder.build());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BooleanStateShard
    extends RenderStateShard {
        private final boolean enabled;

        public BooleanStateShard(String p_110229_, Runnable p_110230_, Runnable p_110231_, boolean p_110232_) {
            super(p_110229_, p_110230_, p_110231_);
            this.enabled = p_110232_;
        }

        @Override
        public String toString() {
            return this.name + "[" + this.enabled + "]";
        }
    }
}

