/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.renderer.MappableRingBuffer;
import net.minecraft.client.renderer.UniformValue;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class PostPass
implements AutoCloseable {
    private static final int UBO_SIZE_PER_SAMPLER = new Std140SizeCalculator().putVec2().get();
    private final String name;
    private final RenderPipeline pipeline;
    private final ResourceLocation outputTargetId;
    private final Map<String, GpuBuffer> customUniforms = new HashMap<String, GpuBuffer>();
    private final MappableRingBuffer infoUbo;
    private final List<Input> inputs;

    public PostPass(RenderPipeline p_405106_, ResourceLocation p_361923_, Map<String, List<UniformValue>> p_418374_, List<Input> p_366745_) {
        this.pipeline = p_405106_;
        this.name = p_405106_.getLocation().toString();
        this.outputTargetId = p_361923_;
        this.inputs = p_366745_;
        for (Map.Entry<String, List<UniformValue>> entry : p_418374_.entrySet()) {
            List<UniformValue> list = entry.getValue();
            if (list.isEmpty()) continue;
            Std140SizeCalculator std140sizecalculator = new Std140SizeCalculator();
            for (UniformValue uniformvalue : list) {
                uniformvalue.addSize(std140sizecalculator);
            }
            int i = std140sizecalculator.get();
            MemoryStack memorystack = MemoryStack.stackPush();
            try {
                Std140Builder std140builder = Std140Builder.onStack(memorystack, i);
                for (UniformValue uniformvalue1 : list) {
                    uniformvalue1.writeTo(std140builder);
                }
                this.customUniforms.put(entry.getKey(), RenderSystem.getDevice().createBuffer(() -> this.name + " / " + (String)entry.getKey(), 128, std140builder.get()));
            }
            finally {
                if (memorystack == null) continue;
                memorystack.close();
            }
        }
        this.infoUbo = new MappableRingBuffer(() -> this.name + " SamplerInfo", 130, (p_366745_.size() + 1) * UBO_SIZE_PER_SAMPLER);
    }

    public void addToFrame(FrameGraphBuilder p_361477_, Map<ResourceLocation, ResourceHandle<RenderTarget>> p_364596_, GpuBufferSlice p_418074_) {
        FramePass framepass = p_361477_.addPass(this.name);
        for (Input postpass$input : this.inputs) {
            postpass$input.addToPass(framepass, p_364596_);
        }
        ResourceHandle resourcehandle = p_364596_.computeIfPresent(this.outputTargetId, (p_362663_, p_363989_) -> framepass.readsAndWrites(p_363989_));
        if (resourcehandle == null) {
            throw new IllegalStateException("Missing handle for target " + String.valueOf(this.outputTargetId));
        }
        framepass.executes(() -> {
            RenderTarget rendertarget = (RenderTarget)resourcehandle.get();
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix(p_418074_, ProjectionType.ORTHOGRAPHIC);
            CommandEncoder commandencoder = RenderSystem.getDevice().createCommandEncoder();
            List<Pair> list = this.inputs.stream().map(p_423166_ -> Pair.of((Object)p_423166_.samplerName(), (Object)p_423166_.texture(p_364596_))).toList();
            try (GpuBuffer.MappedView gpubuffer$mappedview = commandencoder.mapBuffer(this.infoUbo.currentBuffer(), false, true);){
                Std140Builder std140builder = Std140Builder.intoBuffer(gpubuffer$mappedview.data());
                std140builder.putVec2(rendertarget.width, rendertarget.height);
                for (Pair pair : list) {
                    std140builder.putVec2(((GpuTextureView)pair.getSecond()).getWidth(0), ((GpuTextureView)pair.getSecond()).getHeight(0));
                }
            }
            GpuBuffer gpubuffer = RenderSystem.getQuadVertexBuffer();
            RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
            GpuBuffer gpubuffer1 = rendersystem$autostorageindexbuffer.getBuffer(6);
            try (RenderPass renderpass = commandencoder.createRenderPass(() -> "Post pass " + this.name, rendertarget.getColorTextureView(), OptionalInt.empty(), rendertarget.useDepth ? rendertarget.getDepthTextureView() : null, OptionalDouble.empty());){
                renderpass.setPipeline(this.pipeline);
                RenderSystem.bindDefaultUniforms(renderpass);
                renderpass.setUniform("SamplerInfo", this.infoUbo.currentBuffer());
                for (Map.Entry<String, GpuBuffer> entry : this.customUniforms.entrySet()) {
                    renderpass.setUniform(entry.getKey(), entry.getValue());
                }
                renderpass.setVertexBuffer(0, gpubuffer);
                renderpass.setIndexBuffer(gpubuffer1, rendersystem$autostorageindexbuffer.type());
                for (Pair pair1 : list) {
                    renderpass.bindSampler((String)pair1.getFirst() + "Sampler", (GpuTextureView)pair1.getSecond());
                }
                renderpass.drawIndexed(0, 0, 6, 1);
            }
            this.infoUbo.rotate();
            RenderSystem.restoreProjectionMatrix();
            for (Input postpass$input1 : this.inputs) {
                postpass$input1.cleanup(p_364596_);
            }
        });
    }

    @Override
    public void close() {
        for (GpuBuffer gpubuffer : this.customUniforms.values()) {
            gpubuffer.close();
        }
        this.infoUbo.close();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Input {
        public void addToPass(FramePass var1, Map<ResourceLocation, ResourceHandle<RenderTarget>> var2);

        default public void cleanup(Map<ResourceLocation, ResourceHandle<RenderTarget>> p_364998_) {
        }

        public GpuTextureView texture(Map<ResourceLocation, ResourceHandle<RenderTarget>> var1);

        public String samplerName();
    }

    @OnlyIn(value=Dist.CLIENT)
    public record TextureInput(String samplerName, AbstractTexture texture, int width, int height) implements Input
    {
        @Override
        public void addToPass(FramePass p_361843_, Map<ResourceLocation, ResourceHandle<RenderTarget>> p_362022_) {
        }

        @Override
        public GpuTextureView texture(Map<ResourceLocation, ResourceHandle<RenderTarget>> p_418145_) {
            return this.texture.getTextureView();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record TargetInput(String samplerName, ResourceLocation targetId, boolean depthBuffer, boolean bilinear) implements Input
    {
        private ResourceHandle<RenderTarget> getHandle(Map<ResourceLocation, ResourceHandle<RenderTarget>> p_364534_) {
            ResourceHandle<RenderTarget> resourcehandle = p_364534_.get(this.targetId);
            if (resourcehandle == null) {
                throw new IllegalStateException("Missing handle for target " + String.valueOf(this.targetId));
            }
            return resourcehandle;
        }

        @Override
        public void addToPass(FramePass p_364579_, Map<ResourceLocation, ResourceHandle<RenderTarget>> p_360589_) {
            p_364579_.reads(this.getHandle(p_360589_));
        }

        @Override
        public void cleanup(Map<ResourceLocation, ResourceHandle<RenderTarget>> p_363172_) {
            if (this.bilinear) {
                this.getHandle(p_363172_).get().setFilterMode(FilterMode.NEAREST);
            }
        }

        @Override
        public GpuTextureView texture(Map<ResourceLocation, ResourceHandle<RenderTarget>> p_361239_) {
            GpuTextureView gputextureview;
            ResourceHandle<RenderTarget> resourcehandle = this.getHandle(p_361239_);
            RenderTarget rendertarget = resourcehandle.get();
            rendertarget.setFilterMode(this.bilinear ? FilterMode.LINEAR : FilterMode.NEAREST);
            GpuTextureView gpuTextureView = gputextureview = this.depthBuffer ? rendertarget.getDepthTextureView() : rendertarget.getColorTextureView();
            if (gputextureview == null) {
                throw new IllegalStateException("Missing " + (this.depthBuffer ? "depth" : "color") + "texture for target " + String.valueOf(this.targetId));
            }
            return gputextureview;
        }
    }
}

