/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.resource.RenderTargetDescriptor;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.shaders.UniformType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.PostChainConfig;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PostChain
implements AutoCloseable {
    public static final ResourceLocation MAIN_TARGET_ID = ResourceLocation.withDefaultNamespace("main");
    private final List<PostPass> passes;
    private final Map<ResourceLocation, PostChainConfig.InternalTarget> internalTargets;
    private final Set<ResourceLocation> externalTargets;
    private final Map<ResourceLocation, RenderTarget> persistentTargets = new HashMap<ResourceLocation, RenderTarget>();
    private final CachedOrthoProjectionMatrixBuffer projectionMatrixBuffer;

    private PostChain(List<PostPass> p_364536_, Map<ResourceLocation, PostChainConfig.InternalTarget> p_361479_, Set<ResourceLocation> p_361607_, CachedOrthoProjectionMatrixBuffer p_418200_) {
        this.passes = p_364536_;
        this.internalTargets = p_361479_;
        this.externalTargets = p_361607_;
        this.projectionMatrixBuffer = p_418200_;
    }

    public static PostChain load(PostChainConfig p_366777_, TextureManager p_110034_, Set<ResourceLocation> p_362436_, ResourceLocation p_405015_, CachedOrthoProjectionMatrixBuffer p_418231_) throws ShaderManager.CompilationException {
        Stream stream = p_366777_.passes().stream().flatMap(PostChainConfig.Pass::referencedTargets);
        Set<ResourceLocation> set = stream.filter(p_359202_ -> !p_366777_.internalTargets().containsKey(p_359202_)).collect(Collectors.toSet());
        Sets.SetView set1 = Sets.difference(set, p_362436_);
        if (!set1.isEmpty()) {
            throw new ShaderManager.CompilationException("Referenced external targets are not available in this context: " + String.valueOf(set1));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < p_366777_.passes().size(); ++i) {
            PostChainConfig.Pass postchainconfig$pass = p_366777_.passes().get(i);
            builder.add((Object)PostChain.createPass(p_110034_, postchainconfig$pass, p_405015_.withSuffix("/" + i)));
        }
        return new PostChain((List<PostPass>)builder.build(), p_366777_.internalTargets(), set, p_418231_);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PostPass createPass(TextureManager p_364641_, PostChainConfig.Pass p_361826_, ResourceLocation p_405738_) throws ShaderManager.CompilationException {
        RenderPipeline.Builder renderpipeline$builder = RenderPipeline.builder(RenderPipelines.POST_PROCESSING_SNIPPET).withFragmentShader(p_361826_.fragmentShaderId()).withVertexShader(p_361826_.vertexShaderId()).withLocation(p_405738_);
        for (PostChainConfig.Input postchainconfig$input : p_361826_.inputs()) {
            renderpipeline$builder.withSampler(postchainconfig$input.samplerName() + "Sampler");
        }
        renderpipeline$builder.withUniform("SamplerInfo", UniformType.UNIFORM_BUFFER);
        for (String s1 : p_361826_.uniforms().keySet()) {
            renderpipeline$builder.withUniform(s1, UniformType.UNIFORM_BUFFER);
        }
        RenderPipeline renderpipeline = renderpipeline$builder.build();
        ArrayList<PostPass.Input> list = new ArrayList<PostPass.Input>();
        Iterator<PostChainConfig.Input> iterator = p_361826_.inputs().iterator();
        block9: while (true) {
            PostChainConfig.Input input;
            if (!iterator.hasNext()) {
                return new PostPass(renderpipeline, p_361826_.outputTarget(), p_361826_.uniforms(), list);
            }
            PostChainConfig.Input postchainconfig$input1 = iterator.next();
            Objects.requireNonNull(postchainconfig$input1);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PostChainConfig.TextureInput.class, PostChainConfig.TargetInput.class}, (Object)input, n)) {
                case 0: {
                    PostChainConfig.TextureInput textureInput = (PostChainConfig.TextureInput)input;
                    try {
                        int n2;
                        Object object = textureInput.samplerName();
                        String s2 = object;
                        Object resourcelocation = object = textureInput.location();
                        int i = n2 = textureInput.width();
                        int j = n2 = textureInput.height();
                        int flag = n2 = (int)(textureInput.bilinear() ? 1 : 0);
                        AbstractTexture abstracttexture = p_364641_.getTexture(((ResourceLocation)resourcelocation).withPath(p_359199_ -> "textures/effect/" + p_359199_ + ".png"));
                        abstracttexture.setFilter(flag != 0, false);
                        list.add(new PostPass.TextureInput(s2, abstracttexture, i, j));
                        continue block9;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    PostChainConfig.TargetInput targetInput = (PostChainConfig.TargetInput)input;
                    {
                        boolean bl;
                        Object object = targetInput.samplerName();
                        String s = object;
                        Object resourcelocation1 = object = targetInput.targetId();
                        boolean flag1 = bl = targetInput.useDepthBuffer();
                        boolean flag2 = bl = targetInput.bilinear();
                        list.add(new PostPass.TargetInput(s, (ResourceLocation)resourcelocation1, flag1, flag2));
                    }
                    continue block9;
                }
            }
            break;
        }
        throw new MatchException(null, null);
    }

    public void addToFrame(FrameGraphBuilder p_362523_, int p_361423_, int p_362735_, TargetBundle p_361871_) {
        GpuBufferSlice gpubufferslice = this.projectionMatrixBuffer.getBuffer(p_361423_, p_362735_);
        HashMap<ResourceLocation, ResourceHandle<RenderTarget>> map = new HashMap<ResourceLocation, ResourceHandle<RenderTarget>>(this.internalTargets.size() + this.externalTargets.size());
        for (ResourceLocation resourceLocation : this.externalTargets) {
            map.put(resourceLocation, p_361871_.getOrThrow(resourceLocation));
        }
        for (Map.Entry entry : this.internalTargets.entrySet()) {
            ResourceLocation resourcelocation1 = (ResourceLocation)entry.getKey();
            PostChainConfig.InternalTarget postchainconfig$internaltarget = (PostChainConfig.InternalTarget)entry.getValue();
            RenderTargetDescriptor rendertargetdescriptor = new RenderTargetDescriptor(postchainconfig$internaltarget.width().orElse(p_361423_), postchainconfig$internaltarget.height().orElse(p_362735_), true, postchainconfig$internaltarget.clearColor());
            if (postchainconfig$internaltarget.persistent()) {
                RenderTarget rendertarget = this.getOrCreatePersistentTarget(resourcelocation1, rendertargetdescriptor);
                map.put(resourcelocation1, p_362523_.importExternal(resourcelocation1.toString(), rendertarget));
                continue;
            }
            map.put(resourcelocation1, p_362523_.createInternal(resourcelocation1.toString(), rendertargetdescriptor));
        }
        for (PostPass postPass : this.passes) {
            postPass.addToFrame(p_362523_, map, gpubufferslice);
        }
        for (ResourceLocation resourceLocation : this.externalTargets) {
            p_361871_.replace(resourceLocation, (ResourceHandle)map.get(resourceLocation));
        }
    }

    @Deprecated
    public void process(RenderTarget p_361528_, GraphicsResourceAllocator p_361187_) {
        FrameGraphBuilder framegraphbuilder = new FrameGraphBuilder();
        TargetBundle postchain$targetbundle = TargetBundle.of(MAIN_TARGET_ID, framegraphbuilder.importExternal("main", p_361528_));
        this.addToFrame(framegraphbuilder, p_361528_.width, p_361528_.height, postchain$targetbundle);
        framegraphbuilder.execute(p_361187_);
    }

    private RenderTarget getOrCreatePersistentTarget(ResourceLocation p_418113_, RenderTargetDescriptor p_418259_) {
        RenderTarget rendertarget = this.persistentTargets.get(p_418113_);
        if (rendertarget == null || rendertarget.width != p_418259_.width() || rendertarget.height != p_418259_.height()) {
            if (rendertarget != null) {
                rendertarget.destroyBuffers();
            }
            rendertarget = p_418259_.allocate();
            p_418259_.prepare(rendertarget);
            this.persistentTargets.put(p_418113_, rendertarget);
        }
        return rendertarget;
    }

    @Override
    public void close() {
        this.persistentTargets.values().forEach(RenderTarget::destroyBuffers);
        this.persistentTargets.clear();
        for (PostPass postpass : this.passes) {
            postpass.close();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface TargetBundle {
        public static TargetBundle of(final ResourceLocation p_362084_, final ResourceHandle<RenderTarget> p_365173_) {
            return new TargetBundle(){
                private ResourceHandle<RenderTarget> handle;
                {
                    this.handle = p_365173_;
                }

                @Override
                public void replace(ResourceLocation p_363133_, ResourceHandle<RenderTarget> p_360603_) {
                    if (!p_363133_.equals(p_362084_)) {
                        throw new IllegalArgumentException("No target with id " + String.valueOf(p_363133_));
                    }
                    this.handle = p_360603_;
                }

                @Override
                @Nullable
                public ResourceHandle<RenderTarget> get(ResourceLocation p_360954_) {
                    return p_360954_.equals(p_362084_) ? this.handle : null;
                }
            };
        }

        public void replace(ResourceLocation var1, ResourceHandle<RenderTarget> var2);

        @Nullable
        public ResourceHandle<RenderTarget> get(ResourceLocation var1);

        default public ResourceHandle<RenderTarget> getOrThrow(ResourceLocation p_360758_) {
            ResourceHandle<RenderTarget> resourcehandle = this.get(p_360758_);
            if (resourcehandle == null) {
                throw new IllegalArgumentException("Missing target with id " + String.valueOf(p_360758_));
            }
            return resourcehandle;
        }
    }
}

