/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PanoramaRenderer {
    public static final ResourceLocation PANORAMA_OVERLAY = ResourceLocation.withDefaultNamespace("textures/gui/title/background/panorama_overlay.png");
    private Minecraft minecraft;
    private final CubeMap cubeMap;
    private float spin;

    public PanoramaRenderer(CubeMap p_110002_) {
        this.cubeMap = p_110002_;
        this.minecraft = Minecraft.getInstance();
    }

    public void render(GuiGraphics p_334063_, int p_333839_, int p_333923_, boolean p_418077_) {
        if (p_418077_) {
            float f = this.minecraft.getDeltaTracker().getRealtimeDeltaTicks();
            float f1 = (float)((double)f * this.minecraft.options.panoramaSpeed().get());
            this.spin = PanoramaRenderer.wrap(this.spin + f1 * 0.1f, 360.0f);
        }
        this.cubeMap.render(this.minecraft, 10.0f, -this.spin);
        p_334063_.blit(RenderPipelines.GUI_TEXTURED, PANORAMA_OVERLAY, 0, 0, 0.0f, 0.0f, p_333839_, p_333923_, 16, 128, 16, 128);
    }

    private static float wrap(float p_249058_, float p_249548_) {
        return p_249058_ > p_249548_ ? p_249058_ - p_249548_ : p_249058_;
    }

    public void registerTextures(TextureManager p_423546_) {
        this.cubeMap.registerTextures(p_423546_);
    }
}

