/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.Zone;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GpuWarnlistManager
extends SimplePreparableReloadListener<Preparations> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation GPU_WARNLIST_LOCATION = ResourceLocation.withDefaultNamespace("gpu_warnlist.json");
    private ImmutableMap<String, String> warnings = ImmutableMap.of();
    private boolean showWarning;
    private boolean warningDismissed;
    private boolean skipFabulous;

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean willShowWarning() {
        return this.hasWarnings() && !this.warningDismissed;
    }

    public void showWarning() {
        this.showWarning = true;
    }

    public void dismissWarning() {
        this.warningDismissed = true;
    }

    public void dismissWarningAndSkipFabulous() {
        this.warningDismissed = true;
        this.skipFabulous = true;
    }

    public boolean isShowingWarning() {
        return this.showWarning && !this.warningDismissed;
    }

    public boolean isSkippingFabulous() {
        return this.skipFabulous;
    }

    public void resetWarnings() {
        this.showWarning = false;
        this.warningDismissed = false;
        this.skipFabulous = false;
    }

    @Nullable
    public String getRendererWarnings() {
        return (String)this.warnings.get((Object)"renderer");
    }

    @Nullable
    public String getVersionWarnings() {
        return (String)this.warnings.get((Object)"version");
    }

    @Nullable
    public String getVendorWarnings() {
        return (String)this.warnings.get((Object)"vendor");
    }

    @Nullable
    public String getAllWarnings() {
        StringBuilder stringbuilder = new StringBuilder();
        this.warnings.forEach((p_109235_, p_109236_) -> stringbuilder.append((String)p_109235_).append(": ").append((String)p_109236_));
        return stringbuilder.length() == 0 ? null : stringbuilder.toString();
    }

    @Override
    protected Preparations prepare(ResourceManager p_109220_, ProfilerFiller p_109221_) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        JsonObject jsonobject = GpuWarnlistManager.parseJson(p_109220_, p_109221_);
        if (jsonobject != null) {
            try (Zone zone = p_109221_.zone("compile_regex");){
                GpuWarnlistManager.compilePatterns(jsonobject.getAsJsonArray("renderer"), list);
                GpuWarnlistManager.compilePatterns(jsonobject.getAsJsonArray("version"), list1);
                GpuWarnlistManager.compilePatterns(jsonobject.getAsJsonArray("vendor"), list2);
            }
        }
        return new Preparations(list, list1, list2);
    }

    @Override
    protected void apply(Preparations p_109226_, ResourceManager p_109227_, ProfilerFiller p_109228_) {
        this.warnings = p_109226_.apply();
    }

    private static void compilePatterns(JsonArray p_109223_, List<Pattern> p_109224_) {
        p_109223_.forEach(p_109239_ -> p_109224_.add(Pattern.compile(p_109239_.getAsString(), 2)));
    }

    @Nullable
    private static JsonObject parseJson(ResourceManager p_109245_, ProfilerFiller p_109246_) {
        try {
            JsonObject jsonobject;
            try (Zone zone = p_109246_.zone("parse_json");
                 BufferedReader reader = p_109245_.openAsReader(GPU_WARNLIST_LOCATION);){
                jsonobject = StrictJsonParser.parse(reader).getAsJsonObject();
            }
            return jsonobject;
        }
        catch (JsonSyntaxException | IOException ioexception) {
            LOGGER.warn("Failed to load GPU warnlist", ioexception);
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static final class Preparations {
        private final List<Pattern> rendererPatterns;
        private final List<Pattern> versionPatterns;
        private final List<Pattern> vendorPatterns;

        Preparations(List<Pattern> p_109261_, List<Pattern> p_109262_, List<Pattern> p_109263_) {
            this.rendererPatterns = p_109261_;
            this.versionPatterns = p_109262_;
            this.vendorPatterns = p_109263_;
        }

        private static String matchAny(List<Pattern> p_109273_, String p_109274_) {
            ArrayList list = Lists.newArrayList();
            for (Pattern pattern : p_109273_) {
                Matcher matcher = pattern.matcher(p_109274_);
                while (matcher.find()) {
                    list.add(matcher.group());
                }
            }
            return String.join((CharSequence)", ", list);
        }

        ImmutableMap<String, String> apply() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            GpuDevice gpudevice = RenderSystem.getDevice();
            if (gpudevice.getBackendName().equals("OpenGL")) {
                String s2;
                String s1;
                String s = Preparations.matchAny(this.rendererPatterns, gpudevice.getRenderer());
                if (!s.isEmpty()) {
                    builder.put((Object)"renderer", (Object)s);
                }
                if (!(s1 = Preparations.matchAny(this.versionPatterns, gpudevice.getVersion())).isEmpty()) {
                    builder.put((Object)"version", (Object)s1);
                }
                if (!(s2 = Preparations.matchAny(this.vendorPatterns, gpudevice.getVendor())).isEmpty()) {
                    builder.put((Object)"vendor", (Object)s2);
                }
            }
            return builder.build();
        }
    }
}

