/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.minecraft.client.DeltaTracker;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class GlobalSettingsUniform
implements AutoCloseable {
    public static final int UBO_SIZE = new Std140SizeCalculator().putVec2().putFloat().putFloat().putInt().get();
    private final GpuBuffer buffer = RenderSystem.getDevice().createBuffer(() -> "Global Settings UBO", 136, UBO_SIZE);

    public void update(int p_418423_, int p_418065_, double p_418173_, long p_418308_, DeltaTracker p_418331_, int p_418075_) {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = Std140Builder.onStack(memorystack, UBO_SIZE).putVec2(p_418423_, p_418065_).putFloat((float)p_418173_).putFloat(((float)(p_418308_ % 24000L) + p_418331_.getGameTimeDeltaPartialTick(false)) / 24000.0f).putInt(p_418075_).get();
            RenderSystem.getDevice().createCommandEncoder().writeToBuffer(this.buffer.slice(), bytebuffer);
        }
        RenderSystem.setGlobalSettingsUniform(this.buffer);
    }

    @Override
    public void close() {
        this.buffer.close();
    }
}

