/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.DynamicUniformStorage;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@OnlyIn(value=Dist.CLIENT)
public class DynamicUniforms
implements AutoCloseable {
    public static final int TRANSFORM_UBO_SIZE = new Std140SizeCalculator().putMat4f().putVec4().putVec3().putMat4f().putFloat().get();
    private static final int INITIAL_CAPACITY = 2;
    private final DynamicUniformStorage<Transform> transforms = new DynamicUniformStorage("Dynamic Transforms UBO", TRANSFORM_UBO_SIZE, 2);

    public void reset() {
        this.transforms.endFrame();
    }

    @Override
    public void close() {
        this.transforms.close();
    }

    public GpuBufferSlice writeTransform(Matrix4fc p_418355_, Vector4fc p_418112_, Vector3fc p_418079_, Matrix4fc p_418230_, float p_418006_) {
        return this.transforms.writeUniform(new Transform((Matrix4fc)new Matrix4f(p_418355_), (Vector4fc)new Vector4f(p_418112_), (Vector3fc)new Vector3f(p_418079_), (Matrix4fc)new Matrix4f(p_418230_), p_418006_));
    }

    public GpuBufferSlice[] writeTransforms(Transform ... p_418149_) {
        return this.transforms.writeUniforms(p_418149_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Transform(Matrix4fc modelView, Vector4fc colorModulator, Vector3fc modelOffset, Matrix4fc textureMatrix, float lineWidth) implements DynamicUniformStorage.DynamicUniform
    {
        @Override
        public void write(ByteBuffer p_418425_) {
            Std140Builder.intoBuffer(p_418425_).putMat4f(this.modelView).putVec4(this.colorModulator).putVec3(this.modelOffset).putMat4f(this.textureMatrix).putFloat(this.lineWidth);
        }
    }
}

