/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.quickplay;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class QuickPlayLog {
    private static final QuickPlayLog INACTIVE = new QuickPlayLog(""){

        @Override
        public void log(Minecraft p_279484_) {
        }

        @Override
        public void setWorldData(Type p_279348_, String p_279305_, String p_279177_) {
        }
    };
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private final Path path;
    @Nullable
    private QuickPlayWorld worldData;

    QuickPlayLog(String p_279463_) {
        this.path = Minecraft.getInstance().gameDirectory.toPath().resolve(p_279463_);
    }

    public static QuickPlayLog of(@Nullable String p_279275_) {
        return p_279275_ == null ? INACTIVE : new QuickPlayLog(p_279275_);
    }

    public void setWorldData(Type p_279380_, String p_279427_, String p_279470_) {
        this.worldData = new QuickPlayWorld(p_279380_, p_279427_, p_279470_);
    }

    public void log(Minecraft p_279258_) {
        if (p_279258_.gameMode != null && this.worldData != null) {
            Util.ioPool().execute(() -> {
                try {
                    Files.deleteIfExists(this.path);
                }
                catch (IOException ioexception) {
                    LOGGER.error("Failed to delete quickplay log file {}", (Object)this.path, (Object)ioexception);
                }
                QuickPlayEntry quickplaylog$quickplayentry = new QuickPlayEntry(this.worldData, Instant.now(), p_279258_.gameMode.getPlayerMode());
                Codec.list(QuickPlayEntry.CODEC).encodeStart((DynamicOps)JsonOps.INSTANCE, List.of(quickplaylog$quickplayentry)).resultOrPartial(Util.prefix("Quick Play: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_279238_ -> {
                    try {
                        Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                        Files.writeString(this.path, (CharSequence)GSON.toJson(p_279238_), new OpenOption[0]);
                    }
                    catch (IOException ioexception1) {
                        LOGGER.error("Failed to write to quickplay log file {}", (Object)this.path, (Object)ioexception1);
                    }
                });
            });
        } else {
            LOGGER.error("Failed to log session for quickplay. Missing world data or gamemode");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record QuickPlayWorld(Type type, String id, String name) {
        public static final MapCodec<QuickPlayWorld> MAP_CODEC = RecordCodecBuilder.mapCodec(p_301666_ -> p_301666_.group((App)Type.CODEC.fieldOf("type").forGetter(QuickPlayWorld::type), (App)ExtraCodecs.ESCAPED_STRING.fieldOf("id").forGetter(QuickPlayWorld::id), (App)Codec.STRING.fieldOf("name").forGetter(QuickPlayWorld::name)).apply((Applicative)p_301666_, QuickPlayWorld::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type implements StringRepresentable
    {
        SINGLEPLAYER("singleplayer"),
        MULTIPLAYER("multiplayer"),
        REALMS("realms");

        static final Codec<Type> CODEC;
        private final String name;

        private Type(String p_279349_) {
            this.name = p_279349_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record QuickPlayEntry(QuickPlayWorld quickPlayWorld, Instant lastPlayedTime, GameType gamemode) {
        public static final Codec<QuickPlayEntry> CODEC = RecordCodecBuilder.create(p_279196_ -> p_279196_.group((App)QuickPlayWorld.MAP_CODEC.forGetter(QuickPlayEntry::quickPlayWorld), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("lastPlayedTime").forGetter(QuickPlayEntry::lastPlayedTime), (App)GameType.CODEC.fieldOf("gamemode").forGetter(QuickPlayEntry::gamemode)).apply((Applicative)p_279196_, QuickPlayEntry::new));
    }
}

