/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.quickplay;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerList;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.task.GetServerDetailsTask;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class QuickPlay {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Component ERROR_TITLE = Component.translatable("quickplay.error.title");
    private static final Component INVALID_IDENTIFIER = Component.translatable("quickplay.error.invalid_identifier");
    private static final Component REALM_CONNECT = Component.translatable("quickplay.error.realm_connect");
    private static final Component REALM_PERMISSION = Component.translatable("quickplay.error.realm_permission");
    private static final Component TO_TITLE = Component.translatable("gui.toTitle");
    private static final Component TO_WORLD_LIST = Component.translatable("gui.toWorld");
    private static final Component TO_REALMS_LIST = Component.translatable("gui.toRealms");

    public static void connect(Minecraft p_279319_, GameConfig.QuickPlayVariant p_423554_, RealmsClient p_279322_) {
        if (!p_423554_.isEnabled()) {
            LOGGER.error("Quick play disabled");
            p_279319_.setScreen(new TitleScreen());
        } else {
            GameConfig.QuickPlayVariant quickPlayVariant = p_423554_;
            Objects.requireNonNull(quickPlayVariant);
            GameConfig.QuickPlayVariant quickPlayVariant2 = quickPlayVariant;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GameConfig.QuickPlayMultiplayerData.class, GameConfig.QuickPlayRealmsData.class, GameConfig.QuickPlaySinglePlayerData.class, GameConfig.QuickPlayDisabled.class}, (Object)quickPlayVariant2, n)) {
                case 0: {
                    GameConfig.QuickPlayMultiplayerData gameconfig$quickplaymultiplayerdata = (GameConfig.QuickPlayMultiplayerData)quickPlayVariant2;
                    QuickPlay.joinMultiplayerWorld(p_279319_, gameconfig$quickplaymultiplayerdata.serverAddress());
                    break;
                }
                case 1: {
                    GameConfig.QuickPlayRealmsData gameconfig$quickplayrealmsdata = (GameConfig.QuickPlayRealmsData)quickPlayVariant2;
                    QuickPlay.joinRealmsWorld(p_279319_, p_279322_, gameconfig$quickplayrealmsdata.realmId());
                    break;
                }
                case 2: {
                    GameConfig.QuickPlaySinglePlayerData gameconfig$quickplaysingleplayerdata = (GameConfig.QuickPlaySinglePlayerData)quickPlayVariant2;
                    String s = gameconfig$quickplaysingleplayerdata.worldId();
                    if (StringUtil.isBlank(s)) {
                        s = QuickPlay.getLatestSingleplayerWorld(p_279319_.getLevelSource());
                    }
                    QuickPlay.joinSingleplayerWorld(p_279319_, s);
                    break;
                }
                case 3: {
                    GameConfig.QuickPlayDisabled gameconfig$quickplaydisabled = (GameConfig.QuickPlayDisabled)quickPlayVariant2;
                    LOGGER.error("Quick play disabled");
                    p_279319_.setScreen(new TitleScreen());
                    break;
                }
                default: {
                    throw new MatchException(null, null);
                }
            }
        }
    }

    @Nullable
    private static String getLatestSingleplayerWorld(LevelStorageSource p_423522_) {
        try {
            List<LevelSummary> list = p_423522_.loadLevelSummaries(p_423522_.findLevelCandidates()).get();
            if (list.isEmpty()) {
                LOGGER.warn("no latest singleplayer world found");
                return null;
            }
            return list.getFirst().getLevelId();
        }
        catch (InterruptedException | ExecutionException interruptedexception) {
            LOGGER.error("failed to load singleplayer world summaries", (Throwable)interruptedexception);
            return null;
        }
    }

    private static void joinSingleplayerWorld(Minecraft p_279420_, @Nullable String p_279459_) {
        if (!StringUtil.isBlank(p_279459_) && p_279420_.getLevelSource().levelExists(p_279459_)) {
            p_279420_.createWorldOpenFlows().openWorld(p_279459_, () -> p_279420_.setScreen(new TitleScreen()));
        } else {
            SelectWorldScreen screen = new SelectWorldScreen(new TitleScreen());
            p_279420_.setScreen(new DisconnectedScreen((Screen)screen, ERROR_TITLE, INVALID_IDENTIFIER, TO_WORLD_LIST));
        }
    }

    private static void joinMultiplayerWorld(Minecraft p_279276_, String p_279128_) {
        ServerList serverlist = new ServerList(p_279276_);
        serverlist.load();
        ServerData serverdata = serverlist.get(p_279128_);
        if (serverdata == null) {
            serverdata = new ServerData(I18n.get("selectServer.defaultName", new Object[0]), p_279128_, ServerData.Type.OTHER);
            serverlist.add(serverdata, true);
            serverlist.save();
        }
        ServerAddress serveraddress = ServerAddress.parseString(p_279128_);
        ConnectScreen.startConnecting(new JoinMultiplayerScreen(new TitleScreen()), p_279276_, serveraddress, serverdata, true, null);
    }

    private static void joinRealmsWorld(Minecraft p_279320_, RealmsClient p_279468_, String p_279371_) {
        RealmsServerList realmsserverlist;
        long i;
        try {
            i = Long.parseLong(p_279371_);
            realmsserverlist = p_279468_.listRealms();
        }
        catch (NumberFormatException numberformatexception) {
            RealmsMainScreen screen1 = new RealmsMainScreen(new TitleScreen());
            p_279320_.setScreen(new DisconnectedScreen((Screen)screen1, ERROR_TITLE, INVALID_IDENTIFIER, TO_REALMS_LIST));
            return;
        }
        catch (RealmsServiceException realmsserviceexception) {
            TitleScreen screen = new TitleScreen();
            p_279320_.setScreen(new DisconnectedScreen((Screen)screen, ERROR_TITLE, REALM_CONNECT, TO_TITLE));
            return;
        }
        RealmsServer realmsserver = realmsserverlist.servers.stream().filter(p_279424_ -> p_279424_.id == i).findFirst().orElse(null);
        if (realmsserver == null) {
            RealmsMainScreen screen2 = new RealmsMainScreen(new TitleScreen());
            p_279320_.setScreen(new DisconnectedScreen((Screen)screen2, ERROR_TITLE, REALM_PERMISSION, TO_REALMS_LIST));
        } else {
            TitleScreen titlescreen = new TitleScreen();
            p_279320_.setScreen(new RealmsLongRunningMcoTaskScreen(titlescreen, new GetServerDetailsTask(titlescreen, realmsserver)));
        }
    }
}

