/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GustParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public GustParticle(ClientLevel p_312171_, double p_312015_, double p_312462_, double p_312867_, SpriteSet p_312279_) {
        super(p_312171_, p_312015_, p_312462_, p_312867_);
        this.sprites = p_312279_;
        this.setSpriteFromAge(p_312279_);
        this.lifetime = 12 + this.random.nextInt(4);
        this.quadSize = 1.0f;
        this.setSize(1.0f, 1.0f);
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public int getLightColor(float p_312697_) {
        return 0xF000F0;
    }

    @Override
    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SmallProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public SmallProvider(SpriteSet p_338457_) {
            this.sprites = p_338457_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_338464_, ClientLevel p_338628_, double p_338495_, double p_338874_, double p_338214_, double p_338609_, double p_338492_, double p_338605_) {
            GustParticle particle = new GustParticle(p_338628_, p_338495_, p_338874_, p_338214_, this.sprites);
            ((Particle)particle).scale(0.15f);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet p_312644_) {
            this.sprites = p_312644_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_311849_, ClientLevel p_312008_, double p_312498_, double p_312520_, double p_311822_, double p_312595_, double p_312181_, double p_312468_) {
            return new GustParticle(p_312008_, p_312498_, p_312520_, p_311822_, this.sprites);
        }
    }
}

