/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.chat.report;

import com.mojang.authlib.minecraft.report.AbuseReport;
import com.mojang.authlib.minecraft.report.AbuseReportLimits;
import com.mojang.datafixers.util.Either;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.chat.report.ReportReason;
import net.minecraft.client.multiplayer.chat.report.ReportType;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Report {
    protected final UUID reportId;
    protected final Instant createdAt;
    protected final UUID reportedProfileId;
    protected String comments = "";
    @Nullable
    protected ReportReason reason;
    protected boolean attested;

    public Report(UUID p_299940_, Instant p_300011_, UUID p_299976_) {
        this.reportId = p_299940_;
        this.createdAt = p_300011_;
        this.reportedProfileId = p_299976_;
    }

    public boolean isReportedPlayer(UUID p_300032_) {
        return p_300032_.equals(this.reportedProfileId);
    }

    public abstract Report copy();

    public abstract Screen createScreen(Screen var1, ReportingContext var2);

    @OnlyIn(value=Dist.CLIENT)
    public record Result(UUID id, ReportType reportType, AbuseReport report) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public record CannotBuildReason(Component message) {
        public static final CannotBuildReason NO_REASON = new CannotBuildReason(Component.translatable("gui.abuseReport.send.no_reason"));
        public static final CannotBuildReason NO_REPORTED_MESSAGES = new CannotBuildReason(Component.translatable("gui.chatReport.send.no_reported_messages"));
        public static final CannotBuildReason TOO_MANY_MESSAGES = new CannotBuildReason(Component.translatable("gui.chatReport.send.too_many_messages"));
        public static final CannotBuildReason COMMENT_TOO_LONG = new CannotBuildReason(Component.translatable("gui.abuseReport.send.comment_too_long"));
        public static final CannotBuildReason NOT_ATTESTED = new CannotBuildReason(Component.translatable("gui.abuseReport.send.not_attested"));

        public Tooltip tooltip() {
            return Tooltip.create(this.message);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Builder<R extends Report> {
        protected final R report;
        protected final AbuseReportLimits limits;

        protected Builder(R p_299998_, AbuseReportLimits p_299869_) {
            this.report = p_299998_;
            this.limits = p_299869_;
        }

        public R report() {
            return this.report;
        }

        public UUID reportedProfileId() {
            return ((Report)this.report).reportedProfileId;
        }

        public String comments() {
            return ((Report)this.report).comments;
        }

        public boolean attested() {
            return ((Report)this.report()).attested;
        }

        public void setComments(String p_299837_) {
            ((Report)this.report).comments = p_299837_;
        }

        @Nullable
        public ReportReason reason() {
            return ((Report)this.report).reason;
        }

        public void setReason(ReportReason p_299937_) {
            ((Report)this.report).reason = p_299937_;
        }

        public void setAttested(boolean p_352965_) {
            ((Report)this.report).attested = p_352965_;
        }

        public abstract boolean hasContent();

        @Nullable
        public CannotBuildReason checkBuildable() {
            return !((Report)this.report()).attested ? CannotBuildReason.NOT_ATTESTED : null;
        }

        public abstract Either<Result, CannotBuildReason> build(ReportingContext var1);
    }
}

