/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.chat.report;

import com.google.common.collect.Lists;
import com.mojang.authlib.minecraft.report.AbuseReport;
import com.mojang.authlib.minecraft.report.AbuseReportLimits;
import com.mojang.authlib.minecraft.report.ReportChatMessage;
import com.mojang.authlib.minecraft.report.ReportEvidence;
import com.mojang.authlib.minecraft.report.ReportedEntity;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.reporting.ChatReportScreen;
import net.minecraft.client.multiplayer.chat.LoggedChatMessage;
import net.minecraft.client.multiplayer.chat.report.ChatReportContextBuilder;
import net.minecraft.client.multiplayer.chat.report.Report;
import net.minecraft.client.multiplayer.chat.report.ReportType;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class ChatReport
extends Report {
    final IntSet reportedMessages = new IntOpenHashSet();

    ChatReport(UUID p_300023_, Instant p_299922_, UUID p_299952_) {
        super(p_300023_, p_299922_, p_299952_);
    }

    public void toggleReported(int p_299907_, AbuseReportLimits p_299997_) {
        if (this.reportedMessages.contains(p_299907_)) {
            this.reportedMessages.remove(p_299907_);
        } else if (this.reportedMessages.size() < p_299997_.maxReportedMessageCount()) {
            this.reportedMessages.add(p_299907_);
        }
    }

    @Override
    public ChatReport copy() {
        ChatReport chatreport = new ChatReport(this.reportId, this.createdAt, this.reportedProfileId);
        chatreport.reportedMessages.addAll((IntCollection)this.reportedMessages);
        chatreport.comments = this.comments;
        chatreport.reason = this.reason;
        chatreport.attested = this.attested;
        return chatreport;
    }

    @Override
    public Screen createScreen(Screen p_300022_, ReportingContext p_299859_) {
        return new ChatReportScreen(p_300022_, p_299859_, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder
    extends Report.Builder<ChatReport> {
        public Builder(ChatReport p_299929_, AbuseReportLimits p_299930_) {
            super(p_299929_, p_299930_);
        }

        public Builder(UUID p_299973_, AbuseReportLimits p_299942_) {
            super(new ChatReport(UUID.randomUUID(), Instant.now(), p_299973_), p_299942_);
        }

        public IntSet reportedMessages() {
            return ((ChatReport)this.report).reportedMessages;
        }

        public void toggleReported(int p_299851_) {
            ((ChatReport)this.report).toggleReported(p_299851_, this.limits);
        }

        public boolean isReported(int p_299830_) {
            return ((ChatReport)this.report).reportedMessages.contains(p_299830_);
        }

        @Override
        public boolean hasContent() {
            return StringUtils.isNotEmpty((CharSequence)this.comments()) || !this.reportedMessages().isEmpty() || this.reason() != null;
        }

        @Override
        @Nullable
        public Report.CannotBuildReason checkBuildable() {
            if (((ChatReport)this.report).reportedMessages.isEmpty()) {
                return Report.CannotBuildReason.NO_REPORTED_MESSAGES;
            }
            if (((ChatReport)this.report).reportedMessages.size() > this.limits.maxReportedMessageCount()) {
                return Report.CannotBuildReason.TOO_MANY_MESSAGES;
            }
            if (((ChatReport)this.report).reason == null) {
                return Report.CannotBuildReason.NO_REASON;
            }
            return ((ChatReport)this.report).comments.length() > this.limits.maxOpinionCommentsLength() ? Report.CannotBuildReason.COMMENT_TOO_LONG : super.checkBuildable();
        }

        @Override
        public Either<Report.Result, Report.CannotBuildReason> build(ReportingContext p_299928_) {
            Report.CannotBuildReason report$cannotbuildreason = this.checkBuildable();
            if (report$cannotbuildreason != null) {
                return Either.right((Object)report$cannotbuildreason);
            }
            String s = Objects.requireNonNull(((ChatReport)this.report).reason).backendName();
            ReportEvidence reportevidence = this.buildEvidence(p_299928_);
            ReportedEntity reportedentity = new ReportedEntity(((ChatReport)this.report).reportedProfileId);
            AbuseReport abusereport = AbuseReport.chat((String)((ChatReport)this.report).comments, (String)s, (ReportEvidence)reportevidence, (ReportedEntity)reportedentity, (Instant)((ChatReport)this.report).createdAt);
            return Either.left((Object)new Report.Result(((ChatReport)this.report).reportId, ReportType.CHAT, abusereport));
        }

        private ReportEvidence buildEvidence(ReportingContext p_299855_) {
            ArrayList list = new ArrayList();
            ChatReportContextBuilder chatreportcontextbuilder = new ChatReportContextBuilder(this.limits.leadingContextMessageCount());
            chatreportcontextbuilder.collectAllContext(p_299855_.chatLog(), (IntCollection)((ChatReport)this.report).reportedMessages, (p_299903_, p_300034_) -> list.add(this.buildReportedChatMessage(p_300034_, this.isReported(p_299903_))));
            return new ReportEvidence(Lists.reverse(list));
        }

        private ReportChatMessage buildReportedChatMessage(LoggedChatMessage.Player p_299916_, boolean p_299962_) {
            SignedMessageLink signedmessagelink = p_299916_.message().link();
            SignedMessageBody signedmessagebody = p_299916_.message().signedBody();
            List<ByteBuffer> list = signedmessagebody.lastSeen().entries().stream().map(MessageSignature::asByteBuffer).toList();
            ByteBuffer bytebuffer = Optionull.map(p_299916_.message().signature(), MessageSignature::asByteBuffer);
            return new ReportChatMessage(signedmessagelink.index(), signedmessagelink.sender(), signedmessagelink.sessionId(), signedmessagebody.timeStamp(), signedmessagebody.salt(), list, signedmessagebody.content(), bytebuffer, p_299962_);
        }

        public Builder copy() {
            return new Builder(((ChatReport)this.report).copy(), this.limits);
        }
    }
}

