/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.PngInfo;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ExtendedServerListData;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_ICON_SIZE = 1024;
    public String name;
    public String ip;
    public Component status;
    public Component motd;
    @Nullable
    public ServerStatus.Players players;
    public long ping;
    public int protocol = SharedConstants.getCurrentVersion().protocolVersion();
    public Component version = Component.literal(SharedConstants.getCurrentVersion().name());
    public List<Component> playerList = Collections.emptyList();
    private ServerPackStatus packStatus = ServerPackStatus.PROMPT;
    @Nullable
    private byte[] iconBytes;
    private Type type;
    private State state = State.INITIAL;
    public ExtendedServerListData neoForgeData = null;

    public ServerData(String p_105375_, String p_105376_, Type p_295587_) {
        this.name = p_105375_;
        this.ip = p_105376_;
        this.type = p_295587_;
    }

    public CompoundTag write() {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("name", this.name);
        compoundtag.putString("ip", this.ip);
        compoundtag.storeNullable("icon", ExtraCodecs.BASE64_STRING, this.iconBytes);
        compoundtag.store(ServerPackStatus.FIELD_CODEC, this.packStatus);
        return compoundtag;
    }

    public ServerPackStatus getResourcePackStatus() {
        return this.packStatus;
    }

    public void setResourcePackStatus(ServerPackStatus p_105380_) {
        this.packStatus = p_105380_;
    }

    public static ServerData read(CompoundTag p_105386_) {
        ServerData serverdata = new ServerData(p_105386_.getStringOr("name", ""), p_105386_.getStringOr("ip", ""), Type.OTHER);
        serverdata.setIconBytes(p_105386_.read("icon", ExtraCodecs.BASE64_STRING).orElse(null));
        serverdata.setResourcePackStatus(p_105386_.read(ServerPackStatus.FIELD_CODEC).orElse(ServerPackStatus.PROMPT));
        return serverdata;
    }

    @Nullable
    public byte[] getIconBytes() {
        return this.iconBytes;
    }

    public void setIconBytes(@Nullable byte[] p_272760_) {
        this.iconBytes = p_272760_;
    }

    public boolean isLan() {
        return this.type == Type.LAN;
    }

    public boolean isRealm() {
        return this.type == Type.REALM;
    }

    public Type type() {
        return this.type;
    }

    public void copyNameIconFrom(ServerData p_233804_) {
        this.ip = p_233804_.ip;
        this.name = p_233804_.name;
        this.iconBytes = p_233804_.iconBytes;
    }

    public void copyFrom(ServerData p_105382_) {
        this.copyNameIconFrom(p_105382_);
        this.setResourcePackStatus(p_105382_.getResourcePackStatus());
        this.type = p_105382_.type;
    }

    public State state() {
        return this.state;
    }

    public void setState(State p_316214_) {
        this.state = p_316214_;
    }

    @Nullable
    public static byte[] validateIcon(@Nullable byte[] p_302394_) {
        if (p_302394_ != null) {
            try {
                PngInfo pnginfo = PngInfo.fromBytes(p_302394_);
                if (pnginfo.width() <= 1024 && pnginfo.height() <= 1024) {
                    return p_302394_;
                }
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to decode server icon", (Throwable)ioexception);
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ServerPackStatus {
        ENABLED("enabled"),
        DISABLED("disabled"),
        PROMPT("prompt");

        public static final MapCodec<ServerPackStatus> FIELD_CODEC;
        private final Component name;

        private ServerPackStatus(String p_105399_) {
            this.name = Component.translatable("addServer.resourcePack." + p_105399_);
        }

        public Component getName() {
            return this.name;
        }

        static {
            FIELD_CODEC = Codec.BOOL.optionalFieldOf("acceptTextures").xmap(p_404910_ -> p_404910_.map(p_404952_ -> p_404952_ != false ? ENABLED : DISABLED).orElse(PROMPT), p_405078_ -> switch (p_405078_.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Optional.of(true);
                case 1 -> Optional.of(false);
                case 2 -> Optional.empty();
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum State {
        INITIAL,
        PINGING,
        UNREACHABLE,
        INCOMPATIBLE,
        SUCCESSFUL;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        LAN,
        REALM,
        OTHER;

    }
}

