/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.Splitter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.server.network.LegacyProtocolUtils;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LegacyServerPinger
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Splitter SPLITTER = Splitter.on((char)'\u0000').limit(6);
    private final ServerAddress address;
    private final Output output;

    public LegacyServerPinger(ServerAddress p_295697_, Output p_295291_) {
        this.address = p_295697_;
        this.output = p_295291_;
    }

    public void channelActive(ChannelHandlerContext p_294106_) throws Exception {
        super.channelActive(p_294106_);
        ByteBuf bytebuf = p_294106_.alloc().buffer();
        try {
            bytebuf.writeByte(254);
            bytebuf.writeByte(1);
            bytebuf.writeByte(250);
            LegacyProtocolUtils.writeLegacyString(bytebuf, "MC|PingHost");
            int i = bytebuf.writerIndex();
            bytebuf.writeShort(0);
            int j = bytebuf.writerIndex();
            bytebuf.writeByte(127);
            LegacyProtocolUtils.writeLegacyString(bytebuf, this.address.getHost());
            bytebuf.writeInt(this.address.getPort());
            int k = bytebuf.writerIndex() - j;
            bytebuf.setShort(i, k);
            p_294106_.channel().writeAndFlush((Object)bytebuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        catch (Exception exception) {
            bytebuf.release();
            throw exception;
        }
    }

    protected void channelRead0(ChannelHandlerContext p_295830_, ByteBuf p_294393_) {
        String s;
        List list;
        short short1 = p_294393_.readUnsignedByte();
        if (short1 == 255 && "\u00a71".equals((list = SPLITTER.splitToList((CharSequence)(s = LegacyProtocolUtils.readLegacyString(p_294393_)))).get(0))) {
            int i = Mth.getInt((String)list.get(1), 0);
            String s1 = (String)list.get(2);
            String s2 = (String)list.get(3);
            int j = Mth.getInt((String)list.get(4), -1);
            int k = Mth.getInt((String)list.get(5), -1);
            this.output.handleResponse(i, s1, s2, j, k);
        }
        p_295830_.close();
    }

    public void exceptionCaught(ChannelHandlerContext p_296319_, Throwable p_296239_) {
        p_296319_.close();
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface Output {
        public void handleResponse(int var1, String var2, String var3, int var4, int var5);
    }
}

