/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CacheSlot<C extends Cleaner<C>, D> {
    private final Function<C, D> operation;
    @Nullable
    private C context;
    @Nullable
    private D value;

    public CacheSlot(Function<C, D> p_399634_) {
        this.operation = p_399634_;
    }

    public D compute(C p_399903_) {
        if (p_399903_ == this.context && this.value != null) {
            return this.value;
        }
        D d = this.operation.apply(p_399903_);
        this.value = d;
        this.context = p_399903_;
        p_399903_.registerForCleaning(this);
        return d;
    }

    public void clear() {
        this.value = null;
        this.context = null;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface Cleaner<C extends Cleaner<C>> {
        public void registerForCleaning(CacheSlot<C, ?> var1);
    }
}

