/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model.dragon;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EnderDragonRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnderDragonModel
extends EntityModel<EnderDragonRenderState> {
    private static final int NECK_PART_COUNT = 5;
    private static final int TAIL_PART_COUNT = 12;
    private final ModelPart head;
    private final ModelPart[] neckParts = new ModelPart[5];
    private final ModelPart[] tailParts = new ModelPart[12];
    private final ModelPart jaw;
    private final ModelPart body;
    private final ModelPart leftWing;
    private final ModelPart leftWingTip;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftFrontLegTip;
    private final ModelPart leftFrontFoot;
    private final ModelPart leftRearLeg;
    private final ModelPart leftRearLegTip;
    private final ModelPart leftRearFoot;
    private final ModelPart rightWing;
    private final ModelPart rightWingTip;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightFrontLegTip;
    private final ModelPart rightFrontFoot;
    private final ModelPart rightRearLeg;
    private final ModelPart rightRearLegTip;
    private final ModelPart rightRearFoot;

    private static String neckName(int p_361031_) {
        return "neck" + p_361031_;
    }

    private static String tailName(int p_360619_) {
        return "tail" + p_360619_;
    }

    public EnderDragonModel(ModelPart p_361417_) {
        super(p_361417_);
        this.head = p_361417_.getChild("head");
        this.jaw = this.head.getChild("jaw");
        for (int i = 0; i < this.neckParts.length; ++i) {
            this.neckParts[i] = p_361417_.getChild(EnderDragonModel.neckName(i));
        }
        for (int j = 0; j < this.tailParts.length; ++j) {
            this.tailParts[j] = p_361417_.getChild(EnderDragonModel.tailName(j));
        }
        this.body = p_361417_.getChild("body");
        this.leftWing = this.body.getChild("left_wing");
        this.leftWingTip = this.leftWing.getChild("left_wing_tip");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.leftFrontLegTip = this.leftFrontLeg.getChild("left_front_leg_tip");
        this.leftFrontFoot = this.leftFrontLegTip.getChild("left_front_foot");
        this.leftRearLeg = this.body.getChild("left_hind_leg");
        this.leftRearLegTip = this.leftRearLeg.getChild("left_hind_leg_tip");
        this.leftRearFoot = this.leftRearLegTip.getChild("left_hind_foot");
        this.rightWing = this.body.getChild("right_wing");
        this.rightWingTip = this.rightWing.getChild("right_wing_tip");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.rightFrontLegTip = this.rightFrontLeg.getChild("right_front_leg_tip");
        this.rightFrontFoot = this.rightFrontLegTip.getChild("right_front_foot");
        this.rightRearLeg = this.body.getChild("right_hind_leg");
        this.rightRearLegTip = this.rightRearLeg.getChild("right_hind_leg_tip");
        this.rightRearFoot = this.rightRearLegTip.getChild("right_hind_foot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float f = -16.0f;
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().addBox("upperlip", -6.0f, -1.0f, -24.0f, 12, 5, 16, 176, 44).addBox("upperhead", -8.0f, -8.0f, -10.0f, 16, 16, 16, 112, 30).mirror().addBox("scale", -5.0f, -12.0f, -4.0f, 2, 4, 6, 0, 0).addBox("nostril", -5.0f, -3.0f, -22.0f, 2, 2, 4, 112, 0).mirror().addBox("scale", 3.0f, -12.0f, -4.0f, 2, 4, 6, 0, 0).addBox("nostril", 3.0f, -3.0f, -22.0f, 2, 2, 4, 112, 0), PartPose.offset(0.0f, 20.0f, -62.0f));
        partdefinition1.addOrReplaceChild("jaw", CubeListBuilder.create().addBox("jaw", -6.0f, 0.0f, -16.0f, 12, 4, 16, 176, 65), PartPose.offset(0.0f, 4.0f, -8.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().addBox("box", -5.0f, -5.0f, -5.0f, 10, 10, 10, 192, 104).addBox("scale", -1.0f, -9.0f, -3.0f, 2, 4, 6, 48, 0);
        for (int i = 0; i < 5; ++i) {
            partdefinition.addOrReplaceChild(EnderDragonModel.neckName(i), cubelistbuilder, PartPose.offset(0.0f, 20.0f, -12.0f - (float)i * 10.0f));
        }
        for (int j = 0; j < 12; ++j) {
            partdefinition.addOrReplaceChild(EnderDragonModel.tailName(j), cubelistbuilder, PartPose.offset(0.0f, 10.0f, 60.0f + (float)j * 10.0f));
        }
        PartDefinition partdefinition12 = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().addBox("body", -12.0f, 1.0f, -16.0f, 24, 24, 64, 0, 0).addBox("scale", -1.0f, -5.0f, -10.0f, 2, 6, 12, 220, 53).addBox("scale", -1.0f, -5.0f, 10.0f, 2, 6, 12, 220, 53).addBox("scale", -1.0f, -5.0f, 30.0f, 2, 6, 12, 220, 53), PartPose.offset(0.0f, 3.0f, 8.0f));
        PartDefinition partdefinition2 = partdefinition12.addOrReplaceChild("left_wing", CubeListBuilder.create().mirror().addBox("bone", 0.0f, -4.0f, -4.0f, 56, 8, 8, 112, 88).addBox("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, -56, 88), PartPose.offset(12.0f, 2.0f, -6.0f));
        partdefinition2.addOrReplaceChild("left_wing_tip", CubeListBuilder.create().mirror().addBox("bone", 0.0f, -2.0f, -2.0f, 56, 4, 4, 112, 136).addBox("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, -56, 144), PartPose.offset(56.0f, 0.0f, 0.0f));
        PartDefinition partdefinition3 = partdefinition12.addOrReplaceChild("left_front_leg", CubeListBuilder.create().addBox("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, 112, 104), PartPose.offsetAndRotation(12.0f, 17.0f, -6.0f, 1.3f, 0.0f, 0.0f));
        PartDefinition partdefinition4 = partdefinition3.addOrReplaceChild("left_front_leg_tip", CubeListBuilder.create().addBox("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, 226, 138), PartPose.offsetAndRotation(0.0f, 20.0f, -1.0f, -0.5f, 0.0f, 0.0f));
        partdefinition4.addOrReplaceChild("left_front_foot", CubeListBuilder.create().addBox("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, 144, 104), PartPose.offsetAndRotation(0.0f, 23.0f, 0.0f, 0.75f, 0.0f, 0.0f));
        PartDefinition partdefinition5 = partdefinition12.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().addBox("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, 0, 0), PartPose.offsetAndRotation(16.0f, 13.0f, 34.0f, 1.0f, 0.0f, 0.0f));
        PartDefinition partdefinition6 = partdefinition5.addOrReplaceChild("left_hind_leg_tip", CubeListBuilder.create().addBox("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, 196, 0), PartPose.offsetAndRotation(0.0f, 32.0f, -4.0f, 0.5f, 0.0f, 0.0f));
        partdefinition6.addOrReplaceChild("left_hind_foot", CubeListBuilder.create().addBox("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 112, 0), PartPose.offsetAndRotation(0.0f, 31.0f, 4.0f, 0.75f, 0.0f, 0.0f));
        PartDefinition partdefinition7 = partdefinition12.addOrReplaceChild("right_wing", CubeListBuilder.create().addBox("bone", -56.0f, -4.0f, -4.0f, 56, 8, 8, 112, 88).addBox("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, -56, 88), PartPose.offset(-12.0f, 2.0f, -6.0f));
        partdefinition7.addOrReplaceChild("right_wing_tip", CubeListBuilder.create().addBox("bone", -56.0f, -2.0f, -2.0f, 56, 4, 4, 112, 136).addBox("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, -56, 144), PartPose.offset(-56.0f, 0.0f, 0.0f));
        PartDefinition partdefinition8 = partdefinition12.addOrReplaceChild("right_front_leg", CubeListBuilder.create().addBox("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, 112, 104), PartPose.offsetAndRotation(-12.0f, 17.0f, -6.0f, 1.3f, 0.0f, 0.0f));
        PartDefinition partdefinition9 = partdefinition8.addOrReplaceChild("right_front_leg_tip", CubeListBuilder.create().addBox("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, 226, 138), PartPose.offsetAndRotation(0.0f, 20.0f, -1.0f, -0.5f, 0.0f, 0.0f));
        partdefinition9.addOrReplaceChild("right_front_foot", CubeListBuilder.create().addBox("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, 144, 104), PartPose.offsetAndRotation(0.0f, 23.0f, 0.0f, 0.75f, 0.0f, 0.0f));
        PartDefinition partdefinition10 = partdefinition12.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().addBox("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, 0, 0), PartPose.offsetAndRotation(-16.0f, 13.0f, 34.0f, 1.0f, 0.0f, 0.0f));
        PartDefinition partdefinition11 = partdefinition10.addOrReplaceChild("right_hind_leg_tip", CubeListBuilder.create().addBox("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, 196, 0), PartPose.offsetAndRotation(0.0f, 32.0f, -4.0f, 0.5f, 0.0f, 0.0f));
        partdefinition11.addOrReplaceChild("right_hind_foot", CubeListBuilder.create().addBox("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 112, 0), PartPose.offsetAndRotation(0.0f, 31.0f, 4.0f, 0.75f, 0.0f, 0.0f));
        return LayerDefinition.create(meshdefinition, 256, 256);
    }

    @Override
    public void setupAnim(EnderDragonRenderState p_360968_) {
        super.setupAnim(p_360968_);
        float f = p_360968_.flapTime * ((float)Math.PI * 2);
        this.jaw.xRot = (Mth.sin(f) + 1.0f) * 0.2f;
        float f1 = Mth.sin(f - 1.0f) + 1.0f;
        f1 = (f1 * f1 + f1 * 2.0f) * 0.05f;
        this.root.y = (f1 - 2.0f) * 16.0f;
        this.root.z = -48.0f;
        this.root.xRot = f1 * 2.0f * ((float)Math.PI / 180);
        float f2 = this.neckParts[0].x;
        float f3 = this.neckParts[0].y;
        float f4 = this.neckParts[0].z;
        float f5 = 1.5f;
        DragonFlightHistory.Sample dragonflighthistory$sample = p_360968_.getHistoricalPos(6);
        float f6 = Mth.wrapDegrees(p_360968_.getHistoricalPos(5).yRot() - p_360968_.getHistoricalPos(10).yRot());
        float f7 = Mth.wrapDegrees(p_360968_.getHistoricalPos(5).yRot() + f6 / 2.0f);
        for (int i = 0; i < 5; ++i) {
            ModelPart modelpart = this.neckParts[i];
            DragonFlightHistory.Sample dragonflighthistory$sample1 = p_360968_.getHistoricalPos(5 - i);
            float f8 = Mth.cos((float)i * 0.45f + f) * 0.15f;
            modelpart.yRot = Mth.wrapDegrees(dragonflighthistory$sample1.yRot() - dragonflighthistory$sample.yRot()) * ((float)Math.PI / 180) * 1.5f;
            modelpart.xRot = f8 + p_360968_.getHeadPartYOffset(i, dragonflighthistory$sample, dragonflighthistory$sample1) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            modelpart.zRot = -Mth.wrapDegrees(dragonflighthistory$sample1.yRot() - f7) * ((float)Math.PI / 180) * 1.5f;
            modelpart.y = f3;
            modelpart.z = f4;
            modelpart.x = f2;
            f2 -= Mth.sin(modelpart.yRot) * Mth.cos(modelpart.xRot) * 10.0f;
            f3 += Mth.sin(modelpart.xRot) * 10.0f;
            f4 -= Mth.cos(modelpart.yRot) * Mth.cos(modelpart.xRot) * 10.0f;
        }
        this.head.y = f3;
        this.head.z = f4;
        this.head.x = f2;
        DragonFlightHistory.Sample dragonflighthistory$sample2 = p_360968_.getHistoricalPos(0);
        this.head.yRot = Mth.wrapDegrees(dragonflighthistory$sample2.yRot() - dragonflighthistory$sample.yRot()) * ((float)Math.PI / 180);
        this.head.xRot = Mth.wrapDegrees(p_360968_.getHeadPartYOffset(6, dragonflighthistory$sample, dragonflighthistory$sample2)) * ((float)Math.PI / 180) * 1.5f * 5.0f;
        this.head.zRot = -Mth.wrapDegrees(dragonflighthistory$sample2.yRot() - f7) * ((float)Math.PI / 180);
        this.body.zRot = -f6 * 1.5f * ((float)Math.PI / 180);
        this.leftWing.xRot = 0.125f - Mth.cos(f) * 0.2f;
        this.leftWing.yRot = -0.25f;
        this.leftWing.zRot = -(Mth.sin(f) + 0.125f) * 0.8f;
        this.leftWingTip.zRot = (Mth.sin(f + 2.0f) + 0.5f) * 0.75f;
        this.rightWing.xRot = this.leftWing.xRot;
        this.rightWing.yRot = -this.leftWing.yRot;
        this.rightWing.zRot = -this.leftWing.zRot;
        this.rightWingTip.zRot = -this.leftWingTip.zRot;
        this.poseLimbs(f1, this.leftFrontLeg, this.leftFrontLegTip, this.leftFrontFoot, this.leftRearLeg, this.leftRearLegTip, this.leftRearFoot);
        this.poseLimbs(f1, this.rightFrontLeg, this.rightFrontLegTip, this.rightFrontFoot, this.rightRearLeg, this.rightRearLegTip, this.rightRearFoot);
        float f9 = 0.0f;
        f3 = this.tailParts[0].y;
        f4 = this.tailParts[0].z;
        f2 = this.tailParts[0].x;
        dragonflighthistory$sample = p_360968_.getHistoricalPos(11);
        for (int j = 0; j < 12; ++j) {
            DragonFlightHistory.Sample dragonflighthistory$sample3 = p_360968_.getHistoricalPos(12 + j);
            ModelPart modelpart1 = this.tailParts[j];
            modelpart1.yRot = (Mth.wrapDegrees(dragonflighthistory$sample3.yRot() - dragonflighthistory$sample.yRot()) * 1.5f + 180.0f) * ((float)Math.PI / 180);
            modelpart1.xRot = (f9 += Mth.sin((float)j * 0.45f + f) * 0.05f) + (float)(dragonflighthistory$sample3.y() - dragonflighthistory$sample.y()) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            modelpart1.zRot = Mth.wrapDegrees(dragonflighthistory$sample3.yRot() - f7) * ((float)Math.PI / 180) * 1.5f;
            modelpart1.y = f3;
            modelpart1.z = f4;
            modelpart1.x = f2;
            f3 += Mth.sin(modelpart1.xRot) * 10.0f;
            f4 -= Mth.cos(modelpart1.yRot) * Mth.cos(modelpart1.xRot) * 10.0f;
            f2 -= Mth.sin(modelpart1.yRot) * Mth.cos(modelpart1.xRot) * 10.0f;
        }
    }

    private void poseLimbs(float p_363142_, ModelPart p_362750_, ModelPart p_364979_, ModelPart p_362786_, ModelPart p_363025_, ModelPart p_360492_, ModelPart p_363358_) {
        p_363025_.xRot = 1.0f + p_363142_ * 0.1f;
        p_360492_.xRot = 0.5f + p_363142_ * 0.1f;
        p_363358_.xRot = 0.75f + p_363142_ * 0.1f;
        p_362750_.xRot = 1.3f + p_363142_ * 0.1f;
        p_364979_.xRot = -0.5f - p_363142_ * 0.1f;
        p_362786_.xRot = 0.75f + p_363142_ * 0.1f;
    }
}

