/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WolfModel
extends EntityModel<WolfRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private static final String REAL_HEAD = "real_head";
    private static final String UPPER_BODY = "upper_body";
    private static final String REAL_TAIL = "real_tail";
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart upperBody;
    private static final int LEG_SIZE = 8;

    public WolfModel(ModelPart p_171087_) {
        super(p_171087_);
        this.head = p_171087_.getChild("head");
        this.realHead = this.head.getChild(REAL_HEAD);
        this.body = p_171087_.getChild("body");
        this.upperBody = p_171087_.getChild(UPPER_BODY);
        this.rightHindLeg = p_171087_.getChild("right_hind_leg");
        this.leftHindLeg = p_171087_.getChild("left_hind_leg");
        this.rightFrontLeg = p_171087_.getChild("right_front_leg");
        this.leftFrontLeg = p_171087_.getChild("left_front_leg");
        this.tail = p_171087_.getChild("tail");
        this.realTail = this.tail.getChild(REAL_TAIL);
    }

    public static MeshDefinition createMeshDefinition(CubeDeformation p_316269_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float f = 13.5f;
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset(-1.0f, 13.5f, -7.0f));
        partdefinition1.addOrReplaceChild(REAL_HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, p_316269_).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, p_316269_).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, p_316269_).texOffs(0, 10).addBox(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, p_316269_), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, p_316269_), PartPose.offsetAndRotation(0.0f, 14.0f, 2.0f, 1.5707964f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild(UPPER_BODY, CubeListBuilder.create().texOffs(21, 0).addBox(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, p_316269_), PartPose.offsetAndRotation(-1.0f, 14.0f, -3.0f, 1.5707964f, 0.0f, 0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, p_316269_);
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.create().mirror().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, p_316269_);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder1, PartPose.offset(-2.5f, 16.0f, 7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset(0.5f, 16.0f, 7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder1, PartPose.offset(-2.5f, 16.0f, -4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset(0.5f, 16.0f, -4.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation(-1.0f, 12.0f, 8.0f, 0.62831855f, 0.0f, 0.0f));
        partdefinition2.addOrReplaceChild(REAL_TAIL, CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, p_316269_), PartPose.ZERO);
        return meshdefinition;
    }

    @Override
    public void setupAnim(WolfRenderState p_365164_) {
        super.setupAnim(p_365164_);
        float f = p_365164_.walkAnimationPos;
        float f1 = p_365164_.walkAnimationSpeed;
        this.tail.yRot = p_365164_.isAngry ? 0.0f : Mth.cos(f * 0.6662f) * 1.4f * f1;
        if (p_365164_.isSitting) {
            float f2 = p_365164_.ageScale;
            this.upperBody.y += 2.0f * f2;
            this.upperBody.xRot = 1.2566371f;
            this.upperBody.yRot = 0.0f;
            this.body.y += 4.0f * f2;
            this.body.z -= 2.0f * f2;
            this.body.xRot = 0.7853982f;
            this.tail.y += 9.0f * f2;
            this.tail.z -= 2.0f * f2;
            this.rightHindLeg.y += 6.7f * f2;
            this.rightHindLeg.z -= 5.0f * f2;
            this.rightHindLeg.xRot = 4.712389f;
            this.leftHindLeg.y += 6.7f * f2;
            this.leftHindLeg.z -= 5.0f * f2;
            this.leftHindLeg.xRot = 4.712389f;
            this.rightFrontLeg.xRot = 5.811947f;
            this.rightFrontLeg.x += 0.01f * f2;
            this.rightFrontLeg.y += 1.0f * f2;
            this.leftFrontLeg.xRot = 5.811947f;
            this.leftFrontLeg.x -= 0.01f * f2;
            this.leftFrontLeg.y += 1.0f * f2;
        } else {
            this.rightHindLeg.xRot = Mth.cos(f * 0.6662f) * 1.4f * f1;
            this.leftHindLeg.xRot = Mth.cos(f * 0.6662f + (float)Math.PI) * 1.4f * f1;
            this.rightFrontLeg.xRot = Mth.cos(f * 0.6662f + (float)Math.PI) * 1.4f * f1;
            this.leftFrontLeg.xRot = Mth.cos(f * 0.6662f) * 1.4f * f1;
        }
        this.realHead.zRot = p_365164_.headRollAngle + p_365164_.getBodyRollAngle(0.0f);
        this.upperBody.zRot = p_365164_.getBodyRollAngle(-0.08f);
        this.body.zRot = p_365164_.getBodyRollAngle(-0.16f);
        this.realTail.zRot = p_365164_.getBodyRollAngle(-0.2f);
        this.head.xRot = p_365164_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_365164_.yRot * ((float)Math.PI / 180);
        this.tail.xRot = p_365164_.tailAngle;
    }
}

