/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.TropicalFishRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TropicalFishModelA
extends EntityModel<TropicalFishRenderState> {
    private final ModelPart tail;

    public TropicalFishModelA(ModelPart p_171020_) {
        super(p_171020_);
        this.tail = p_171020_.getChild("tail");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation p_171022_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 22;
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, p_171022_), PartPose.offset(0.0f, 22.0f, 0.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, -6).addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, p_171022_), PartPose.offset(0.0f, 22.0f, 3.0f));
        partdefinition.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(2, 16).addBox(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, p_171022_), PartPose.offsetAndRotation(-1.0f, 22.5f, 0.0f, 0.0f, 0.7853982f, 0.0f));
        partdefinition.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(2, 12).addBox(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, p_171022_), PartPose.offsetAndRotation(1.0f, 22.5f, 0.0f, 0.0f, -0.7853982f, 0.0f));
        partdefinition.addOrReplaceChild("top_fin", CubeListBuilder.create().texOffs(10, -5).addBox(0.0f, -3.0f, 0.0f, 0.0f, 3.0f, 6.0f, p_171022_), PartPose.offset(0.0f, 20.5f, -3.0f));
        return LayerDefinition.create(meshdefinition, 32, 32);
    }

    @Override
    public void setupAnim(TropicalFishRenderState p_365135_) {
        super.setupAnim(p_365135_);
        float f = p_365135_.isInWater ? 1.0f : 1.5f;
        this.tail.yRot = -f * 0.45f * Mth.sin(0.6f * p_365135_.ageInTicks);
    }
}

