/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpinAttackEffectModel
extends EntityModel<PlayerRenderState> {
    private static final int BOX_COUNT = 2;
    private final ModelPart[] boxes = new ModelPart[2];

    public SpinAttackEffectModel(ModelPart p_368741_) {
        super(p_368741_);
        for (int i = 0; i < 2; ++i) {
            this.boxes[i] = p_368741_.getChild(SpinAttackEffectModel.boxName(i));
        }
    }

    private static String boxName(int p_368647_) {
        return "box" + p_368647_;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        for (int i = 0; i < 2; ++i) {
            float f = -3.2f + 9.6f * (float)(i + 1);
            float f1 = 0.75f * (float)(i + 1);
            partdefinition.addOrReplaceChild(SpinAttackEffectModel.boxName(i), CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -16.0f + f, -8.0f, 16.0f, 32.0f, 16.0f), PartPose.ZERO.withScale(f1));
        }
        return LayerDefinition.create(meshdefinition, 64, 64);
    }

    @Override
    public void setupAnim(PlayerRenderState p_368555_) {
        super.setupAnim(p_368555_);
        for (int i = 0; i < this.boxes.length; ++i) {
            float f = p_368555_.ageInTicks * (float)(-(45 + (i + 1) * 5));
            this.boxes[i].yRot = Mth.wrapDegrees(f) * ((float)Math.PI / 180);
        }
    }
}

